/*
 * Decompiled with CFR 0.152.
 */
package com.luues.logs.interfaces;

import java.util.logging.Level;
import java.util.logging.Logger;

public interface OperatorBackFactory<T> {
    public T getValue();

    public static final class Default<T>
    implements OperatorBackFactory<T> {
        final Logger logger;
        final T constant;

        public Default(T constant) {
            this(constant, Logger.getLogger(Default.class.getName()));
        }

        Default(T constant, Logger logger) {
            this.constant = constant;
            this.logger = logger;
        }

        @Override
        public T getValue() {
            if (this.logger.isLoggable(Level.FINE)) {
                this.logger.log(Level.FINE, "fallback due to");
            }
            return this.constant;
        }

        public String toString() {
            return this.constant.toString();
        }
    }
}

