/*
 * Decompiled with CFR 0.152.
 */
package com.luues.logs.service;

import com.luues.jdbc.plus.core.metadata.TableInfoHelper;
import com.luues.logs.entity.OperationLog;
import com.luues.logs.service.Broker;
import com.luues.logs.service.OperationLogService;
import java.util.List;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.scheduling.annotation.EnableAsync;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@Component
@EnableAsync
@EnableScheduling
public class BrokerServer {
    @Autowired
    private OperationLogService operationLogService;

    @PostConstruct
    public void init() {
        this.operationLogService.update(String.format("create table if not exists %s (  `log_id` bigint(20) NOT NULL COMMENT '\u65e5\u5fd7\u4e3b\u952eid',\n  `operation_id` varchar(25) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '\u64cd\u4f5c\u4ebaid',\n  `operation_account` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '\u64cd\u4f5c\u4eba\u8d26\u53f7',\n  `operation_name` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '\u64cd\u4f5c\u4eba\u540d\u79f0',\n  `operation_ip` varchar(20) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '\u64cd\u4f5c\u4ebaip',\n  `operation_date` datetime(0) NULL DEFAULT NULL COMMENT '\u64cd\u4f5c\u65f6\u95f4',\n  `request_url` varchar(100) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '\u8bf7\u6c42\u5730\u5740',\n  `request_method` varchar(20) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '\u8bf7\u6c42\u65b9\u5f0f',\n  `request_params` longtext CHARACTER SET utf8 COLLATE utf8_general_ci NULL COMMENT '\u8bf7\u6c42\u53c2\u6570',\n  `request_class` varchar(100) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '\u8bf7\u6c42\u7c7b\u65b9\u6cd5',\n  `operation_msg` varchar(150) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '\u64cd\u4f5c\u63cf\u8ff0',\n  `operation_type` varchar(10) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '\u64cd\u4f5c\u7c7b\u578b',\n  `operation_time` bigint(20) NULL DEFAULT NULL COMMENT '\u6267\u884c\u65f6\u95f4',\n  `request_result` longtext CHARACTER SET utf8 COLLATE utf8_general_ci NULL COMMENT '\u8fd4\u56de\u7ed3\u679c',\n  `request_code` int(5) NULL DEFAULT NULL COMMENT '\u8fd4\u56de\u7f16\u7801',\n  `create_date` datetime(0) NULL DEFAULT NULL COMMENT '\u521b\u5efa\u65f6\u95f4',\n  PRIMARY KEY (`log_id`) USING BTREE) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci ROW_FORMAT = Dynamic", TableInfoHelper.getTableInfo(OperationLog.class).getTableName()));
    }

    @Scheduled(fixedRate=200L)
    @Async
    public void consumeMessage() {
        try {
            List<OperationLog> operationLogList = Broker.consume();
            if (operationLogList.size() == 0) {
                return;
            }
            this.operationLogService.saveBatch(operationLogList);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

