/*
 * Decompiled with CFR 0.152.
 */
package com.luues.swagger.config;

import cn.luues.tool.core.util.ClassUtil;
import cn.luues.tool.core.util.StrUtil;
import cn.luues.tool.json.JsonUtils;
import com.luues.core.config.CoreProperties;
import com.luues.core.core.SpringContextHolder;
import com.luues.core.secondary.SystemInfo;
import com.luues.swagger.annotation.EnableSwagger;
import com.luues.swagger.annotation.ProfilesType;
import com.luues.swagger.config.SwaggerConfig;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Set;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import springfox.documentation.builders.ApiInfoBuilder;
import springfox.documentation.builders.PathSelectors;
import springfox.documentation.builders.RequestHandlerSelectors;
import springfox.documentation.service.ApiInfo;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spring.web.plugins.Docket;
import springfox.documentation.swagger2.annotations.EnableSwagger2WebMvc;

@EnableSwagger2WebMvc
@Configuration
public class Swagger2 {
    private static final Logger log = LoggerFactory.getLogger((String)"c.l.s.c.s");
    private SwaggerConfig swaggerConfig = new SwaggerConfig();

    @PostConstruct
    public void init() {
        CoreProperties coreProperties = (CoreProperties)SpringContextHolder.getBean(CoreProperties.class);
        Set set = ClassUtil.scanPackageByAnnotation((String)coreProperties.getPackageName(), EnableSwagger.class);
        if (set.size() == 1) {
            Method[] methods;
            Class mainClass = (Class)set.iterator().next();
            EnableSwagger enableSwagger = mainClass.getAnnotation(EnableSwagger.class);
            for (Method method : methods = EnableSwagger.class.getDeclaredMethods()) {
                Method setMethod = SwaggerConfig.class.getMethod("set" + StrUtil.upperFirst((CharSequence)method.getName()), method.getDefaultValue().getClass());
                setMethod.invoke((Object)this.swaggerConfig, method.invoke((Object)enableSwagger, new Object[0]));
            }
        } else {
            Method[] methods;
            for (Method method : methods = EnableSwagger.class.getDeclaredMethods()) {
                Method setMethod = SwaggerConfig.class.getMethod("set" + StrUtil.upperFirst((CharSequence)method.getName()), method.getDefaultValue().getClass());
                setMethod.invoke((Object)this.swaggerConfig, method.getDefaultValue());
            }
        }
        log.info("@EnableSwagger is : {}", (Object)JsonUtils.toJson((Object)this.swaggerConfig));
    }

    @Bean
    public Docket createRestApi() {
        if (Arrays.asList(this.swaggerConfig.getProfiles()).contains(SystemInfo.getActive().toUpperCase()) || Arrays.asList(this.swaggerConfig.getProfiles()).contains((Object)ProfilesType.DLT)) {
            log.info("{}", (Object)("\n{\n\u3000\u3000\u3000\u3000\u3000swagger configuration startup \n\u3000\u3000\u3000\u3000\u3000swagger access host --> " + (StrUtil.isBlank((CharSequence)this.swaggerConfig.getHost()) ? SystemInfo.getHost() + ":" + SystemInfo.getPort() : this.swaggerConfig.getHost()) + " \n\u3000\u3000\u3000\u3000\u3000swagger version --> " + this.swaggerConfig.getVersion() + " \n\u3000\u3000\u3000\u3000\u3000swagger loading ApiOperation.class \n\u3000\u3000\u3000\u3000\u3000swagger config from server at http://" + (StrUtil.isBlank((CharSequence)this.swaggerConfig.getHost()) ? SystemInfo.getHost() + ":" + SystemInfo.getPort() : this.swaggerConfig.getHost()) + "/doc.html \n}"));
            if (StrUtil.isBlank((CharSequence)this.swaggerConfig.getScanPackage())) {
                return new Docket(DocumentationType.SWAGGER_2).host(StrUtil.isBlank((CharSequence)this.swaggerConfig.getHost()) ? SystemInfo.getHost() + ":" + SystemInfo.getPort() : this.swaggerConfig.getHost()).groupName(this.swaggerConfig.getName()).apiInfo(this.apiInfo()).select().apis(RequestHandlerSelectors.withClassAnnotation(Api.class)).apis(RequestHandlerSelectors.withMethodAnnotation(ApiOperation.class)).paths(PathSelectors.any()).build();
            }
            return new Docket(DocumentationType.SWAGGER_2).host(StrUtil.isBlank((CharSequence)this.swaggerConfig.getHost()) ? SystemInfo.getHost() + ":" + SystemInfo.getPort() : this.swaggerConfig.getHost()).groupName(this.swaggerConfig.getName()).apiInfo(this.apiInfo()).select().apis(RequestHandlerSelectors.basePackage((String)this.swaggerConfig.getScanPackage())).paths(PathSelectors.any()).build();
        }
        return new Docket(DocumentationType.SWAGGER_2).groupName(this.swaggerConfig.getName()).apiInfo(this.apiInfo()).select().apis(RequestHandlerSelectors.basePackage((String)"wdyNotPackage")).paths(PathSelectors.any()).build();
    }

    private ApiInfo apiInfo() {
        return new ApiInfoBuilder().title(this.swaggerConfig.getTitle()).contact(this.swaggerConfig.getContact()).version(this.swaggerConfig.getVersion()).description(this.swaggerConfig.getDescription()).build();
    }
}

