package com.luues.redis.cluster.aspect;

import com.luues.exception.ExceptionRediscacheInvalid;
import com.luues.exception.ExceptionRediscacheKeyInvalid;
import com.luues.exception.ExceptionRedissynchroizedInvalid;
import com.luues.redis.cluster.cache.RedisClusterCache;
import com.luues.redis.cluster.cache.RedisClusterCacheEvict;
import com.luues.redis.cluster.cache.RedisClusterCachePut;
import com.luues.redis.cluster.lock.RedisClusterSynchroized;
import com.luues.redis.cluster.service.JedisClusterTemplate;
import com.luues.redis.single.cache.RedisCacheEvict;
import com.luues.redis.single.cache.RedisCachePut;
import com.luues.redis.single.lock.RedisSynchroized;
import com.luues.redis.util.CommontUtil;
import com.luues.util.encryption.SerializingUtil;
import com.luues.util.TypeConvert;
import com.luues.util.logs.LogUtil;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.LocalVariableTableParameterNameDiscoverer;
import org.springframework.expression.Expression;
import org.springframework.expression.ExpressionParser;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.StandardEvaluationContext;
import org.springframework.stereotype.Component;
import java.lang.reflect.Method;
import java.util.Iterator;

/**
 * 通过aspect实现注解Rediscache
 * redis实现注解缓存
 */
@Aspect
@Component
public class RedisClusterCacheAspect {
    @Autowired
    private JedisClusterTemplate jedisClusterTemplate;

    @Pointcut("@annotation(com.luues.redis.cluster.cache.RedisClusterCache)")
    public void clusterCacheAspect() {
    }
    @Around("clusterCacheAspect()")
    public Object clusterCacheAspect(ProceedingJoinPoint joinPoint) throws Throwable {
        Class<?> classTarget = joinPoint.getTarget().getClass();
        Class<?>[] par = ((MethodSignature) joinPoint.getSignature()).getParameterTypes();
        Method objMethod = classTarget.getMethod(joinPoint.getSignature().getName(), par);
        RedisClusterCache rediscache = objMethod.getAnnotation(RedisClusterCache.class);
        String key = null;
        Integer expire = null;
        String condition = null;
        if (rediscache != null) {
            key = rediscache.key();
            expire = rediscache.expire();
            condition = rediscache.condition();
        }
        String an = "@RedisClusterCache";
        if (TypeConvert.isNull(key)) {
            throw new ExceptionRediscacheKeyInvalid(an + " key() is not null!");
        }
        if (TypeConvert.isNull(expire)) {
            expire = -1;
        }
        Object[] objects = joinPoint.getArgs();
        String condition_ = "true";
        if (!TypeConvert.isNull(condition)) {
            condition_ = CommontUtil.getConditionOrKey(condition, objMethod, objects, an);
            condition_ = CommontUtil.valiCondition(condition_, an);
        }
        if (condition_.equals("true")) {
            String key_ = CommontUtil.getConditionOrKey(key, objMethod, objects, an);
            return CommontUtil.getRedisClusterCacheInfo(jedisClusterTemplate, key_, joinPoint, expire);
        }
        try {
            return joinPoint.proceed();
        } catch (Throwable throwable) {
            return null;
        }
    }


    @Pointcut("@annotation(com.luues.redis.cluster.cache.RedisClusterCachePut)")
    public void clusterCachePutAspect() {
    }
    @Around("clusterCachePutAspect()")
    public Object clusterCachePutAspect(ProceedingJoinPoint joinPoint) throws Throwable {
        Method objMethod = ((MethodSignature) joinPoint.getSignature()).getMethod();
        RedisClusterCachePut redisClusterCachePut = objMethod.getAnnotation(RedisClusterCachePut.class);
        String key = null;
        Integer expire = null;
        String condition = null;
        if (redisClusterCachePut != null) {
            key = redisClusterCachePut.key();
            expire = redisClusterCachePut.expire();
            condition = redisClusterCachePut.condition();
        }
        String an = "@RedisClusterCachePut";
        if (TypeConvert.isNull(key)) {
            throw new ExceptionRediscacheKeyInvalid(an + " key() is not null!");
        }
        if (TypeConvert.isNull(expire)) {
            expire = -1;
        }
        Object[] objects = joinPoint.getArgs();
        String condition_ = "true";
        if (!TypeConvert.isNull(condition)) {
            condition_ = CommontUtil.getConditionOrKey(condition, objMethod, objects, an);
            condition_ = CommontUtil.valiCondition(condition_, an);
        }
        if (condition_.equals("true")) {
            String key_ = CommontUtil.getConditionOrKey(key, objMethod, objects, an);
            Object object = joinPoint.proceed();
            if (expire >= 0) {
                jedisClusterTemplate.setex(key_.getBytes(), expire, SerializingUtil.serialize(object));
            } else {
                jedisClusterTemplate.set(key_.getBytes(), SerializingUtil.serialize(object));
            }
            LogUtil.debug("\n{\n{　　　　　The return data of this method has been updated by redis}\n}");
            return object;
        }
        try {
            return joinPoint.proceed();
        } catch (Throwable throwable) {
            return null;
        }
    }


    @Pointcut("@annotation(com.luues.redis.cluster.cache.RedisClusterCacheEvict)")
    public void clusterCacheEvictAspect() {
    }
    @Around("clusterCacheEvictAspect()")
    public Object clusterCacheEvictAspect(ProceedingJoinPoint joinPoint) throws Throwable {
        Method objMethod = ((MethodSignature) joinPoint.getSignature()).getMethod();
        RedisClusterCacheEvict redisClusterCacheEvict = objMethod.getAnnotation(RedisClusterCacheEvict.class);
        String[] keys = null;
        String condition = null;
        if (redisClusterCacheEvict != null) {
            keys = redisClusterCacheEvict.key();
            condition = redisClusterCacheEvict.condition();
        }
        String an = "@RedisClusterCacheEvict";
        if (TypeConvert.isNull(keys)) {
            throw new ExceptionRediscacheKeyInvalid(an + " key() is not null!");
        }
        Object[] objects = joinPoint.getArgs();
        String condition_ = "true";
        if (!TypeConvert.isNull(condition)) {
            condition_ = CommontUtil.getConditionOrKey(condition, objMethod, objects, an);
            condition_ = CommontUtil.valiCondition(condition_, an);
        }
        if (condition_.equals("true")) {
            for(String key : keys){
                String key_ = "";
                if (key.contains("#{*}")) {
                    try{
                        String k = key.split("#\\{\\*\\}")[0];
                        Iterator<String> iterator = jedisClusterTemplate.keys(k + "*").iterator();
                        while (iterator.hasNext()){
                            jedisClusterTemplate.del(iterator.next());
                        }
                        continue;
                    }catch (Exception e){
                        throw new ExceptionRediscacheKeyInvalid(an + " key() is error!");
                    }
                } else if(key.contains("#{")){
                    key_ = CommontUtil.getConditionOrKey(key, objMethod, objects, an);
                } else {
                    key_ = key;
                }
                if(jedisClusterTemplate.exists(key_.getBytes())){
                    jedisClusterTemplate.del(key_.getBytes());
                }
            }
            Object object = joinPoint.proceed();
            LogUtil.debug("\n{\n{　　　　　The redis data cached by this method has been emptied}\n}");
            return object;
        }
        try {
            return joinPoint.proceed();
        } catch (Throwable throwable) {
            return null;
        }
    }


    @Pointcut("@annotation(com.luues.redis.cluster.lock.RedisClusterSynchroized)")
    public void clusterSynchroizedAspect() {
    }
    @Around("clusterSynchroizedAspect()")
    public Object clusterSynchroizedAspect(ProceedingJoinPoint joinPoint) throws Throwable {
        Method objMethod = ((MethodSignature) joinPoint.getSignature()).getMethod();
        RedisClusterSynchroized redisClusterSynchroized = objMethod.getAnnotation(RedisClusterSynchroized.class);
        String key = null;
        Integer expire = null;
        String condition = null;
        Integer time = null;
        if (redisClusterSynchroized != null) {
            key = redisClusterSynchroized.key();
            expire = redisClusterSynchroized.expire();
            condition = redisClusterSynchroized.condition();
            time = redisClusterSynchroized.time();
        }
        String an = "@RedisClusterSynchroized";
        if (TypeConvert.isNull(key)) {
            throw new ExceptionRediscacheKeyInvalid(an + " key() is not null!");
        }
        if (TypeConvert.isNull(expire)) {
            expire = -1;
        }
        Object[] objects = joinPoint.getArgs();
        String condition_ = "true";
        if (!TypeConvert.isNull(condition)) {
            condition_ = CommontUtil.getConditionOrKey(condition, objMethod, objects, an);
            condition_ = CommontUtil.valiCondition(condition_, an);
        }
        if (condition_.equals("true")) {
            String key_ = CommontUtil.getConditionOrKey(key, objMethod, objects, an);
            synchronized (key_.intern()) {
                byte[] data = jedisClusterTemplate.lpop(key_.getBytes());
                if (!TypeConvert.isNull(data)) {
                    if(time > 0){
                        jedisClusterTemplate.lpush(key_.getBytes(), String.valueOf(System.currentTimeMillis()).getBytes());
                    }else{
                        jedisClusterTemplate.lpush(key_.getBytes(), "SUCCESS".getBytes());
                    }
                    jedisClusterTemplate.expire(key_.getBytes(), expire);
                    if (new String(data, "utf-8").equals("SUCCESS")) {
                        throw new ExceptionRedissynchroizedInvalid("频繁请求!");
                    } else {
                        Long time_ = (System.currentTimeMillis() - Long.valueOf(new String(data, "utf-8"))) / 1000;
                        if (time_ <= time) {
                            throw new ExceptionRedissynchroizedInvalid("您的手速太快了,请过"+time+"秒后再试!");
                        }
                    }
                }else{
                    if (time > 0) {
                        jedisClusterTemplate.lpush(key_.getBytes(), String.valueOf(System.currentTimeMillis()).getBytes());
                    } else {
                        jedisClusterTemplate.lpush(key_.getBytes(), "SUCCESS".getBytes());
                    }
                    jedisClusterTemplate.expire(key_.getBytes(), expire);
                    if (time <= 0) {
                        jedisClusterTemplate.lpop(key_.getBytes());
                    }
                }
                return joinPoint.proceed();
            }
        }
        return joinPoint.proceed();
    }

}
