package com.luues.redis.cluster.config;

import com.luues.util.TypeConvert;
import com.luues.util.logs.LogUtil;
import org.apache.commons.compress.utils.Sets;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import redis.clients.jedis.JedisPoolConfig;
import redis.clients.jedis.JedisShardInfo;
import redis.clients.jedis.ShardedJedisPool;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;

/**
 * redis-cluster集群配置类
 *
 * @author Mr-Wu ON 2019/05/07
 **/
@Configuration
@ConditionalOnExpression(value = "!'null'.equals('${spring.redis.cluster.nodes:null}')")
public class RedisClusterConfig {

    @Bean(name = "jedisCluster")
    public JedisClusterFactory jedisCluster(
            @Value("${spring.redis.cluster.nodes:null}") String host) {
        if(StringUtils.isEmpty(host)){
            LogUtil.error("\n{\n　　　　　To use redis-cluster, configure it first\n",
                    "\n　　　　　　　　　　spring.redis.cluster.nodes=ip:host\n}");
            return null;
        }
        JedisClusterFactory jedisClusterFactory = new JedisClusterFactory();
        String[] split = host.split(",");
        Set<String> hosts = Sets.newHashSet();
        Collections.addAll(hosts, split);
        jedisClusterFactory.setJedisClusterNodes(hosts);
        return jedisClusterFactory;
    }

}