package com.luues.redis.cluster.lock;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

@Retention(RetentionPolicy.RUNTIME)
@Target({ElementType.TYPE, ElementType.METHOD, ElementType.ANNOTATION_TYPE})
public @interface RedisClusterSynchroized {
    String key() default "";
    int expire() default 60 * 60;
    int time() default 0;
    String condition() default "";
}
