package com.luues.redis.util;

import com.luues.exception.ExceptionRediscacheInvalid;
import com.luues.exception.ExceptionRediscacheKeyInvalid;
import com.luues.redis.cluster.service.JedisClusterTemplate;
import com.luues.redis.single.service.JedisTemplate;
import com.luues.util.encryption.SerializingUtil;
import com.luues.util.logs.LogUtil;
import org.aspectj.lang.ProceedingJoinPoint;
import org.springframework.core.LocalVariableTableParameterNameDiscoverer;
import org.springframework.expression.Expression;
import org.springframework.expression.ExpressionParser;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.StandardEvaluationContext;

import java.lang.reflect.Method;
import java.lang.reflect.Parameter;

public class CommontUtil {

    private static LocalVariableTableParameterNameDiscoverer parameterNameDiscoverer = new LocalVariableTableParameterNameDiscoverer();
    private static ExpressionParser parser = new SpelExpressionParser();

    public static String getConditionOrKey(String condition, Method objMethod, Object[] objects, String an) throws ExceptionRediscacheKeyInvalid, ExceptionRediscacheInvalid {
        String condition_ = "";
        if (condition.contains("#{")) {
            String[] k = condition.split("#\\{");
            for (String s : k) {
                if (s.contains("}")) {
                    String k_ = s.split("}")[0];
                    condition_ += parseKey("#" + k_, objMethod, objects, an) + (s.split("}").length > 1 ? s.split("}")[1] : "");
                } else {
                    condition_ += s;
                }
            }
        } else {
            condition_ = condition;
        }
        return condition_;
    }

    public static Object getRedisCacheInfo(JedisTemplate jedisTemplate, String key_, ProceedingJoinPoint joinPoint, int expire) throws Throwable {
        if (jedisTemplate.exists(key_.getBytes())) {
            LogUtil.debug("\n{\n　　　　　This method gets the value from the redis cache\n}");
            return SerializingUtil.deserialize(jedisTemplate.get(key_.getBytes()));
        } else {
            Object object = joinPoint.proceed();
            if (expire >= 0) {
                jedisTemplate.setex(key_.getBytes(), expire, SerializingUtil.serialize(object));
            } else {
                jedisTemplate.set(key_.getBytes(), SerializingUtil.serialize(object));
            }
            LogUtil.debug("\n{\n{　　　　　The return data of this method has been stored in the redis cache}\n}");
            return object;
        }
    }

    public static Object getRedisClusterCacheInfo(JedisClusterTemplate jedisClusterTemplate, String key_, ProceedingJoinPoint joinPoint, int expire) throws Throwable {
        if (jedisClusterTemplate.exists(key_.getBytes())) {
            LogUtil.debug("\n{\n　　　　　This method gets the value from the redis cache\n}");
            return SerializingUtil.deserialize(jedisClusterTemplate.get(key_.getBytes()));
        } else {
            Object object = joinPoint.proceed();
            if (expire >= 0) {
                jedisClusterTemplate.setex(key_.getBytes(), expire, SerializingUtil.serialize(object));
            } else {
                jedisClusterTemplate.set(key_.getBytes(), SerializingUtil.serialize(object));
            }
            LogUtil.debug("\n{\n{　　　　　The return data of this method has been stored in the redis cache}\n}");
            return object;
        }
    }

    public static String parseKey(String key, Method objMethod, Object[] objects, String an) throws ExceptionRediscacheKeyInvalid {
        //获取被拦截方法参数名列表(使用Spring支持类库)
        String[] paraNameArr = parameterNameDiscoverer.getParameterNames(objMethod);
        //SPEL上下文
        StandardEvaluationContext context = new StandardEvaluationContext();
        //把方法参数放入SPEL上下文中
        if(null == paraNameArr){
            String str = "";
            for(Object object : objects){
                str += object + ",";
            }
            LogUtil.info("{},{},{},{}", objMethod.getDeclaringClass().getName(), objMethod.getName(), an, str);
            Parameter[] parameters = objMethod.getParameters();
            for(Parameter parameter : parameters){
                LogUtil.info("==={}", parameter.getName());
            }
        }else{
            for (int i = 0; i < paraNameArr.length; i++) {
                context.setVariable(paraNameArr[i], objects[i]);
            }
        }
        //使用SPEL进行key的解析
        Object value = parser.parseExpression(key).getValue(context, Object.class);
        if (null == value) {
            throw new ExceptionRediscacheKeyInvalid(an + " key() #{" + key.split("#")[1] + "} not is null!");
        }
        return value.toString();
    }

    public static String valiCondition(String condition, String an) throws ExceptionRediscacheInvalid {
        //使用SPEL进行key的解析
        Expression expression = parser.parseExpression(condition);
        try {
            Object value = expression.getValue();
            if (null == value) {
                throw new ExceptionRediscacheKeyInvalid(an + " condition() #{" + condition.split("#")[1] + "} error!");
            }
            return value.toString();
        } catch (Exception e) {
            throw new ExceptionRediscacheInvalid(an + " condition() '" + condition + "' is error!");
        }
    }

}
