/*
 * Decompiled with CFR 0.152.
 */
package com.luues.alipay;

import com.alipay.api.AlipayApiException;
import com.alipay.api.internal.util.AlipaySignature;
import com.alipay.api.response.AlipayDataDataserviceBillDownloadurlQueryResponse;
import com.alipay.api.response.AlipayFundAccountQueryResponse;
import com.alipay.api.response.AlipayFundTransCommonQueryResponse;
import com.alipay.api.response.AlipayFundTransUniTransferResponse;
import com.alipay.api.response.AlipayTradeAppPayResponse;
import com.alipay.api.response.AlipayTradeCloseResponse;
import com.alipay.api.response.AlipayTradeFastpayRefundQueryResponse;
import com.alipay.api.response.AlipayTradePagePayResponse;
import com.alipay.api.response.AlipayTradeQueryResponse;
import com.alipay.api.response.AlipayTradeRefundResponse;
import com.alipay.api.response.AlipayTradeWapPayResponse;
import com.luues.alipay.configuration.AliPayInfo;
import com.luues.alipay.entity.order.AliOrder;
import com.luues.alipay.entity.order.AliOrderMustFillRequest;
import com.luues.alipay.entity.order.AliOrderSelectiveFillRequest;
import com.luues.alipay.entity.pay.AliPayOrderInfo;
import com.luues.alipay.entity.trans.AliPayTrans;
import com.luues.alipay.util.AliPayOrder;
import com.luues.alipay.util.Pay;
import com.luues.applicationcontext.init.BeanContextHolder;
import com.luues.util.TypeConvert;
import com.luues.util.logs.LogUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.PostConstruct;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class AliPay {
    @Autowired
    private AliPayInfo aliPayInfo;
    @Autowired
    private AliPayOrder aliPayOrder;
    @Autowired
    private Pay pay;

    @PostConstruct
    public void init() {
        if (TypeConvert.isNull((Object[])new Object[]{this.aliPayInfo.getAppId(), this.aliPayInfo.getPrivateKey(), this.aliPayInfo.getPublicKey()})) {
            LogUtil.error((String)"{}", (Object[])new Object[]{"\n{\n                                     -- Failed to read the configuration file, because the file does not exist! -- \n                                           -- Please configure the file first,Configuration is as follows: -- \n   -- Explain(Please create a folder in the resources below for the payment file named properties configuration file, that is, (*.properties)) -- \n                                                        -- alipay.appid = Merchant appid (*) -- \n                                                -- alipay.app_private_key = Merchant app_private_key (*) -- \n                                                 -- alipay.app_public_key = Merchant app_public_key (*) -- \n                                                        -- alipay.charset = Merchant charset -- \n                                                      -- alipay.sign_type = Merchant sign_type -- \n}\n"});
        }
    }

    public AliOrder createPcOrder(AliOrderMustFillRequest aliOrderMustFillRequest, AliOrderSelectiveFillRequest aliOrderSelectiveFillRequest) throws Exception {
        return this.aliPayOrder.createPcOrder(aliOrderMustFillRequest, aliOrderSelectiveFillRequest);
    }

    public AliPayOrderInfo createAliPayOrderInfo(String return_url, String notify_url, AliOrder aliOrder) {
        if (Objects.isNull(return_url)) {
            return_url = this.aliPayInfo.getReturn_url();
        }
        if (Objects.isNull(notify_url)) {
            notify_url = this.aliPayInfo.getNotify_url();
        }
        return new AliPayOrderInfo(return_url, notify_url, aliOrder);
    }

    public AliPayOrderInfo createAliPayOrderInfo(AliOrder aliOrder) {
        return new AliPayOrderInfo(this.aliPayInfo.getReturn_url(), this.aliPayInfo.getNotify_url(), aliOrder);
    }

    public AlipayTradePagePayResponse pc_pay(AliPayOrderInfo aliPayOrderInfo) throws AlipayApiException {
        return this.pay.pc_pay(aliPayOrderInfo);
    }

    public AliOrder createWapOrder(AliOrderMustFillRequest aliOrderMustFillRequest, AliOrderSelectiveFillRequest aliOrderSelectiveFillRequest) throws Exception {
        return this.aliPayOrder.createWapOrder(aliOrderMustFillRequest, aliOrderSelectiveFillRequest);
    }

    public AlipayTradeWapPayResponse wap_pay(AliPayOrderInfo aliPayOrderInfo) throws AlipayApiException {
        return this.pay.wap_pay(aliPayOrderInfo);
    }

    public AliOrder createAppOrder(AliOrderMustFillRequest aliOrderMustFillRequest, AliOrderSelectiveFillRequest aliOrderSelectiveFillRequest) throws Exception {
        return this.aliPayOrder.createAppOrder(aliOrderMustFillRequest, aliOrderSelectiveFillRequest);
    }

    public AlipayTradeAppPayResponse app_pay(AliPayOrderInfo aliPayOrderInfo) throws AlipayApiException {
        return this.pay.app_pay(aliPayOrderInfo);
    }

    public AlipayTradeQueryResponse queryAliOrderInfo(String trade_no, String out_trade_no) throws AlipayApiException {
        return this.aliPayOrder.queryAliOrderInfo(trade_no, out_trade_no);
    }

    public AlipayTradeRefundResponse refund(String trade_no, String out_trade_no, String refund_amount, String refund_reason, String out_request_no, String operator_id) throws AlipayApiException {
        return this.aliPayOrder.refund(trade_no, out_trade_no, refund_amount, refund_reason, out_request_no, operator_id);
    }

    public AlipayTradeFastpayRefundQueryResponse queryRefund(String trade_no, String out_trade_no, String out_request_no) throws AlipayApiException {
        return this.aliPayOrder.queryRefund(trade_no, out_trade_no, out_request_no);
    }

    public AlipayTradeCloseResponse closeOrder(String trade_no, String out_trade_no, String operator_id) throws AlipayApiException {
        return this.aliPayOrder.closeOrder(trade_no, out_trade_no, operator_id);
    }

    public AlipayDataDataserviceBillDownloadurlQueryResponse downloadBill(String bill_date, String bill_type) throws AlipayApiException {
        return this.aliPayOrder.downloadBill(bill_date, bill_type);
    }

    public AlipayFundTransUniTransferResponse transfers(AliPayTrans aliPayTrans) throws AlipayApiException {
        return this.pay.transfers(aliPayTrans);
    }

    public AlipayFundTransCommonQueryResponse queryAliTranesInfo(String order_id, String pay_fund_order_id, String out_biz_no) throws AlipayApiException {
        return this.aliPayOrder.queryAliTranesInfo(order_id, pay_fund_order_id, out_biz_no);
    }

    public AlipayFundAccountQueryResponse queryAccountBalance(String alipay_user_id) throws AlipayApiException {
        return this.aliPayOrder.queryAccountBalance(alipay_user_id);
    }

    public Map<String, String> valiAliPaySign() {
        Map<String, String> paramsMap = this.convertRequestParamsToMap(BeanContextHolder.getRequest());
        boolean signVerified = false;
        try {
            signVerified = AlipaySignature.rsaCheckV1(paramsMap, (String)this.aliPayInfo.getPublicKey(), (String)this.aliPayInfo.getCharset(), (String)this.aliPayInfo.getSignType());
        }
        catch (AlipayApiException e) {
            paramsMap.put("resultCode", "failure");
            return paramsMap;
        }
        if (!signVerified) {
            paramsMap.put("resultCode", "failure");
        } else {
            paramsMap.put("resultCode", "success");
        }
        return paramsMap;
    }

    protected Map<String, String> convertRequestParamsToMap(HttpServletRequest request) {
        HashMap<String, String> retMap = new HashMap<String, String>();
        Set entrySet = request.getParameterMap().entrySet();
        for (Map.Entry entry : entrySet) {
            String name = (String)entry.getKey();
            String[] values = (String[])entry.getValue();
            int valLen = values.length;
            if (valLen == 1) {
                retMap.put(name, values[0]);
                continue;
            }
            if (valLen > 1) {
                StringBuilder sb = new StringBuilder();
                for (String val : values) {
                    sb.append(",").append(val);
                }
                retMap.put(name, sb.toString().substring(1));
                continue;
            }
            retMap.put(name, "");
        }
        return retMap;
    }
}

