/*
 * Decompiled with CFR 0.152.
 */
package com.luues.alipay.configuration;

import com.alipay.api.AlipayApiException;
import com.alipay.api.AlipayClient;
import com.alipay.api.CertAlipayRequest;
import com.alipay.api.DefaultAlipayClient;
import com.luues.alipay.configuration.AliPayInfo;
import java.util.Objects;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class AliPayClient {
    @Autowired
    private AliPayInfo aliPayInfo;
    private AlipayClient alipayClient;

    public AlipayClient getAlipayClient() {
        return this.alipayClient;
    }

    @PostConstruct
    protected void init() throws AlipayApiException {
        if (Objects.isNull(this.aliPayInfo.getCertPath()) || this.aliPayInfo.getCertPath().trim().equals("null")) {
            this.alipayClient = new DefaultAlipayClient(this.aliPayInfo.getUrl(), this.aliPayInfo.getAppId(), this.aliPayInfo.getPrivateKey(), this.aliPayInfo.getFormat(), this.aliPayInfo.getCharset(), this.aliPayInfo.getPublicKey(), this.aliPayInfo.getSignType());
            return;
        }
        CertAlipayRequest certAlipayRequest = new CertAlipayRequest();
        certAlipayRequest.setServerUrl(this.aliPayInfo.getUrl());
        certAlipayRequest.setAppId(this.aliPayInfo.getAppId());
        certAlipayRequest.setPrivateKey(this.aliPayInfo.getPrivateKey());
        certAlipayRequest.setFormat(this.aliPayInfo.getFormat());
        certAlipayRequest.setCharset(this.aliPayInfo.getCharset());
        certAlipayRequest.setSignType(this.aliPayInfo.getSignType());
        certAlipayRequest.setCertPath(this.aliPayInfo.getCertPath());
        certAlipayRequest.setAlipayPublicCertPath(this.aliPayInfo.getAlipayPublicCertPath());
        certAlipayRequest.setRootCertPath(this.aliPayInfo.getRootCertPath());
        this.alipayClient = new DefaultAlipayClient(certAlipayRequest);
    }
}

