/*
 * Decompiled with CFR 0.152.
 */
package com.luues.alipay.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alipay.api.AlipayApiException;
import com.alipay.api.AlipayRequest;
import com.alipay.api.request.AlipayDataDataserviceBillDownloadurlQueryRequest;
import com.alipay.api.request.AlipayFundAccountQueryRequest;
import com.alipay.api.request.AlipayFundTransCommonQueryRequest;
import com.alipay.api.request.AlipayTradeCloseRequest;
import com.alipay.api.request.AlipayTradeFastpayRefundQueryRequest;
import com.alipay.api.request.AlipayTradeQueryRequest;
import com.alipay.api.request.AlipayTradeRefundRequest;
import com.alipay.api.response.AlipayDataDataserviceBillDownloadurlQueryResponse;
import com.alipay.api.response.AlipayFundAccountQueryResponse;
import com.alipay.api.response.AlipayFundTransCommonQueryResponse;
import com.alipay.api.response.AlipayTradeCloseResponse;
import com.alipay.api.response.AlipayTradeFastpayRefundQueryResponse;
import com.alipay.api.response.AlipayTradeQueryResponse;
import com.alipay.api.response.AlipayTradeRefundResponse;
import com.luues.alipay.configuration.AliPayClient;
import com.luues.alipay.entity.order.AliOrder;
import com.luues.alipay.entity.order.AliOrderMustFillRequest;
import com.luues.alipay.entity.order.AliOrderSelectiveFillRequest;
import com.luues.util.TypeConvert;
import java.util.Objects;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class AliPayOrder {
    @Autowired
    private AliPayClient aliPayClient;

    public AliOrder getOrder(AliOrderMustFillRequest aliOrderMustFillRequest, AliOrderSelectiveFillRequest aliOrderSelectiveFillRequest) throws Exception {
        AliOrder aliOrder = new AliOrder().createOrder(true);
        if (TypeConvert.isNull((Object[])new Object[]{aliOrderMustFillRequest.setPrice()})) {
            throw new Exception("price \u5fc5\u987b\u8bbe\u7f6e!");
        }
        if (TypeConvert.isNull((Object[])new Object[]{aliOrderMustFillRequest.setSubject()})) {
            throw new Exception("subject \u5fc5\u987b\u8bbe\u7f6e!");
        }
        aliOrder.setProduct_code("FAST_INSTANT_TRADE_PAY");
        aliOrder.setTotal_amount(aliOrderMustFillRequest.setPrice());
        aliOrder.setSubject(aliOrderMustFillRequest.setSubject());
        aliOrder.setBody(TypeConvert.speacToString((Object)aliOrderSelectiveFillRequest.setBody()));
        aliOrder.setGoodsDetailList(aliOrderSelectiveFillRequest.setGoodsDetails());
        aliOrder.setPassback_params(TypeConvert.speacToString((Object)aliOrderSelectiveFillRequest.setPassback_params()));
        aliOrder.setGoods_type(Objects.isNull(aliOrderMustFillRequest.setGoods_type()) ? "0" : aliOrderMustFillRequest.setGoods_type());
        aliOrder.setTimeout_express(Objects.isNull(aliOrderSelectiveFillRequest.setTimeout_express()) ? "1d" : aliOrderSelectiveFillRequest.setTimeout_express());
        return aliOrder;
    }

    public AliOrder createPcOrder(AliOrderMustFillRequest aliOrderMustFillRequest, AliOrderSelectiveFillRequest aliOrderSelectiveFillRequest) throws Exception {
        AliOrder aliOrder = this.getOrder(aliOrderMustFillRequest, aliOrderSelectiveFillRequest);
        aliOrder.setProduct_code("FAST_INSTANT_TRADE_PAY");
        return aliOrder;
    }

    public AliOrder createWapOrder(AliOrderMustFillRequest aliOrderMustFillRequest, AliOrderSelectiveFillRequest aliOrderSelectiveFillRequest) throws Exception {
        AliOrder aliOrder = this.getOrder(aliOrderMustFillRequest, aliOrderSelectiveFillRequest);
        aliOrder.setProduct_code("QUICK_WAP_WAY");
        return aliOrder;
    }

    public AliOrder createAppOrder(AliOrderMustFillRequest aliOrderMustFillRequest, AliOrderSelectiveFillRequest aliOrderSelectiveFillRequest) throws Exception {
        AliOrder aliOrder = this.getOrder(aliOrderMustFillRequest, aliOrderSelectiveFillRequest);
        aliOrder.setProduct_code("QUICK_MSECURITY_PAY");
        return aliOrder;
    }

    public AlipayTradeQueryResponse queryAliOrderInfo(String trade_no, String out_trade_no) throws AlipayApiException {
        AlipayTradeQueryRequest request = new AlipayTradeQueryRequest();
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("trade_no", (Object)trade_no);
        jsonObject.put("out_trade_no", (Object)out_trade_no);
        request.setBizContent(JSON.toJSONString((Object)jsonObject));
        AlipayTradeQueryResponse alipayTradeQueryResponse = (AlipayTradeQueryResponse)this.aliPayClient.getAlipayClient().execute((AlipayRequest)request);
        return alipayTradeQueryResponse;
    }

    public AlipayTradeRefundResponse refund(String trade_no, String out_trade_no, String refund_amount, String refund_reason, String out_request_no, String operator_id) throws AlipayApiException {
        AlipayTradeRefundRequest alipayTradeRefundRequest = new AlipayTradeRefundRequest();
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("trade_no", (Object)trade_no);
        jsonObject.put("out_trade_no", (Object)out_trade_no);
        jsonObject.put("refund_amount", (Object)refund_amount);
        jsonObject.put("refund_reason", (Object)refund_reason);
        jsonObject.put("out_request_no", (Object)out_request_no);
        jsonObject.put("operator_id", (Object)operator_id);
        alipayTradeRefundRequest.setBizContent(jsonObject.toJSONString());
        AlipayTradeRefundResponse alipayTradeRefundResponse = (AlipayTradeRefundResponse)this.aliPayClient.getAlipayClient().execute((AlipayRequest)alipayTradeRefundRequest);
        return alipayTradeRefundResponse;
    }

    public AlipayTradeFastpayRefundQueryResponse queryRefund(String trade_no, String out_trade_no, String out_request_no) throws AlipayApiException {
        AlipayTradeFastpayRefundQueryRequest alipayTradeFastpayRefundQueryRequest = new AlipayTradeFastpayRefundQueryRequest();
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("trade_no", (Object)trade_no);
        jsonObject.put("out_trade_no", (Object)out_trade_no);
        jsonObject.put("out_request_no", (Object)out_request_no);
        alipayTradeFastpayRefundQueryRequest.setBizContent(JSON.toJSONString((Object)jsonObject));
        AlipayTradeFastpayRefundQueryResponse alipayTradeFastpayRefundQueryResponse = (AlipayTradeFastpayRefundQueryResponse)this.aliPayClient.getAlipayClient().execute((AlipayRequest)alipayTradeFastpayRefundQueryRequest);
        return alipayTradeFastpayRefundQueryResponse;
    }

    public AlipayTradeCloseResponse closeOrder(String trade_no, String out_trade_no, String operator_id) throws AlipayApiException {
        AlipayTradeCloseRequest alipayTradeCloseRequest = new AlipayTradeCloseRequest();
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("trade_no", (Object)trade_no);
        jsonObject.put("out_trade_no", (Object)out_trade_no);
        jsonObject.put("operator_id", (Object)operator_id);
        alipayTradeCloseRequest.setBizContent(jsonObject.toJSONString());
        AlipayTradeCloseResponse alipayTradeCloseResponse = (AlipayTradeCloseResponse)this.aliPayClient.getAlipayClient().execute((AlipayRequest)alipayTradeCloseRequest);
        return alipayTradeCloseResponse;
    }

    public AlipayDataDataserviceBillDownloadurlQueryResponse downloadBill(String bill_date, String bill_type) throws AlipayApiException {
        AlipayDataDataserviceBillDownloadurlQueryRequest alipayDataDataserviceBillDownloadurlQueryRequest = new AlipayDataDataserviceBillDownloadurlQueryRequest();
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("bill_date", (Object)bill_date);
        jsonObject.put("bill_type", (Object)bill_type);
        alipayDataDataserviceBillDownloadurlQueryRequest.setBizContent(jsonObject.toJSONString());
        AlipayDataDataserviceBillDownloadurlQueryResponse alipayDataDataserviceBillDownloadurlQueryResponse = (AlipayDataDataserviceBillDownloadurlQueryResponse)this.aliPayClient.getAlipayClient().execute((AlipayRequest)alipayDataDataserviceBillDownloadurlQueryRequest);
        return alipayDataDataserviceBillDownloadurlQueryResponse;
    }

    public AlipayFundTransCommonQueryResponse queryAliTranesInfo(String order_id, String pay_fund_order_id, String out_biz_no) throws AlipayApiException {
        AlipayFundTransCommonQueryRequest alipayFundTransCommonQueryRequest = new AlipayFundTransCommonQueryRequest();
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("order_id", (Object)order_id);
        jsonObject.put("pay_fund_order_id", (Object)pay_fund_order_id);
        jsonObject.put("out_biz_no", (Object)out_biz_no);
        jsonObject.put("product_code", (Object)"TRANS_ACCOUNT_NO_PWD");
        jsonObject.put("biz_scene", (Object)"DIRECT_TRANSFER");
        alipayFundTransCommonQueryRequest.setBizContent(jsonObject.toJSONString());
        AlipayFundTransCommonQueryResponse alipayFundTransCommonQueryResponse = (AlipayFundTransCommonQueryResponse)this.aliPayClient.getAlipayClient().certificateExecute((AlipayRequest)alipayFundTransCommonQueryRequest);
        return alipayFundTransCommonQueryResponse;
    }

    public AlipayFundAccountQueryResponse queryAccountBalance(String alipay_user_id) throws AlipayApiException {
        AlipayFundAccountQueryRequest alipayFundAccountQueryRequest = new AlipayFundAccountQueryRequest();
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("alipay_user_id", (Object)alipay_user_id);
        jsonObject.put("account_type", (Object)"ACCTRANS_ACCOUNT");
        AlipayFundAccountQueryResponse alipayFundAccountQueryResponse = (AlipayFundAccountQueryResponse)this.aliPayClient.getAlipayClient().certificateExecute((AlipayRequest)alipayFundAccountQueryRequest);
        return alipayFundAccountQueryResponse;
    }
}

