/*
 * Decompiled with CFR 0.152.
 */
package com.luues.alipay.util;

import com.alibaba.fastjson.JSON;
import com.alipay.api.AlipayApiException;
import com.alipay.api.AlipayRequest;
import com.alipay.api.request.AlipayFundTransUniTransferRequest;
import com.alipay.api.request.AlipayTradeAppPayRequest;
import com.alipay.api.request.AlipayTradePagePayRequest;
import com.alipay.api.request.AlipayTradeWapPayRequest;
import com.alipay.api.response.AlipayFundTransUniTransferResponse;
import com.alipay.api.response.AlipayTradeAppPayResponse;
import com.alipay.api.response.AlipayTradePagePayResponse;
import com.alipay.api.response.AlipayTradeWapPayResponse;
import com.luues.alipay.configuration.AliPayClient;
import com.luues.alipay.entity.pay.AliPayOrderInfo;
import com.luues.alipay.entity.trans.AliPayTrans;
import com.luues.util.TypeConvert;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="ali_pay")
public class Pay {
    @Autowired
    private AliPayClient aliPayClient;

    public AlipayTradePagePayResponse pc_pay(AliPayOrderInfo aliPayOrderInfo) throws AlipayApiException {
        AlipayTradePagePayRequest alipayRequest = new AlipayTradePagePayRequest();
        alipayRequest.setReturnUrl(TypeConvert.speacToString((Object)aliPayOrderInfo.getReturn_url()));
        alipayRequest.setNotifyUrl(aliPayOrderInfo.getNotify_url());
        alipayRequest.setBizContent(aliPayOrderInfo.getAliOrder());
        AlipayTradePagePayResponse alipayTradePagePayResponse = (AlipayTradePagePayResponse)this.aliPayClient.getAlipayClient().pageExecute((AlipayRequest)alipayRequest);
        alipayTradePagePayResponse.setOutTradeNo(aliPayOrderInfo.getAliOrders().getOut_trade_no());
        return alipayTradePagePayResponse;
    }

    public AlipayTradeWapPayResponse wap_pay(AliPayOrderInfo aliPayOrderInfo) throws AlipayApiException {
        AlipayTradeWapPayRequest alipayTradeWapPayRequest = new AlipayTradeWapPayRequest();
        alipayTradeWapPayRequest.setReturnUrl(TypeConvert.speacToString((Object)aliPayOrderInfo.getReturn_url()));
        alipayTradeWapPayRequest.setNotifyUrl(aliPayOrderInfo.getNotify_url());
        alipayTradeWapPayRequest.setBizContent(aliPayOrderInfo.getAliOrder());
        AlipayTradeWapPayResponse alipayTradeWapPayResponse = (AlipayTradeWapPayResponse)this.aliPayClient.getAlipayClient().pageExecute((AlipayRequest)alipayTradeWapPayRequest);
        alipayTradeWapPayResponse.setOutTradeNo(aliPayOrderInfo.getAliOrders().getOut_trade_no());
        return alipayTradeWapPayResponse;
    }

    public AlipayTradeAppPayResponse app_pay(AliPayOrderInfo aliPayOrderInfo) throws AlipayApiException {
        AlipayTradeAppPayRequest alipayTradeAppPayRequest = new AlipayTradeAppPayRequest();
        alipayTradeAppPayRequest.setReturnUrl(TypeConvert.speacToString((Object)aliPayOrderInfo.getReturn_url()));
        alipayTradeAppPayRequest.setNotifyUrl(aliPayOrderInfo.getNotify_url());
        alipayTradeAppPayRequest.setBizContent(aliPayOrderInfo.getAliOrder());
        AlipayTradeAppPayResponse alipayTradeAppPayResponse = (AlipayTradeAppPayResponse)this.aliPayClient.getAlipayClient().sdkExecute((AlipayRequest)alipayTradeAppPayRequest);
        alipayTradeAppPayResponse.setOutTradeNo(aliPayOrderInfo.getAliOrders().getOut_trade_no());
        return alipayTradeAppPayResponse;
    }

    public AlipayFundTransUniTransferResponse transfers(AliPayTrans aliPayTrans) throws AlipayApiException {
        AlipayFundTransUniTransferRequest alipayFundTransUniTransferRequest = new AlipayFundTransUniTransferRequest();
        alipayFundTransUniTransferRequest.setBizContent(JSON.toJSONString((Object)aliPayTrans));
        AlipayFundTransUniTransferResponse alipayFundTransUniTransferResponse = (AlipayFundTransUniTransferResponse)this.aliPayClient.getAlipayClient().certificateExecute((AlipayRequest)alipayFundTransUniTransferRequest);
        return alipayFundTransUniTransferResponse;
    }
}

