/*
 * Decompiled with CFR 0.152.
 */
package com.luues.redis.cluster.config;

import com.luues.util.TypeConvert;
import com.luues.util.logs.LogUtil;
import java.text.ParseException;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Value;
import redis.clients.jedis.HostAndPort;
import redis.clients.jedis.JedisCluster;

public class JedisClusterFactory
implements FactoryBean<JedisCluster>,
InitializingBean {
    @Value(value="${redis.maxIdle:300}")
    private Integer maxIdle;
    @Value(value="${redis.maxTotal:1000}")
    private Integer maxTotal;
    @Value(value="${redis.maxWaitMillis:1000}")
    private Integer maxWaitMillis;
    @Value(value="${redis.minEvictableIdleTimeMillis:1800000}")
    private Integer minEvictableIdleTimeMillis;
    @Value(value="${redis.numTestsPerEvictionRun:3}")
    private Integer numTestsPerEvictionRun;
    @Value(value="${redis.timeBetweenEvictionRunsMillis:-1}")
    private long timeBetweenEvictionRunsMillis;
    @Value(value="${redis.testOnBorrow:true}")
    private boolean testOnBorrow;
    @Value(value="${redis.testOnReturn:true}")
    private boolean testOnReturn;
    @Value(value="${redis.testWhileIdle:true}")
    private boolean testWhileIdle;
    @Value(value="${redis.timeout:2000}")
    private Integer timeout;
    @Value(value="${redis.max-redirections:5}")
    private Integer maxRedirections;
    @Value(value="${redis.password:null}")
    private String password;
    private JedisCluster jedisCluster;
    private Set<String> jedisClusterNodes;

    public JedisCluster getObject() {
        return this.jedisCluster;
    }

    public Class<?> getObjectType() {
        return this.jedisCluster != null ? this.jedisCluster.getClass() : JedisCluster.class;
    }

    public boolean isSingleton() {
        return true;
    }

    public void afterPropertiesSet() throws ParseException {
        if (this.jedisClusterNodes == null || this.jedisClusterNodes.size() == 0) {
            throw new NullPointerException("jedisClusterNodes is null.");
        }
        HashSet<HostAndPort> haps = new HashSet<HostAndPort>();
        for (String node : this.jedisClusterNodes) {
            String[] arr = node.split(":");
            if (arr.length != 2) {
                throw new ParseException("node address error !", node.length() - 1);
            }
            haps.add(new HostAndPort(arr[0], Integer.valueOf(arr[1]).intValue()));
        }
        GenericObjectPoolConfig genericObjectPoolConfig = new GenericObjectPoolConfig();
        genericObjectPoolConfig.setMaxIdle(this.maxIdle.intValue());
        genericObjectPoolConfig.setMaxTotal(this.maxTotal.intValue());
        genericObjectPoolConfig.setMaxWaitMillis((long)this.maxWaitMillis.intValue());
        genericObjectPoolConfig.setMinEvictableIdleTimeMillis((long)this.minEvictableIdleTimeMillis.intValue());
        genericObjectPoolConfig.setNumTestsPerEvictionRun(this.numTestsPerEvictionRun.intValue());
        genericObjectPoolConfig.setTimeBetweenEvictionRunsMillis(this.timeBetweenEvictionRunsMillis);
        genericObjectPoolConfig.setTestOnBorrow(this.testOnBorrow);
        genericObjectPoolConfig.setTestOnReturn(this.testOnReturn);
        genericObjectPoolConfig.setTestWhileIdle(this.testWhileIdle);
        if (!TypeConvert.isNull((Object[])new Object[]{this.password})) {
            this.jedisCluster = new JedisCluster(haps, this.timeout.intValue(), this.timeout.intValue(), this.maxRedirections.intValue(), this.password, genericObjectPoolConfig);
        }
        this.jedisCluster = new JedisCluster(haps, this.timeout.intValue(), this.timeout.intValue(), this.maxRedirections.intValue(), genericObjectPoolConfig);
        LogUtil.info((String)"\n{\n\u3000\u3000\u3000\u3000\u3000redis-cluster start...\n\u3000\u3000\u3000\u3000\u3000nodes:{}\n\u3000\u3000\u3000\u3000\u3000password:{}\n\u3000\u3000\u3000\u3000\u3000MaxTotal:{}\n\u3000\u3000\u3000\u3000\u3000MaxIdle:{}\n\u3000\u3000\u3000\u3000\u3000MaxWaitMillis:{}\n\u3000\u3000\u3000\u3000\u3000TestOnBorrow:{}\n\u3000\u3000\u3000\u3000\u3000testOnReturn:{}\n\u3000\u3000\u3000\u3000\u3000minEvictableIdleTimeMillis:{}\n\u3000\u3000\u3000\u3000\u3000numTestsPerEvictionRun:{}\n\u3000\u3000\u3000\u3000\u3000timeBetweenEvictionRunsMillis:{}\n\u3000\u3000\u3000\u3000\u3000testWhileIdle:{}\n}", (Object[])new Object[]{String.join((CharSequence)",", String.join((CharSequence)",", this.jedisCluster.getClusterNodes().keySet())), this.password, this.maxTotal, this.maxIdle, this.maxWaitMillis, this.testOnBorrow, this.testOnReturn, this.minEvictableIdleTimeMillis, this.numTestsPerEvictionRun, this.timeBetweenEvictionRunsMillis, this.testWhileIdle});
    }

    public void setJedisClusterNodes(Set<String> jedisClusterNodes) {
        this.jedisClusterNodes = jedisClusterNodes;
    }
}

