/*
 * Decompiled with CFR 0.152.
 */
package com.luues.redis.cluster.service;

import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import redis.clients.jedis.JedisCluster;
import redis.clients.jedis.ScanParams;
import redis.clients.jedis.ScanResult;
import redis.clients.jedis.Tuple;

@Component
public class JedisClusterTemplate {
    @Autowired(required=false)
    private JedisCluster jedisCluster;
    private String lock_key = "JEDIS_LOCK:";
    private int timeout = 5;

    public boolean init() {
        return null != this.jedisCluster;
    }

    public Set<String> keys(String pattern) {
        HashSet<String> stringSet = new HashSet<String>();
        String cursor = ScanParams.SCAN_POINTER_START;
        ScanParams scanParams = new ScanParams();
        scanParams.match(pattern);
        scanParams.count(Integer.valueOf(1000));
        do {
            ScanResult sscanResult = this.jedisCluster.scan(cursor, scanParams);
            cursor = sscanResult.getStringCursor();
            stringSet.addAll(sscanResult.getResult());
        } while (!"0".equals(cursor));
        return stringSet;
    }

    public void delKeys(String pattern) {
        Set<String> strings = this.keys(pattern);
        if (strings.size() == 0) {
            return;
        }
        Iterator<String> iterator = strings.iterator();
        while (iterator.hasNext()) {
            this.del(iterator.next());
        }
    }

    public Long expire(String key, Integer seconds) {
        return this.jedisCluster.expire(key, seconds.intValue());
    }

    public Long expire(byte[] key, Integer seconds) {
        return this.jedisCluster.expire(key, seconds.intValue());
    }

    public void set(String key, String value) {
        this.jedisCluster.set(key, value);
    }

    public void set(byte[] key, byte[] value) {
        this.jedisCluster.set(key, value);
    }

    public void setex(String key, int seconds, String value) {
        this.jedisCluster.setex(key, seconds, value);
    }

    public void setex(byte[] key, int seconds, byte[] value) {
        this.jedisCluster.setex(key, seconds, value);
    }

    public String get(String key) {
        return this.jedisCluster.get(key);
    }

    public byte[] get(byte[] key) {
        return this.jedisCluster.get(key);
    }

    public void zadd(String key, double score, String value) {
        this.jedisCluster.zadd(key, score, value);
    }

    public void zadd(byte[] key, double score, byte[] value) {
        this.jedisCluster.zadd(key, score, value);
    }

    public Set<String> zrevrange(String key, long start, long end) {
        return this.jedisCluster.zrevrange(key, start, end);
    }

    public Set<byte[]> zrevrange(byte[] key, long start, long end) {
        return this.jedisCluster.zrevrange(key, start, end);
    }

    public Set<Tuple> zrevrangeWithScores(String key, long start, long end) {
        return this.jedisCluster.zrevrangeWithScores(key, start, end);
    }

    public Set<Tuple> zrevrangeWithScores(byte[] key, long start, long end) {
        return this.jedisCluster.zrevrangeWithScores(key, start, end);
    }

    public void sadd(String key, String ... value) {
        this.jedisCluster.sadd(key, value);
    }

    public void sadd(byte[] key, byte[] ... value) {
        this.jedisCluster.sadd(key, value);
    }

    public Long srem(String key, String ... value) {
        return this.jedisCluster.srem(key, value);
    }

    public Long srem(byte[] key, byte[] ... value) {
        return this.jedisCluster.srem(key, value);
    }

    public Long scard(String key) {
        return this.jedisCluster.scard(key);
    }

    public Long scard(byte[] key) {
        return this.jedisCluster.scard(key);
    }

    public void rpush(String key, String ... value) {
        this.jedisCluster.rpush(key, value);
    }

    public void rpush(byte[] key, byte[] ... value) {
        this.jedisCluster.rpush(key, value);
    }

    public String rpop(String key) {
        return this.jedisCluster.rpop(key);
    }

    public byte[] rpop(byte[] key) {
        return this.jedisCluster.rpop(key);
    }

    public Boolean exists(String key) {
        return this.jedisCluster.exists(key);
    }

    public Boolean exists(byte[] key) {
        return this.jedisCluster.exists(key);
    }

    public Long del(String key) {
        if (this.exists(key).booleanValue()) {
            return this.jedisCluster.del(key);
        }
        return -1L;
    }

    public Long del(byte[] key) {
        if (this.exists(key).booleanValue()) {
            return this.jedisCluster.del(key);
        }
        return -1L;
    }

    public Long incr(String key) {
        return this.jedisCluster.incr(key);
    }

    public Long incr(byte[] key) {
        return this.jedisCluster.incr(key);
    }

    public void lpush(byte[] key, byte[] value) {
        this.jedisCluster.lpush(key, (byte[][])new byte[][]{value});
    }

    public void lpush(String key, String value) {
        this.jedisCluster.lpush(key, new String[]{value});
    }

    public byte[] lpop(byte[] key) {
        return this.jedisCluster.lpop(key);
    }

    public String lpop(String key) {
        return this.jedisCluster.lpop(key);
    }

    public Long llen(byte[] key) {
        return this.jedisCluster.llen(key);
    }

    public Long llen(String key) {
        return this.jedisCluster.llen(key);
    }

    public List<String> lrange(String key) {
        return this.jedisCluster.lrange(key, 0L, this.llen(key).longValue());
    }

    public List<byte[]> lrange(byte[] key) {
        return this.jedisCluster.lrange(key, 0L, this.llen(key).longValue());
    }

    public Long hset(String key, String field, String value) {
        return this.jedisCluster.hset(key, field, value);
    }

    public Long hset(byte[] key, byte[] field, byte[] value) {
        return this.jedisCluster.hset(key, field, value);
    }

    public boolean hexists(String key, String field) {
        return this.jedisCluster.hexists(key, field);
    }

    public boolean hexists(byte[] key, byte[] field) {
        return this.jedisCluster.hexists(key, field);
    }

    public Map<String, String> hgetAll(String key) {
        return this.jedisCluster.hgetAll(key);
    }

    public Map<byte[], byte[]> hgetAll(byte[] key) {
        return this.jedisCluster.hgetAll(key);
    }

    public String hget(String key, String field) {
        return this.jedisCluster.hget(key, field);
    }

    public byte[] hget(byte[] key, byte[] field) {
        return this.jedisCluster.hget(key, field);
    }

    public Long hdel(String key, String field) {
        return this.jedisCluster.hdel(key, new String[]{field});
    }

    public Long hdel(byte[] key, byte[] field) {
        return this.jedisCluster.hdel(key, (byte[][])new byte[][]{field});
    }

    public boolean lock(String key) {
        long start = System.currentTimeMillis();
        long end = start + (long)this.timeout;
        boolean result = false;
        while (!(result = Boolean.valueOf(this.jedisCluster.setnx(this.lock_key + key, "SUCCESS").toString()).booleanValue()) && System.currentTimeMillis() <= end) {
        }
        return result;
    }

    public boolean unlock(String key) {
        String script = "if redis.call('get',KEYS[1]) == ARGV[1] then   return redis.call('del',KEYS[1]) else   return 0 end";
        Object result = this.jedisCluster.eval(script, Collections.singletonList(this.lock_key), Collections.singletonList(key));
        return "1".equals(result.toString());
    }
}

