/*
 * Decompiled with CFR 0.152.
 */
package com.luues.redis.single.aspect;

import com.luues.exception.ExceptionRediscacheKeyInvalid;
import com.luues.exception.ExceptionRedissynchroizedInvalid;
import com.luues.redis.single.cache.RedisCache;
import com.luues.redis.single.cache.RedisCacheEvict;
import com.luues.redis.single.cache.RedisCachePut;
import com.luues.redis.single.lock.RedisSynchroized;
import com.luues.redis.single.service.JedisTemplate;
import com.luues.redis.util.CommontUtil;
import com.luues.util.TypeConvert;
import com.luues.util.encryption.SerializingUtil;
import com.luues.util.logs.LogUtil;
import java.lang.reflect.Method;
import java.util.Iterator;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class RedisCacheAspect {
    @Autowired
    private JedisTemplate jedisTemplate;

    @Pointcut(value="@annotation(com.luues.redis.single.cache.RedisCache)")
    public void cacheAspect() {
    }

    @Around(value="cacheAspect()")
    public Object cacheAspect(ProceedingJoinPoint joinPoint) throws Throwable {
        Method objMethod = ((MethodSignature)joinPoint.getSignature()).getMethod();
        RedisCache rediscache = objMethod.getAnnotation(RedisCache.class);
        String key = null;
        Integer expire = null;
        String condition = null;
        if (rediscache != null) {
            key = rediscache.key();
            expire = rediscache.expire();
            condition = rediscache.condition();
        }
        String an = "@RedisCache";
        if (TypeConvert.isNull((Object[])new Object[]{key})) {
            throw new ExceptionRediscacheKeyInvalid((Object)(an + " key() is not null!"));
        }
        if (TypeConvert.isNull((Object[])new Object[]{expire})) {
            expire = -1;
        }
        Object[] objects = joinPoint.getArgs();
        String condition_ = "true";
        if (!TypeConvert.isNull((Object[])new Object[]{condition})) {
            condition_ = CommontUtil.getConditionOrKey(condition, objMethod, objects, an);
            condition_ = CommontUtil.valiCondition(condition_, an);
        }
        if (condition_.equals("true")) {
            String key_ = CommontUtil.getConditionOrKey(key, objMethod, objects, an);
            return CommontUtil.getRedisCacheInfo(this.jedisTemplate, key_, joinPoint, expire);
        }
        try {
            return joinPoint.proceed();
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    @Pointcut(value="@annotation(com.luues.redis.single.cache.RedisCachePut)")
    public void cachePutAspect() {
    }

    @Around(value="cachePutAspect()")
    public Object cachePutAspect(ProceedingJoinPoint joinPoint) throws Throwable {
        Method objMethod = ((MethodSignature)joinPoint.getSignature()).getMethod();
        RedisCachePut rediscachePut = objMethod.getAnnotation(RedisCachePut.class);
        String key = null;
        Integer expire = null;
        String condition = null;
        if (rediscachePut != null) {
            key = rediscachePut.key();
            expire = rediscachePut.expire();
            condition = rediscachePut.condition();
        }
        String an = "@RedisCachePut";
        if (TypeConvert.isNull((Object[])new Object[]{key})) {
            throw new ExceptionRediscacheKeyInvalid((Object)(an + " key() is not null!"));
        }
        if (TypeConvert.isNull((Object[])new Object[]{expire})) {
            expire = -1;
        }
        Object[] objects = joinPoint.getArgs();
        String condition_ = "true";
        if (!TypeConvert.isNull((Object[])new Object[]{condition})) {
            condition_ = CommontUtil.getConditionOrKey(condition, objMethod, objects, an);
            condition_ = CommontUtil.valiCondition(condition_, an);
        }
        if (condition_.equals("true")) {
            String key_ = CommontUtil.getConditionOrKey(key, objMethod, objects, an);
            Object object = joinPoint.proceed();
            if (expire >= 0) {
                this.jedisTemplate.setex(key_.getBytes(), (int)expire, SerializingUtil.serialize((Object)object));
            } else {
                this.jedisTemplate.set(key_.getBytes(), SerializingUtil.serialize((Object)object));
            }
            LogUtil.debug((String)"\n{\n{\u3000\u3000\u3000\u3000\u3000The return data of this method has been updated by redis}\n}");
            return object;
        }
        try {
            return joinPoint.proceed();
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    @Pointcut(value="@annotation(com.luues.redis.single.cache.RedisCacheEvict)")
    public void cacheEvictAspect() {
    }

    @Around(value="cacheEvictAspect()")
    public Object cacheEvictAspect(ProceedingJoinPoint joinPoint) throws Throwable {
        Method objMethod = ((MethodSignature)joinPoint.getSignature()).getMethod();
        RedisCacheEvict rediscacheEvict = objMethod.getAnnotation(RedisCacheEvict.class);
        Object[] keys = null;
        String condition = null;
        if (rediscacheEvict != null) {
            keys = rediscacheEvict.key();
            condition = rediscacheEvict.condition();
        }
        String an = "@RedisCacheEvict";
        if (TypeConvert.isNull((Object[])keys)) {
            throw new ExceptionRediscacheKeyInvalid((Object)(an + " key() is not null!"));
        }
        Object[] objects = joinPoint.getArgs();
        String condition_ = "true";
        if (!TypeConvert.isNull((Object[])new Object[]{condition})) {
            condition_ = CommontUtil.getConditionOrKey(condition, objMethod, objects, an);
            condition_ = CommontUtil.valiCondition(condition_, an);
        }
        if (condition_.equals("true")) {
            for (Object key : keys) {
                Object key_ = "";
                if (((String)key).contains("#{*}")) {
                    try {
                        String k = ((String)key).split("#\\{\\*\\}")[0];
                        Iterator<String> iterator = this.jedisTemplate.keys(k + "*").iterator();
                        while (iterator.hasNext()) {
                            this.jedisTemplate.del(iterator.next());
                        }
                        continue;
                    }
                    catch (Exception e) {
                        throw new ExceptionRediscacheKeyInvalid((Object)(an + " key() is error!"));
                    }
                }
                key_ = ((String)key).contains("#{") ? CommontUtil.getConditionOrKey((String)key, objMethod, objects, an) : key;
                if (!this.jedisTemplate.exists(((String)key_).getBytes()).booleanValue()) continue;
                this.jedisTemplate.del(((String)key_).getBytes());
            }
            Object object = joinPoint.proceed();
            LogUtil.debug((String)"\n{\n{\u3000\u3000\u3000\u3000\u3000The redis data cached by this method has been emptied}\n}");
            return object;
        }
        try {
            return joinPoint.proceed();
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    @Pointcut(value="@annotation(com.luues.redis.single.lock.RedisSynchroized)")
    public void synchroizedAspect() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Around(value="synchroizedAspect()")
    public Object synchroizedAspect(ProceedingJoinPoint joinPoint) throws Throwable {
        Method objMethod = ((MethodSignature)joinPoint.getSignature()).getMethod();
        RedisSynchroized redissynchroized = objMethod.getAnnotation(RedisSynchroized.class);
        String key = null;
        Integer expire = null;
        String condition = null;
        Integer time = null;
        boolean manyTimes = true;
        if (redissynchroized != null) {
            key = redissynchroized.key();
            expire = redissynchroized.expire();
            condition = redissynchroized.condition();
            time = redissynchroized.time();
            manyTimes = redissynchroized.manyTimes();
        }
        String an = "@RedisSynchroized";
        if (TypeConvert.isNull((Object[])new Object[]{key})) {
            throw new ExceptionRediscacheKeyInvalid((Object)(an + " key() is not null!"));
        }
        if (TypeConvert.isNull((Object[])new Object[]{expire})) {
            expire = -1;
        }
        Object[] objects = joinPoint.getArgs();
        String condition_ = "true";
        if (!TypeConvert.isNull((Object[])new Object[]{condition})) {
            condition_ = CommontUtil.getConditionOrKey(condition, objMethod, objects, an);
            condition_ = CommontUtil.valiCondition(condition_, an);
        }
        if (condition_.equals("true")) {
            String key_ = CommontUtil.getConditionOrKey(key, objMethod, objects, an);
            if (!manyTimes) {
                if (this.jedisTemplate.exists((key_ + "manyTimes").getBytes()).booleanValue()) {
                    throw new ExceptionRedissynchroizedInvalid((Object)"\u9891\u7e41\u8bf7\u6c42!");
                }
                this.jedisTemplate.lpush((key_ + "manyTimes").getBytes(), "SUCCESS".getBytes());
                this.jedisTemplate.expire((key_ + "manyTimes").getBytes(), (Integer)1800);
            }
            String string = key_.intern();
            synchronized (string) {
                byte[] data = this.jedisTemplate.lpop(key_.getBytes());
                if (!TypeConvert.isNull((Object[])new Object[]{data})) {
                    if (time > 0) {
                        this.jedisTemplate.lpush(key_.getBytes(), String.valueOf(System.currentTimeMillis()).getBytes());
                    } else {
                        this.jedisTemplate.lpush(key_.getBytes(), "SUCCESS".getBytes());
                    }
                    this.jedisTemplate.expire(key_.getBytes(), expire);
                    if (new String(data, "utf-8").equals("SUCCESS")) {
                        throw new ExceptionRedissynchroizedInvalid((Object)"\u9891\u7e41\u8bf7\u6c42!");
                    }
                    Long time_ = (System.currentTimeMillis() - Long.valueOf(new String(data, "utf-8"))) / 1000L;
                    if (time_ <= (long)time.intValue()) {
                        throw new ExceptionRedissynchroizedInvalid((Object)("\u60a8\u7684\u624b\u901f\u592a\u5feb\u4e86,\u8bf7\u8fc7" + time + "\u79d2\u540e\u518d\u8bd5!"));
                    }
                } else {
                    if (time > 0) {
                        this.jedisTemplate.lpush(key_.getBytes(), String.valueOf(System.currentTimeMillis()).getBytes());
                    } else {
                        this.jedisTemplate.lpush(key_.getBytes(), "SUCCESS".getBytes());
                    }
                    this.jedisTemplate.expire(key_.getBytes(), expire);
                    if (time <= 0) {
                        this.jedisTemplate.lpop(key_.getBytes());
                    }
                }
                this.jedisTemplate.del((key_ + "manyTimes").getBytes());
                return joinPoint.proceed();
            }
        }
        return joinPoint.proceed();
    }
}

