/*
 * Decompiled with CFR 0.152.
 */
package com.luues.redis.cluster.aspect;

import com.luues.exception.core.other.ExceptionRediscacheKeyInvalid;
import com.luues.exception.core.other.ExceptionRedissynchroizedInvalid;
import com.luues.redis.cluster.cache.RedisClusterCache;
import com.luues.redis.cluster.cache.RedisClusterCacheEvict;
import com.luues.redis.cluster.cache.RedisClusterCachePut;
import com.luues.redis.cluster.lock.RedisClusterSynchroized;
import com.luues.redis.cluster.service.JedisClusterTemplate;
import com.luues.redis.util.CommontUtil;
import com.luues.util.TypeConvert;
import com.luues.util.encryption.SerializingUtil;
import com.luues.util.logs.LogUtil;
import java.lang.reflect.Method;
import java.util.Iterator;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class RedisClusterCacheAspect {
    @Autowired
    private JedisClusterTemplate jedisClusterTemplate;

    @Pointcut(value="@annotation(com.luues.redis.cluster.cache.RedisClusterCache)")
    public void clusterCacheAspect() {
    }

    @Around(value="clusterCacheAspect()")
    public Object clusterCacheAspect(ProceedingJoinPoint joinPoint) throws Throwable {
        Class<?> classTarget = joinPoint.getTarget().getClass();
        Class[] par = ((MethodSignature)joinPoint.getSignature()).getParameterTypes();
        Method objMethod = classTarget.getMethod(joinPoint.getSignature().getName(), par);
        RedisClusterCache rediscache = objMethod.getAnnotation(RedisClusterCache.class);
        String key = null;
        Integer expire = null;
        String condition = null;
        if (rediscache != null) {
            key = rediscache.key();
            expire = rediscache.expire();
            condition = rediscache.condition();
        }
        String an = "@RedisClusterCache";
        if (TypeConvert.isNull((Object[])new Object[]{key})) {
            throw new ExceptionRediscacheKeyInvalid((Object)(an + " key() is not null!"));
        }
        if (TypeConvert.isNull((Object[])new Object[]{expire})) {
            expire = -1;
        }
        Object[] objects = joinPoint.getArgs();
        String condition_ = "true";
        if (!TypeConvert.isNull((Object[])new Object[]{condition})) {
            condition_ = CommontUtil.getConditionOrKey(condition, objMethod, objects, an);
            condition_ = CommontUtil.valiCondition(condition_, an);
        }
        if (condition_.equals("true")) {
            String key_ = CommontUtil.getConditionOrKey(key, objMethod, objects, an);
            return CommontUtil.getRedisClusterCacheInfo(this.jedisClusterTemplate, key_, joinPoint, expire);
        }
        try {
            return joinPoint.proceed();
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    @Pointcut(value="@annotation(com.luues.redis.cluster.cache.RedisClusterCachePut)")
    public void clusterCachePutAspect() {
    }

    @Around(value="clusterCachePutAspect()")
    public Object clusterCachePutAspect(ProceedingJoinPoint joinPoint) throws Throwable {
        Method objMethod = ((MethodSignature)joinPoint.getSignature()).getMethod();
        RedisClusterCachePut redisClusterCachePut = objMethod.getAnnotation(RedisClusterCachePut.class);
        String key = null;
        Integer expire = null;
        String condition = null;
        if (redisClusterCachePut != null) {
            key = redisClusterCachePut.key();
            expire = redisClusterCachePut.expire();
            condition = redisClusterCachePut.condition();
        }
        String an = "@RedisClusterCachePut";
        if (TypeConvert.isNull((Object[])new Object[]{key})) {
            throw new ExceptionRediscacheKeyInvalid((Object)(an + " key() is not null!"));
        }
        if (TypeConvert.isNull((Object[])new Object[]{expire})) {
            expire = -1;
        }
        Object[] objects = joinPoint.getArgs();
        String condition_ = "true";
        if (!TypeConvert.isNull((Object[])new Object[]{condition})) {
            condition_ = CommontUtil.getConditionOrKey(condition, objMethod, objects, an);
            condition_ = CommontUtil.valiCondition(condition_, an);
        }
        if (condition_.equals("true")) {
            String key_ = CommontUtil.getConditionOrKey(key, objMethod, objects, an);
            Object object = joinPoint.proceed();
            if (expire >= 0) {
                this.jedisClusterTemplate.setex(key_.getBytes(), (int)expire, SerializingUtil.serialize((Object)object));
            } else {
                this.jedisClusterTemplate.set(key_.getBytes(), SerializingUtil.serialize((Object)object));
            }
            LogUtil.debug((String)"\n{\n{\u3000\u3000\u3000\u3000\u3000The return data of this method has been updated by redis}\n}");
            return object;
        }
        try {
            return joinPoint.proceed();
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    @Pointcut(value="@annotation(com.luues.redis.cluster.cache.RedisClusterCacheEvict)")
    public void clusterCacheEvictAspect() {
    }

    @Around(value="clusterCacheEvictAspect()")
    public Object clusterCacheEvictAspect(ProceedingJoinPoint joinPoint) throws Throwable {
        Method objMethod = ((MethodSignature)joinPoint.getSignature()).getMethod();
        RedisClusterCacheEvict redisClusterCacheEvict = objMethod.getAnnotation(RedisClusterCacheEvict.class);
        Object[] keys = null;
        String condition = null;
        if (redisClusterCacheEvict != null) {
            keys = redisClusterCacheEvict.key();
            condition = redisClusterCacheEvict.condition();
        }
        String an = "@RedisClusterCacheEvict";
        if (TypeConvert.isNull((Object[])keys)) {
            throw new ExceptionRediscacheKeyInvalid((Object)(an + " key() is not null!"));
        }
        Object[] objects = joinPoint.getArgs();
        String condition_ = "true";
        if (!TypeConvert.isNull((Object[])new Object[]{condition})) {
            condition_ = CommontUtil.getConditionOrKey(condition, objMethod, objects, an);
            condition_ = CommontUtil.valiCondition(condition_, an);
        }
        if (condition_.equals("true")) {
            for (Object key : keys) {
                Object key_ = "";
                if (((String)key).contains("#{*}")) {
                    try {
                        String k = ((String)key).split("#\\{\\*\\}")[0];
                        Iterator<String> iterator = this.jedisClusterTemplate.keys(k + "*").iterator();
                        while (iterator.hasNext()) {
                            this.jedisClusterTemplate.del(iterator.next());
                        }
                        continue;
                    }
                    catch (Exception e) {
                        throw new ExceptionRediscacheKeyInvalid((Object)(an + " key() is error!"));
                    }
                }
                key_ = ((String)key).contains("#{") ? CommontUtil.getConditionOrKey((String)key, objMethod, objects, an) : key;
                if (!this.jedisClusterTemplate.exists(((String)key_).getBytes()).booleanValue()) continue;
                this.jedisClusterTemplate.del(((String)key_).getBytes());
            }
            Object object = joinPoint.proceed();
            LogUtil.debug((String)"\n{\n{\u3000\u3000\u3000\u3000\u3000The redis data cached by this method has been emptied}\n}");
            return object;
        }
        try {
            return joinPoint.proceed();
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    @Pointcut(value="@annotation(com.luues.redis.cluster.lock.RedisClusterSynchroized)")
    public void clusterSynchroizedAspect() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Around(value="clusterSynchroizedAspect()")
    public Object clusterSynchroizedAspect(ProceedingJoinPoint joinPoint) throws Throwable {
        Method objMethod = ((MethodSignature)joinPoint.getSignature()).getMethod();
        RedisClusterSynchroized redisClusterSynchroized = objMethod.getAnnotation(RedisClusterSynchroized.class);
        String key = null;
        Integer expire = null;
        String condition = null;
        Integer time = null;
        if (redisClusterSynchroized != null) {
            key = redisClusterSynchroized.key();
            expire = redisClusterSynchroized.expire();
            condition = redisClusterSynchroized.condition();
            time = redisClusterSynchroized.time();
        }
        String an = "@RedisClusterSynchroized";
        if (TypeConvert.isNull((Object[])new Object[]{key})) {
            throw new ExceptionRediscacheKeyInvalid((Object)(an + " key() is not null!"));
        }
        if (TypeConvert.isNull((Object[])new Object[]{expire})) {
            expire = -1;
        }
        Object[] objects = joinPoint.getArgs();
        String condition_ = "true";
        if (!TypeConvert.isNull((Object[])new Object[]{condition})) {
            condition_ = CommontUtil.getConditionOrKey(condition, objMethod, objects, an);
            condition_ = CommontUtil.valiCondition(condition_, an);
        }
        if (condition_.equals("true")) {
            String key_ = CommontUtil.getConditionOrKey(key, objMethod, objects, an);
            String string = key_.intern();
            synchronized (string) {
                byte[] data = this.jedisClusterTemplate.lpop(key_.getBytes());
                if (!TypeConvert.isNull((Object[])new Object[]{data})) {
                    if (time > 0) {
                        this.jedisClusterTemplate.lpush(key_.getBytes(), String.valueOf(System.currentTimeMillis()).getBytes());
                    } else {
                        this.jedisClusterTemplate.lpush(key_.getBytes(), "SUCCESS".getBytes());
                    }
                    this.jedisClusterTemplate.expire(key_.getBytes(), expire);
                    if (new String(data, "utf-8").equals("SUCCESS")) {
                        throw new ExceptionRedissynchroizedInvalid((Object)"\u9891\u7e41\u8bf7\u6c42!");
                    }
                    Long time_ = (System.currentTimeMillis() - Long.valueOf(new String(data, "utf-8"))) / 1000L;
                    if (time_ <= (long)time.intValue()) {
                        throw new ExceptionRedissynchroizedInvalid((Object)("\u60a8\u7684\u624b\u901f\u592a\u5feb\u4e86,\u8bf7\u8fc7" + time + "\u79d2\u540e\u518d\u8bd5!"));
                    }
                } else {
                    if (time > 0) {
                        this.jedisClusterTemplate.lpush(key_.getBytes(), String.valueOf(System.currentTimeMillis()).getBytes());
                    } else {
                        this.jedisClusterTemplate.lpush(key_.getBytes(), "SUCCESS".getBytes());
                    }
                    this.jedisClusterTemplate.expire(key_.getBytes(), expire);
                    if (time <= 0) {
                        this.jedisClusterTemplate.lpop(key_.getBytes());
                    }
                }
                return joinPoint.proceed();
            }
        }
        return joinPoint.proceed();
    }
}

