/*
 * Decompiled with CFR 0.152.
 */
package com.luues.redis.cluster.config;

import com.luues.redis.cluster.config.JedisClusterFactory;
import com.luues.util.logs.LogUtil;
import java.util.Collections;
import java.util.HashSet;
import org.apache.commons.compress.utils.Sets;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnExpression(value="!'null'.equals('${spring.redis.cluster.nodes:null}')")
public class RedisClusterConfig {
    @Bean(name={"jedisCluster"})
    public JedisClusterFactory jedisCluster(@Value(value="${spring.redis.cluster.nodes:null}") String host) {
        if (StringUtils.isEmpty((String)host)) {
            LogUtil.error((String)"\n{\n\u3000\u3000\u3000\u3000\u3000To use redis-cluster, configure it first\n", (Object[])new Object[]{"\n\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000spring.redis.cluster.nodes=ip:host\n}"});
            return null;
        }
        JedisClusterFactory jedisClusterFactory = new JedisClusterFactory();
        String[] split = host.split(",");
        HashSet hosts = Sets.newHashSet((Object[])new String[0]);
        Collections.addAll(hosts, split);
        jedisClusterFactory.setJedisClusterNodes(hosts);
        return jedisClusterFactory;
    }
}

