/*
 * Decompiled with CFR 0.152.
 */
package com.luues.redis.single.config;

import com.luues.exception.core.other.ExceptionRedisInvalid;
import com.luues.util.TypeConvert;
import com.luues.util.logs.LogUtil;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.cache.annotation.CachingConfigurerSupport;
import org.springframework.cache.annotation.EnableCaching;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.redis.cache.RedisCacheConfiguration;
import org.springframework.data.redis.cache.RedisCacheManager;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.connection.jedis.JedisConnectionFactory;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.data.redis.serializer.GenericJackson2JsonRedisSerializer;
import org.springframework.data.redis.serializer.RedisSerializationContext;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.data.redis.serializer.StringRedisSerializer;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.JedisPoolConfig;
import redis.clients.jedis.JedisShardInfo;
import redis.clients.jedis.ShardedJedisPool;

@Configuration
@EnableCaching
@ConditionalOnExpression(value="!'null'.equals('${redis.hostName:null}')")
public class RedisConfig
extends CachingConfigurerSupport {
    @Value(value="${redis.maxIdle:300}")
    private Integer maxIdle;
    @Value(value="${redis.maxTotal:1000}")
    private Integer maxTotal;
    @Value(value="${redis.maxWaitMillis:1000}")
    private Integer maxWaitMillis;
    @Value(value="${redis.minEvictableIdleTimeMillis:1800000}")
    private Integer minEvictableIdleTimeMillis;
    @Value(value="${redis.numTestsPerEvictionRun:3}")
    private Integer numTestsPerEvictionRun;
    @Value(value="${redis.timeBetweenEvictionRunsMillis:-1}")
    private long timeBetweenEvictionRunsMillis;
    @Value(value="${redis.testOnBorrow:true}")
    private boolean testOnBorrow;
    @Value(value="${redis.testOnReturn:true}")
    private boolean testOnReturn;
    @Value(value="${redis.testWhileIdle:true}")
    private boolean testWhileIdle;
    @Value(value="${redis.hostName:null}")
    private String hostName;
    @Value(value="${redis.port:0}")
    private Integer port;
    @Value(value="${redis.timeout:2000}")
    private Integer timeout;
    @Value(value="${redis.password:null}")
    private String password;

    @Bean
    public JedisPoolConfig jedisPoolConfig() throws ExceptionRedisInvalid {
        JedisPoolConfig jedisPoolConfig = new JedisPoolConfig();
        jedisPoolConfig.setMaxIdle(this.maxIdle.intValue());
        jedisPoolConfig.setMaxTotal(this.maxTotal.intValue());
        jedisPoolConfig.setMaxWaitMillis((long)this.maxWaitMillis.intValue());
        jedisPoolConfig.setMinEvictableIdleTimeMillis((long)this.minEvictableIdleTimeMillis.intValue());
        jedisPoolConfig.setNumTestsPerEvictionRun(this.numTestsPerEvictionRun.intValue());
        jedisPoolConfig.setTimeBetweenEvictionRunsMillis(this.timeBetweenEvictionRunsMillis);
        jedisPoolConfig.setTestOnBorrow(this.testOnBorrow);
        jedisPoolConfig.setTestOnReturn(this.testOnReturn);
        jedisPoolConfig.setTestWhileIdle(this.testWhileIdle);
        if (TypeConvert.isNull((Object[])new Object[]{this.hostName}) || this.port <= 0) {
            LogUtil.error((String)"\n{\n\u3000\u3000\u3000\u3000\u3000{}\n}\n", (Object[])new Object[]{"redis start failed, because no host, port, etc. information is configured\n\u3000\u3000\u3000\u3000\u3000See application.properties below jar for details"});
            throw new ExceptionRedisInvalid((Object)"redis start failed, because no host, port, etc. information is configured");
        }
        LogUtil.info((String)"redis start...\u3000\u3000\u3000\u3000\u3000hostName:{},port:{},password:{},MaxTotal:{},MaxIdle:{},MaxWaitMillis:{},TestOnBorrow:{},testOnReturn:{},minEvictableIdleTimeMillis:{},numTestsPerEvictionRun:{},timeBetweenEvictionRunsMillis:{},testWhileIdle:{}", (Object[])new Object[]{this.hostName, this.port, this.password, this.maxTotal, this.maxIdle, this.maxWaitMillis, this.testOnBorrow, this.testOnReturn, this.minEvictableIdleTimeMillis, this.numTestsPerEvictionRun, this.timeBetweenEvictionRunsMillis, this.testWhileIdle});
        return jedisPoolConfig;
    }

    @Bean
    @Qualifier(value="jedisShardInfos")
    public List<JedisShardInfo> jedisShardInfos() {
        ArrayList<JedisShardInfo> shards = new ArrayList<JedisShardInfo>();
        JedisShardInfo jedisShardInfo = new JedisShardInfo(this.hostName, this.port.intValue());
        if (!TypeConvert.isNull((Object[])new Object[]{this.password})) {
            jedisShardInfo.setPassword(this.password);
        }
        shards.add(jedisShardInfo);
        return shards;
    }

    @Bean
    public ShardedJedisPool shardedJedisPool(JedisPoolConfig jedisPoolConfig, @Qualifier(value="jedisShardInfos") List<JedisShardInfo> jedisShardInfos) {
        ShardedJedisPool shardedJedisPool = new ShardedJedisPool((GenericObjectPoolConfig)jedisPoolConfig, jedisShardInfos);
        return shardedJedisPool;
    }

    @Bean
    public JedisPool jedisPool(JedisPoolConfig jedisPoolConfig) {
        JedisPool jedisPool = null;
        jedisPool = !TypeConvert.isNull((Object[])new Object[]{this.password}) ? new JedisPool((GenericObjectPoolConfig)jedisPoolConfig, this.hostName, this.port.intValue(), this.timeout.intValue(), this.password) : new JedisPool((GenericObjectPoolConfig)jedisPoolConfig, this.hostName, this.port.intValue());
        return jedisPool;
    }

    @Bean
    public RedisConnectionFactory redisConnectionFactory(JedisPoolConfig jedisPoolConfig) {
        JedisConnectionFactory jedisConnectionFactory = new JedisConnectionFactory(jedisPoolConfig);
        jedisConnectionFactory.setHostName(this.hostName);
        jedisConnectionFactory.setTimeout(this.timeout.intValue());
        jedisConnectionFactory.setPort(this.port.intValue());
        if (!TypeConvert.isNull((Object[])new Object[]{this.password})) {
            jedisConnectionFactory.setPassword(this.password);
        }
        return jedisConnectionFactory;
    }

    @Bean
    public RedisCacheManager cacheManager(RedisConnectionFactory redisConnectionFactory) {
        RedisCacheConfiguration config = RedisCacheConfiguration.defaultCacheConfig().entryTtl(Duration.ofMinutes(30L)).serializeKeysWith(RedisSerializationContext.SerializationPair.fromSerializer(this.keySerializer())).serializeValuesWith(RedisSerializationContext.SerializationPair.fromSerializer(this.valueSerializer())).disableCachingNullValues();
        RedisCacheManager redisCacheManager = RedisCacheManager.builder((RedisConnectionFactory)redisConnectionFactory).cacheDefaults(config).transactionAware().build();
        return redisCacheManager;
    }

    @Bean
    public RedisTemplate<String, Object> redisTemplate(RedisConnectionFactory redisConnectionFactory) {
        RedisTemplate redisTemplate = new RedisTemplate();
        redisTemplate.setConnectionFactory(redisConnectionFactory);
        redisTemplate.setKeySerializer(this.keySerializer());
        redisTemplate.setHashKeySerializer(this.keySerializer());
        redisTemplate.setValueSerializer(this.valueSerializer());
        redisTemplate.setHashValueSerializer(this.valueSerializer());
        return redisTemplate;
    }

    @Bean
    public StringRedisTemplate stringRedisTemplate(RedisConnectionFactory redisConnectionFactory) {
        StringRedisTemplate stringRedisTemplate = new StringRedisTemplate();
        stringRedisTemplate.setConnectionFactory(redisConnectionFactory);
        stringRedisTemplate.setKeySerializer(this.keySerializer());
        return stringRedisTemplate;
    }

    private RedisSerializer<String> keySerializer() {
        return new StringRedisSerializer();
    }

    private RedisSerializer<Object> valueSerializer() {
        return new GenericJackson2JsonRedisSerializer();
    }
}

