/*
 * Decompiled with CFR 0.152.
 */
package com.luues.redis.single.service;

import com.luues.util.logs.LogUtil;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.ScanParams;
import redis.clients.jedis.ScanResult;
import redis.clients.jedis.ShardedJedis;
import redis.clients.jedis.ShardedJedisPool;
import redis.clients.jedis.Tuple;

@Component
public class JedisTemplate {
    @Autowired(required=false)
    private ShardedJedisPool shardedJedisPool;
    @Autowired(required=false)
    private JedisPool jedisPool;
    private String lock_key = "JEDIS_LOCK:";
    private int timeout = 5;

    public JedisPool getJedisPool() {
        return this.jedisPool;
    }

    public boolean init() {
        return null != this.shardedJedisPool;
    }

    public Jedis getJedis() {
        if (null == this.jedisPool) {
            LogUtil.error((String)"{}", (Object[])new Object[]{"single-redis is null,\u9700\u8981\u4f7f\u7528\u8bf7\u5148\u914d\u7f6e\uff01"});
        }
        return this.jedisPool.getResource();
    }

    public ShardedJedis getShardedJedis() {
        if (null == this.shardedJedisPool) {
            LogUtil.error((String)"{}", (Object[])new Object[]{"single-redis is null,\u9700\u8981\u4f7f\u7528\u8bf7\u5148\u914d\u7f6e\uff01"});
        }
        return this.shardedJedisPool.getResource();
    }

    public Set<String> keys(String pattern) {
        HashSet<String> stringSet = new HashSet<String>();
        String cursor = ScanParams.SCAN_POINTER_START;
        ScanParams scanParams = new ScanParams();
        scanParams.match(pattern);
        scanParams.count(Integer.valueOf(1000));
        do {
            ScanResult<String> sscanResult = this.scan(cursor, scanParams);
            cursor = sscanResult.getStringCursor();
            stringSet.addAll(sscanResult.getResult());
        } while (!"0".equals(cursor));
        return stringSet;
    }

    public void delKeys(String pattern) {
        Set<String> strings = this.keys(pattern);
        if (strings.size() == 0) {
            return;
        }
        Iterator<String> iterator = strings.iterator();
        while (iterator.hasNext()) {
            this.del(iterator.next());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ScanResult<String> scan(String cursor, ScanParams scanParams) {
        try (Jedis jedis = this.getJedis();){
            ScanResult scanResult = jedis.scan(cursor, scanParams);
            return scanResult;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long expire(String key, Integer seconds) {
        try (ShardedJedis shardedJedis = this.getShardedJedis();){
            Long l = shardedJedis.expire(key, seconds.intValue());
            return l;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long expire(byte[] key, Integer seconds) {
        try (ShardedJedis shardedJedis = this.getShardedJedis();){
            Long l = shardedJedis.expire(key, seconds.intValue());
            return l;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void set(String key, String value) {
        try (ShardedJedis shardedJedis = this.getShardedJedis();){
            shardedJedis.set(key, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void set(byte[] key, byte[] value) {
        try (ShardedJedis shardedJedis = this.getShardedJedis();){
            shardedJedis.set(key, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setex(String key, int seconds, String value) {
        try (ShardedJedis shardedJedis = this.getShardedJedis();){
            shardedJedis.setex(key, seconds, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setex(byte[] key, int seconds, byte[] value) {
        try (ShardedJedis shardedJedis = this.getShardedJedis();){
            shardedJedis.setex(key, seconds, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String get(String key) {
        try (ShardedJedis shardedJedis = this.getShardedJedis();){
            String string = shardedJedis.get(key);
            return string;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] get(byte[] key) {
        try (ShardedJedis shardedJedis = this.getShardedJedis();){
            byte[] byArray = shardedJedis.get(key);
            return byArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void zadd(String key, double score, String value) {
        try (ShardedJedis shardedJedis = this.getShardedJedis();){
            shardedJedis.zadd(key, score, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void zadd(byte[] key, double score, byte[] value) {
        try (ShardedJedis shardedJedis = this.getShardedJedis();){
            shardedJedis.zadd(key, score, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> zrevrange(String key, long start, long end) {
        try (ShardedJedis shardedJedis = this.getShardedJedis();){
            Set set = shardedJedis.zrevrange(key, start, end);
            return set;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<byte[]> zrevrange(byte[] key, long start, long end) {
        try (ShardedJedis shardedJedis = this.getShardedJedis();){
            Set set = shardedJedis.zrevrange(key, start, end);
            return set;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<Tuple> zrevrangeWithScores(String key, long start, long end) {
        try (ShardedJedis shardedJedis = this.getShardedJedis();){
            Set set = shardedJedis.zrevrangeWithScores(key, start, end);
            return set;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<Tuple> zrevrangeWithScores(byte[] key, long start, long end) {
        try (ShardedJedis shardedJedis = this.getShardedJedis();){
            Set set = shardedJedis.zrevrangeWithScores(key, start, end);
            return set;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sadd(String key, String ... value) {
        try (ShardedJedis shardedJedis = this.getShardedJedis();){
            shardedJedis.sadd(key, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sadd(byte[] key, byte[] ... value) {
        try (ShardedJedis shardedJedis = this.getShardedJedis();){
            shardedJedis.sadd(key, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long srem(String key, String ... value) {
        try (ShardedJedis shardedJedis = this.getShardedJedis();){
            Long l = shardedJedis.srem(key, value);
            return l;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long srem(byte[] key, byte[] ... value) {
        try (ShardedJedis shardedJedis = this.getShardedJedis();){
            Long l = shardedJedis.srem(key, value);
            return l;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long scard(String key) {
        try (ShardedJedis shardedJedis = this.getShardedJedis();){
            Long l = shardedJedis.scard(key);
            return l;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long scard(byte[] key) {
        try (ShardedJedis shardedJedis = this.getShardedJedis();){
            Long l = shardedJedis.scard(key);
            return l;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rpush(String key, String ... value) {
        try (ShardedJedis shardedJedis = this.getShardedJedis();){
            shardedJedis.rpush(key, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rpush(byte[] key, byte[] ... value) {
        try (ShardedJedis shardedJedis = this.getShardedJedis();){
            shardedJedis.rpush(key, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String rpop(String key) {
        try (ShardedJedis shardedJedis = this.getShardedJedis();){
            String string = shardedJedis.rpop(key);
            return string;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] rpop(byte[] key) {
        try (ShardedJedis shardedJedis = this.getShardedJedis();){
            byte[] byArray = shardedJedis.rpop(key);
            return byArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Boolean exists(String key) {
        try (ShardedJedis shardedJedis = this.getShardedJedis();){
            Boolean bl = shardedJedis.exists(key);
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Boolean exists(byte[] key) {
        try (ShardedJedis shardedJedis = this.getShardedJedis();){
            Boolean bl = shardedJedis.exists(key);
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long del(String key) {
        try (ShardedJedis shardedJedis = this.getShardedJedis();){
            if (this.exists(key).booleanValue()) {
                Long l = shardedJedis.del(key);
                return l;
            }
            Long l = -1L;
            return l;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long del(byte[] key) {
        try (ShardedJedis shardedJedis = this.getShardedJedis();){
            if (this.exists(key).booleanValue()) {
                Long l = shardedJedis.del(key);
                return l;
            }
            Long l = -1L;
            return l;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long incr(String key) {
        try (ShardedJedis shardedJedis = this.getShardedJedis();){
            Long l = shardedJedis.incr(key);
            return l;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long incr(byte[] key) {
        try (ShardedJedis shardedJedis = this.getShardedJedis();){
            Long l = shardedJedis.incr(key);
            return l;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void lpush(byte[] key, byte[] value) {
        try (ShardedJedis shardedJedis = this.getShardedJedis();){
            shardedJedis.lpush(key, (byte[][])new byte[][]{value});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void lpush(String key, String value) {
        try (ShardedJedis shardedJedis = this.getShardedJedis();){
            shardedJedis.lpush(key, new String[]{value});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] lpop(byte[] key) {
        try (ShardedJedis shardedJedis = this.getShardedJedis();){
            byte[] byArray = shardedJedis.lpop(key);
            return byArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String lpop(String key) {
        try (ShardedJedis shardedJedis = this.getShardedJedis();){
            String string = shardedJedis.lpop(key);
            return string;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long llen(byte[] key) {
        try (ShardedJedis shardedJedis = this.getShardedJedis();){
            Long l = shardedJedis.llen(key);
            return l;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long llen(String key) {
        try (ShardedJedis shardedJedis = this.getShardedJedis();){
            Long l = shardedJedis.llen(key);
            return l;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> lrange(String key) {
        try (ShardedJedis shardedJedis = this.getShardedJedis();){
            List list = shardedJedis.lrange(key, 0L, this.llen(key).longValue());
            return list;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<byte[]> lrange(byte[] key) {
        try (ShardedJedis shardedJedis = this.getShardedJedis();){
            List list = shardedJedis.lrange(key, 0L, this.llen(key).longValue());
            return list;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long hset(String key, String field, String value) {
        try (ShardedJedis shardedJedis = this.getShardedJedis();){
            Long l = shardedJedis.hset(key, field, value);
            return l;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long hset(byte[] key, byte[] field, byte[] value) {
        try (ShardedJedis shardedJedis = this.getShardedJedis();){
            Long l = shardedJedis.hset(key, field, value);
            return l;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hexists(String key, String field) {
        try (ShardedJedis shardedJedis = this.getShardedJedis();){
            boolean bl = shardedJedis.hexists(key, field);
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hexists(byte[] key, byte[] field) {
        try (ShardedJedis shardedJedis = this.getShardedJedis();){
            boolean bl = shardedJedis.hexists(key, field);
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> hgetAll(String key) {
        try (ShardedJedis shardedJedis = this.getShardedJedis();){
            Map map = shardedJedis.hgetAll(key);
            return map;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<byte[], byte[]> hgetAll(byte[] key) {
        try (ShardedJedis shardedJedis = this.getShardedJedis();){
            Map map = shardedJedis.hgetAll(key);
            return map;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String hget(String key, String field) {
        try (ShardedJedis shardedJedis = this.getShardedJedis();){
            String string = shardedJedis.hget(key, field);
            return string;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] hget(byte[] key, byte[] field) {
        try (ShardedJedis shardedJedis = this.getShardedJedis();){
            byte[] byArray = shardedJedis.hget(key, field);
            return byArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long hdel(String key, String field) {
        try (ShardedJedis shardedJedis = this.getShardedJedis();){
            Long l = shardedJedis.hdel(key, new String[]{field});
            return l;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long hdel(byte[] key, byte[] field) {
        try (ShardedJedis shardedJedis = this.getShardedJedis();){
            Long l = shardedJedis.hdel(key, (byte[][])new byte[][]{field});
            return l;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ScanResult<String> sscan(String key, String cursor, ScanParams scanParams) {
        try (ShardedJedis shardedJedis = this.getShardedJedis();){
            ScanResult scanResult = shardedJedis.sscan(key, cursor, scanParams);
            return scanResult;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ScanResult<byte[]> sscan(byte[] key, byte[] cursor, ScanParams scanParams) {
        try (ShardedJedis shardedJedis = this.getShardedJedis();){
            ScanResult scanResult = shardedJedis.sscan(key, cursor, scanParams);
            return scanResult;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ScanResult<String> sscan(String key, String cursor) {
        try (ShardedJedis shardedJedis = this.getShardedJedis();){
            ScanResult scanResult = shardedJedis.sscan(key, cursor);
            return scanResult;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ScanResult<byte[]> sscan(byte[] key, byte[] cursor) {
        try (ShardedJedis shardedJedis = this.getShardedJedis();){
            ScanResult scanResult = shardedJedis.sscan(key, cursor);
            return scanResult;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long setnx(byte[] key, byte[] value) {
        try (ShardedJedis shardedJedis = this.getShardedJedis();){
            Long l = shardedJedis.setnx(key, value);
            return l;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long setnx(String key, String value) {
        try (ShardedJedis shardedJedis = this.getShardedJedis();){
            Long l = shardedJedis.setnx(key, value);
            return l;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean lock(String key) {
        try (ShardedJedis shardedJedis = this.getShardedJedis();){
            long start = System.currentTimeMillis();
            long end = start + (long)this.timeout;
            boolean result = false;
            while (!(result = Boolean.valueOf(shardedJedis.setnx(this.lock_key + key, "SUCCESS").toString()).booleanValue()) && System.currentTimeMillis() <= end) {
            }
            boolean bl = result;
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean unlock(String key) {
        String script = "if redis.call('get',KEYS[1]) == ARGV[1] then   return redis.call('del',KEYS[1]) else   return 0 end";
        try (Jedis jedis = this.getJedis();){
            Object result = jedis.eval(script, Collections.singletonList(this.lock_key), Collections.singletonList(key));
            if ("1".equals(result.toString())) {
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
    }
}

