/*
 * Decompiled with CFR 0.152.
 */
package com.luues.redis.util;

import com.luues.exception.core.other.ExceptionRediscacheInvalid;
import com.luues.exception.core.other.ExceptionRediscacheKeyInvalid;
import com.luues.redis.cluster.service.JedisClusterTemplate;
import com.luues.redis.single.service.JedisTemplate;
import com.luues.util.encryption.SerializingUtil;
import com.luues.util.logs.LogUtil;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import org.aspectj.lang.ProceedingJoinPoint;
import org.springframework.core.LocalVariableTableParameterNameDiscoverer;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.ExpressionParser;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.StandardEvaluationContext;

public class CommontUtil {
    private static LocalVariableTableParameterNameDiscoverer parameterNameDiscoverer = new LocalVariableTableParameterNameDiscoverer();
    private static ExpressionParser parser = new SpelExpressionParser();

    public static String getConditionOrKey(String condition, Method objMethod, Object[] objects, String an) throws ExceptionRediscacheKeyInvalid, ExceptionRediscacheInvalid {
        String condition_ = "";
        if (condition.contains("#{")) {
            String[] k;
            for (String s : k = condition.split("#\\{")) {
                if (s.contains("}")) {
                    String k_ = s.split("}")[0];
                    condition_ = condition_ + CommontUtil.parseKey("#" + k_, objMethod, objects, an) + (s.split("}").length > 1 ? s.split("}")[1] : "");
                    continue;
                }
                condition_ = condition_ + s;
            }
        } else {
            condition_ = condition;
        }
        return condition_;
    }

    public static Object getRedisCacheInfo(JedisTemplate jedisTemplate, String key_, ProceedingJoinPoint joinPoint, int expire) throws Throwable {
        if (jedisTemplate.exists(key_.getBytes()).booleanValue()) {
            LogUtil.debug((String)"\n{\n\u3000\u3000\u3000\u3000\u3000This method gets the value from the redis cache\n}");
            return SerializingUtil.deserialize((byte[])jedisTemplate.get(key_.getBytes()));
        }
        Object object = joinPoint.proceed();
        if (expire >= 0) {
            jedisTemplate.setex(key_.getBytes(), expire, SerializingUtil.serialize((Object)object));
        } else {
            jedisTemplate.set(key_.getBytes(), SerializingUtil.serialize((Object)object));
        }
        LogUtil.debug((String)"\n{\n{\u3000\u3000\u3000\u3000\u3000The return data of this method has been stored in the redis cache}\n}");
        return object;
    }

    public static Object getRedisClusterCacheInfo(JedisClusterTemplate jedisClusterTemplate, String key_, ProceedingJoinPoint joinPoint, int expire) throws Throwable {
        if (jedisClusterTemplate.exists(key_.getBytes()).booleanValue()) {
            LogUtil.debug((String)"\n{\n\u3000\u3000\u3000\u3000\u3000This method gets the value from the redis cache\n}");
            return SerializingUtil.deserialize((byte[])jedisClusterTemplate.get(key_.getBytes()));
        }
        Object object = joinPoint.proceed();
        if (expire >= 0) {
            jedisClusterTemplate.setex(key_.getBytes(), expire, SerializingUtil.serialize((Object)object));
        } else {
            jedisClusterTemplate.set(key_.getBytes(), SerializingUtil.serialize((Object)object));
        }
        LogUtil.debug((String)"\n{\n{\u3000\u3000\u3000\u3000\u3000The return data of this method has been stored in the redis cache}\n}");
        return object;
    }

    public static String parseKey(String key, Method objMethod, Object[] objects, String an) throws ExceptionRediscacheKeyInvalid {
        Object value;
        String[] paraNameArr = parameterNameDiscoverer.getParameterNames(objMethod);
        StandardEvaluationContext context = new StandardEvaluationContext();
        if (null == paraNameArr) {
            Parameter[] parameters;
            String str = "";
            for (Object object : objects) {
                str = str + object + ",";
            }
            LogUtil.info((String)"{},{},{},{}", (Object[])new Object[]{objMethod.getDeclaringClass().getName(), objMethod.getName(), an, str});
            for (Parameter parameter : parameters = objMethod.getParameters()) {
                LogUtil.info((String)"==={}", (Object[])new Object[]{parameter.getName()});
            }
        } else {
            for (int i = 0; i < paraNameArr.length; ++i) {
                context.setVariable(paraNameArr[i], objects[i]);
            }
        }
        if (null == (value = parser.parseExpression(key).getValue((EvaluationContext)context, Object.class))) {
            throw new ExceptionRediscacheKeyInvalid((Object)(an + " key() #{" + key.split("#")[1] + "} not is null!"));
        }
        return value.toString();
    }

    public static String valiCondition(String condition, String an) throws ExceptionRediscacheInvalid {
        Expression expression = parser.parseExpression(condition);
        try {
            Object value = expression.getValue();
            if (null == value) {
                throw new ExceptionRediscacheKeyInvalid((Object)(an + " condition() #{" + condition.split("#")[1] + "} error!"));
            }
            return value.toString();
        }
        catch (Exception e) {
            throw new ExceptionRediscacheInvalid((Object)(an + " condition() '" + condition + "' is error!"));
        }
    }
}

