/*
 * Decompiled with CFR 0.152.
 */
package com.luues.jwt;

import com.alibaba.fastjson.JSON;
import com.auth0.jwt.JWT;
import com.auth0.jwt.JWTVerifier;
import com.auth0.jwt.algorithms.Algorithm;
import com.auth0.jwt.exceptions.TokenExpiredException;
import com.auth0.jwt.interfaces.DecodedJWT;
import com.luues.bean.core.BeanContextHolder;
import com.luues.exception.core.other.ExceptionJWTInvalid;
import com.luues.exception.core.other.ExceptionRedisInvalid;
import com.luues.exception.core.other.ExceptionTokenInvalid;
import com.luues.jwt.entity.AuthorizationInfo;
import com.luues.redis.cluster.service.JedisClusterTemplate;
import com.luues.redis.single.service.JedisTemplate;
import com.luues.util.TypeConvert;
import com.luues.util.date.DateTime;
import com.luues.util.encryption.MD5Util;
import java.text.ParseException;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.UUID;
import java.util.function.Consumer;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class JwtTemplate {
    private final String algorithmKey = "secret";
    private final String typ = "JWT";
    private final String alg = "AES";
    private final String issuer = "auth.Mr-Wu";
    private final String claimKey = "data";
    private final String token_key = "USERLOGIN-TOKEN-VERSION-1.0:";
    private final String source_phone = "PHONE";
    private final String source_pc = "PC";
    @Autowired
    private JedisTemplate jedisTemplate;
    @Autowired
    private JedisClusterTemplate jedisClusterTemplate;

    public String getToken_key() {
        return "USERLOGIN-TOKEN-VERSION-1.0:";
    }

    private JwtTemplate() {
    }

    public String getToken() {
        String signature;
        HttpServletRequest request = BeanContextHolder.getRequest();
        if (null == request) {
            return null;
        }
        String pa = request.getParameter("Authorization");
        String ha = request.getHeader("Authorization");
        Object object = TypeConvert.isNull((Object[])new Object[]{pa}) ? (TypeConvert.isNull((Object[])new Object[]{ha}) ? null : ha) : (signature = pa);
        if (TypeConvert.isNull((Object[])new Object[]{signature})) {
            Cookie[] cookies = request.getCookies();
            if (cookies == null) {
                signature = request.getHeader("_.USR");
                if (TypeConvert.isNull((Object[])new Object[]{signature})) {
                    return null;
                }
                return signature;
            }
            for (Cookie c : cookies) {
                if (!c.getName().equals("_.USR")) continue;
                signature = c.getValue();
                break;
            }
        }
        return signature;
    }

    public String createPCJWT(AuthorizationInfo authorizationInfo) throws ExceptionJWTInvalid, ExceptionRedisInvalid, ParseException {
        Algorithm algorithm = Algorithm.HMAC256((String)"secret");
        LinkedHashMap<String, String> header = new LinkedHashMap<String, String>();
        header.put("typ", "JWT");
        header.put("alg", "AES");
        header.put("source", "PC");
        Date now = DateTime.parse();
        String token = JWT.create().withIssuedAt(now).withExpiresAt(DateTime.parse((String)DateTime.getAfterOrPreNowTime((String)"second", (Long)Long.valueOf(authorizationInfo.getSetting().getPcTime())))).withIssuer("auth.Mr-Wu").withHeader(header).withJWTId(UUID.randomUUID().toString()).withClaim("data", JSON.toJSONString((Object)authorizationInfo)).sign(algorithm);
        if (authorizationInfo.getSetting().isRedisAuto()) {
            this.autoPCBind(token, authorizationInfo);
        }
        return token;
    }

    public String createPhoneJWT(AuthorizationInfo authorizationInfo) throws ExceptionJWTInvalid, ExceptionRedisInvalid, ParseException {
        Algorithm algorithm = Algorithm.HMAC256((String)"secret");
        LinkedHashMap<String, String> header = new LinkedHashMap<String, String>();
        header.put("typ", "JWT");
        header.put("alg", "AES");
        header.put("source", "PHONE");
        Date now = DateTime.parse();
        String token = JWT.create().withIssuedAt(now).withExpiresAt(DateTime.parse((String)DateTime.getAfterOrPreNowTime((String)"second", (Long)Long.valueOf(authorizationInfo.getSetting().getPhoneTime())))).withIssuer("auth.Mr-Wu").withHeader(header).withJWTId(UUID.randomUUID().toString()).withClaim("data", JSON.toJSONString((Object)authorizationInfo)).sign(algorithm);
        if (authorizationInfo.getSetting().isRedisAuto()) {
            this.autoPhoneBind(token, authorizationInfo);
        }
        return token;
    }

    private String autoPCBind(String token, AuthorizationInfo authorizationInfo) throws ExceptionJWTInvalid, ExceptionRedisInvalid {
        if (!this.jedisClusterTemplate.init() && !this.jedisTemplate.init()) {
            throw new ExceptionRedisInvalid((Object)"\u5f53\u524d\u8bbe\u7f6ejwt.auto=true,\u8868\u793a\u9700\u8981\u5b58\u5165redis,\u4f46redis\u672a\u914d\u7f6e,single-redis \u548c cluster-redis \u5fc5\u987b\u914d\u7f6e\u5176\u4e2d\u4e00\u4e2a\uff01");
        }
        if (TypeConvert.isNull((Object[])new Object[]{authorizationInfo.getSetting().getUTag(), authorizationInfo.getSetting().getDomain()})) {
            throw new ExceptionJWTInvalid((Object)"\u5f53\u524d\u8bbe\u7f6ejwt.auto=true,AuthorizationInfo\u5fc5\u987b.getSetting().setUTag\u53ca.getSetting().setDomain");
        }
        this.squeeze(authorizationInfo, MD5Util.MD5Encode((String)token, (String)"UTF-8") + "#" + "PC");
        Cookie cookie = new Cookie("_.USR", token);
        cookie.setDomain(authorizationInfo.getSetting().getDomain());
        cookie.setPath("/");
        cookie.setMaxAge(authorizationInfo.getSetting().getPcTime() + 86400);
        BeanContextHolder.getResponse().addCookie(cookie);
        return token;
    }

    private String autoPhoneBind(String token, AuthorizationInfo authorizationInfo) throws ExceptionJWTInvalid, ExceptionRedisInvalid {
        if (!this.jedisClusterTemplate.init() && !this.jedisTemplate.init()) {
            throw new ExceptionRedisInvalid((Object)"\u5f53\u524d\u8bbe\u7f6ejwt.auto=true,\u8868\u793a\u9700\u8981\u5b58\u5165redis,\u4f46redis\u672a\u914d\u7f6e,single-redis \u548c cluster-redis \u5fc5\u987b\u914d\u7f6e\u5176\u4e2d\u4e00\u4e2a\uff01");
        }
        if (TypeConvert.isNull((Object[])new Object[]{authorizationInfo.getSetting().getUTag()})) {
            throw new ExceptionJWTInvalid((Object)"\u5f53\u524d\u8bbe\u7f6ejwt.auto=true,AuthorizationInfo\u5fc5\u987b.getSetting().setUTag");
        }
        this.squeeze(authorizationInfo, MD5Util.MD5Encode((String)token, (String)"UTF-8") + "#" + "PHONE");
        return token;
    }

    private void squeeze(AuthorizationInfo authorizationInfo, String token) {
        String tag;
        String string = tag = authorizationInfo.isSystem() ? "system:" : "door:";
        if (authorizationInfo.getSetting().isSqueeze()) {
            if (authorizationInfo.getSetting().isPhoneAndPc()) {
                if (token.contains("PC")) {
                    if (!this.jedisClusterTemplate.init()) {
                        this.jedisTemplate.keys("USERLOGIN-TOKEN-VERSION-1.0:" + tag + authorizationInfo.getSetting().getUTag() + "#*").parallelStream().forEach(new Consumer<String>(){

                            @Override
                            public void accept(String key) {
                                if (key.contains("#PC")) {
                                    JwtTemplate.this.jedisTemplate.setex(key, 604800, "FAILl#\u60a8\u7684\u5e10\u53f7" + DateTime.format() + "\u5728\u5176\u4ed6\u5730\u65b9\u767b\u5f55\uff0c\u8be5\u5904\u88ab\u8feb\u4e0b\u7ebf\uff0c\u8bf7\u77e5\u6089\u3002\u5982\u975e\u672c\u4eba\u767b\u5f55\uff0c\u8bf7\u53ca\u65e9\u4fee\u6539\u5bc6\u7801\u3002");
                                }
                            }
                        });
                    } else {
                        this.jedisClusterTemplate.keys("USERLOGIN-TOKEN-VERSION-1.0:" + tag + authorizationInfo.getSetting().getUTag() + "#*").parallelStream().forEach(new Consumer<String>(){

                            @Override
                            public void accept(String key) {
                                if (key.contains("#PC")) {
                                    JwtTemplate.this.jedisClusterTemplate.setex(key, 604800, "FAILl#\u60a8\u7684\u5e10\u53f7" + DateTime.format() + "\u5728\u5176\u4ed6\u5730\u65b9\u767b\u5f55\uff0c\u8be5\u5904\u88ab\u8feb\u4e0b\u7ebf\uff0c\u8bf7\u77e5\u6089\u3002\u5982\u975e\u672c\u4eba\u767b\u5f55\uff0c\u8bf7\u53ca\u65e9\u4fee\u6539\u5bc6\u7801\u3002");
                                }
                            }
                        });
                    }
                } else if (!this.jedisClusterTemplate.init()) {
                    this.jedisTemplate.keys("USERLOGIN-TOKEN-VERSION-1.0:" + tag + authorizationInfo.getSetting().getUTag() + "#*").parallelStream().forEach(new Consumer<String>(){

                        @Override
                        public void accept(String key) {
                            if (key.contains("#PHONE")) {
                                JwtTemplate.this.jedisTemplate.setex(key, 604800, "FAILl#\u60a8\u7684\u5e10\u53f7" + DateTime.format() + "\u5728\u5176\u4ed6\u5730\u65b9\u767b\u5f55\uff0c\u8be5\u5904\u88ab\u8feb\u4e0b\u7ebf\uff0c\u8bf7\u77e5\u6089\u3002\u5982\u975e\u672c\u4eba\u767b\u5f55\uff0c\u8bf7\u53ca\u65e9\u4fee\u6539\u5bc6\u7801\u3002");
                            }
                        }
                    });
                } else {
                    this.jedisClusterTemplate.keys("USERLOGIN-TOKEN-VERSION-1.0:" + tag + authorizationInfo.getSetting().getUTag() + "#*").parallelStream().forEach(new Consumer<String>(){

                        @Override
                        public void accept(String key) {
                            if (key.contains("#PHONE")) {
                                JwtTemplate.this.jedisClusterTemplate.setex(key, 604800, "FAILl#\u60a8\u7684\u5e10\u53f7" + DateTime.format() + "\u5728\u5176\u4ed6\u5730\u65b9\u767b\u5f55\uff0c\u8be5\u5904\u88ab\u8feb\u4e0b\u7ebf\uff0c\u8bf7\u77e5\u6089\u3002\u5982\u975e\u672c\u4eba\u767b\u5f55\uff0c\u8bf7\u53ca\u65e9\u4fee\u6539\u5bc6\u7801\u3002");
                            }
                        }
                    });
                }
            } else if (!this.jedisClusterTemplate.init()) {
                this.jedisTemplate.keys("USERLOGIN-TOKEN-VERSION-1.0:" + tag + authorizationInfo.getSetting().getUTag() + "#*").parallelStream().forEach(new Consumer<String>(){

                    @Override
                    public void accept(String key) {
                        JwtTemplate.this.jedisTemplate.setex(key, 604800, "FAILl#\u60a8\u7684\u5e10\u53f7" + DateTime.format() + "\u5728\u5176\u4ed6\u5730\u65b9\u767b\u5f55\uff0c\u8be5\u5904\u88ab\u8feb\u4e0b\u7ebf\uff0c\u8bf7\u77e5\u6089\u3002\u5982\u975e\u672c\u4eba\u767b\u5f55\uff0c\u8bf7\u53ca\u65e9\u4fee\u6539\u5bc6\u7801\u3002");
                    }
                });
            } else {
                this.jedisClusterTemplate.keys("USERLOGIN-TOKEN-VERSION-1.0:" + tag + authorizationInfo.getSetting().getUTag() + "#*").parallelStream().forEach(new Consumer<String>(){

                    @Override
                    public void accept(String key) {
                        JwtTemplate.this.jedisClusterTemplate.setex(key, 604800, "FAILl#\u60a8\u7684\u5e10\u53f7" + DateTime.format() + "\u5728\u5176\u4ed6\u5730\u65b9\u767b\u5f55\uff0c\u8be5\u5904\u88ab\u8feb\u4e0b\u7ebf\uff0c\u8bf7\u77e5\u6089\u3002\u5982\u975e\u672c\u4eba\u767b\u5f55\uff0c\u8bf7\u53ca\u65e9\u4fee\u6539\u5bc6\u7801\u3002");
                    }
                });
            }
        }
        String result = JSON.toJSONString((Object)authorizationInfo);
        if (!this.jedisClusterTemplate.init()) {
            if (token.contains("PC")) {
                this.jedisTemplate.setex("USERLOGIN-TOKEN-VERSION-1.0:" + tag + authorizationInfo.getSetting().getUTag() + "#" + token, authorizationInfo.getSetting().getPcTime(), result);
            } else {
                this.jedisTemplate.setex("USERLOGIN-TOKEN-VERSION-1.0:" + tag + authorizationInfo.getSetting().getUTag() + "#" + token, authorizationInfo.getSetting().getPhoneTime(), result);
            }
        } else if (token.contains("PC")) {
            this.jedisClusterTemplate.setex("USERLOGIN-TOKEN-VERSION-1.0:" + tag + authorizationInfo.getSetting().getUTag() + "#" + token, authorizationInfo.getSetting().getPcTime(), result);
        } else {
            this.jedisClusterTemplate.setex("USERLOGIN-TOKEN-VERSION-1.0:" + tag + authorizationInfo.getSetting().getUTag() + "#" + token, authorizationInfo.getSetting().getPhoneTime(), result);
        }
    }

    public String getRedisKey(String token) {
        DecodedJWT jwt;
        AuthorizationInfo authorizationInfo;
        if (TypeConvert.isNull((Object[])new Object[]{token})) {
            token = this.getToken();
        }
        String tag = (authorizationInfo = (AuthorizationInfo)JSON.parseObject((String)(jwt = JWT.decode((String)token)).getClaim("data").asString(), AuthorizationInfo.class)).isSystem() ? "system:" : "door:";
        String source = jwt.getHeaderClaim("source").asString();
        String redis_key = "USERLOGIN-TOKEN-VERSION-1.0:" + tag + authorizationInfo.getSetting().getUTag() + "#" + MD5Util.MD5Encode((String)token, (String)"UTF-8") + "#" + source;
        return redis_key;
    }

    public String updateToken(String redisKey, AuthorizationInfo authorizationInfo) throws ExceptionJWTInvalid {
        try {
            String source = redisKey.substring(redisKey.lastIndexOf("#"));
            int timeOut = 0;
            timeOut = source == "PC" ? authorizationInfo.getSetting().getPcTime() : authorizationInfo.getSetting().getPhoneTime();
            if (!this.jedisClusterTemplate.init()) {
                if (this.jedisTemplate.exists(redisKey).booleanValue()) {
                    this.jedisTemplate.del(redisKey);
                    this.jedisTemplate.setex(redisKey, timeOut, JSON.toJSONString((Object)authorizationInfo));
                    return null;
                }
                throw new ExceptionTokenInvalid("\u767b\u9646\u8d85\u65f6\u6216\u672a\u767b\u5f55\uff0c\u8bf7\u91cd\u65b0\u767b\u5f55\uff01");
            }
            if (this.jedisClusterTemplate.exists(redisKey).booleanValue()) {
                this.jedisClusterTemplate.del(redisKey);
                this.jedisClusterTemplate.setex(redisKey, timeOut, JSON.toJSONString((Object)authorizationInfo));
                return null;
            }
            throw new ExceptionTokenInvalid("\u767b\u9646\u8d85\u65f6\u6216\u672a\u767b\u5f55\uff0c\u8bf7\u91cd\u65b0\u767b\u5f55\uff01");
        }
        catch (Exception e) {
            throw new ExceptionJWTInvalid((Object)"token verify faill, \u975e\u6cd5\u9a8c\u8bc1!");
        }
    }

    public AuthorizationInfo verifyJWT() throws ExceptionJWTInvalid, ExceptionTokenInvalid, ExceptionRedisInvalid, ParseException {
        return this.verifyJWT(this.getToken());
    }

    public AuthorizationInfo verifyJWT(String token) throws ExceptionJWTInvalid, ExceptionTokenInvalid, ExceptionRedisInvalid, ParseException {
        if (TypeConvert.isNull((Object[])new Object[]{token})) {
            return null;
        }
        Algorithm algorithm = Algorithm.HMAC256((String)"secret");
        try {
            String tag;
            JWTVerifier verifier = JWT.require((Algorithm)algorithm).withIssuer(new String[]{"auth.Mr-Wu"}).build();
            DecodedJWT jwt = verifier.verify(token);
            AuthorizationInfo authorizationInfo = (AuthorizationInfo)JSON.parseObject((String)jwt.getClaim("data").asString(), AuthorizationInfo.class);
            String string = tag = authorizationInfo.isSystem() ? "system:" : "door:";
            if (authorizationInfo.getSetting().isRedisAuto()) {
                String redis_key = "USERLOGIN-TOKEN-VERSION-1.0:" + tag + authorizationInfo.getSetting().getUTag() + "#" + MD5Util.MD5Encode((String)token, (String)"UTF-8") + "#" + jwt.getHeaderClaim("source").asString();
                if (!this.verifyRedis(redis_key)) {
                    return null;
                }
                if (!this.jedisClusterTemplate.init()) {
                    return (AuthorizationInfo)JSON.parseObject((String)this.jedisTemplate.get(redis_key), AuthorizationInfo.class);
                }
                return (AuthorizationInfo)JSON.parseObject((String)this.jedisClusterTemplate.get(redis_key), AuthorizationInfo.class);
            }
            return authorizationInfo;
        }
        catch (TokenExpiredException e) {
            return this.tokenTimeOutAutoCreate(token);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private AuthorizationInfo tokenTimeOutAutoCreate(String token) throws ExceptionJWTInvalid, ExceptionTokenInvalid, ExceptionRedisInvalid, ParseException {
        DecodedJWT jwt = JWT.decode((String)token);
        AuthorizationInfo authorizationInfo = (AuthorizationInfo)JSON.parseObject((String)jwt.getClaim("data").asString(), AuthorizationInfo.class);
        String tag = authorizationInfo.isSystem() ? "system:" : "door:";
        String source = jwt.getHeaderClaim("source").asString();
        String redis_key = "USERLOGIN-TOKEN-VERSION-1.0:" + tag + authorizationInfo.getSetting().getUTag() + "#" + MD5Util.MD5Encode((String)token, (String)"UTF-8") + "#" + source;
        this.verifyRedis(redis_key);
        if (source.equals("PC")) {
            if (!authorizationInfo.getSetting().isPcAutoToken()) throw new ExceptionTokenInvalid("\u767b\u9646\u8d85\u65f6\u6216\u672a\u767b\u5f55\uff0c\u8bf7\u91cd\u65b0\u767b\u5f55\uff01");
            this.createPCJWT(authorizationInfo);
            return authorizationInfo;
        } else {
            if (!source.equals("PHONE")) return authorizationInfo;
            if (!authorizationInfo.getSetting().isPhoneAutoToken()) throw new ExceptionTokenInvalid("\u767b\u9646\u8d85\u65f6\u6216\u672a\u767b\u5f55\uff0c\u8bf7\u91cd\u65b0\u767b\u5f55\uff01");
            this.createPhoneJWT(authorizationInfo);
        }
        return authorizationInfo;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean verifyRedis(String redis_key) throws ExceptionTokenInvalid {
        if (!this.jedisClusterTemplate.init()) {
            if (!this.jedisTemplate.exists(redis_key).booleanValue()) return false;
            String data = this.jedisTemplate.get(redis_key);
            if (!data.startsWith("FAILl#")) return true;
            this.jedisTemplate.del(redis_key);
            throw new ExceptionTokenInvalid(data.replace("FAILl#", ""));
        }
        if (!this.jedisClusterTemplate.exists(redis_key).booleanValue()) return false;
        String data = this.jedisClusterTemplate.get(redis_key);
        if (!data.startsWith("FAILl#")) return true;
        this.jedisClusterTemplate.del(redis_key);
        throw new ExceptionTokenInvalid(data.replace("FAILl#", ""));
    }

    public boolean clearRedisToken() throws ExceptionRedisInvalid, ParseException, ExceptionJWTInvalid, ExceptionTokenInvalid {
        String token = this.getToken();
        AuthorizationInfo authorizationInfo = this.verifyJWT(token);
        if (null == authorizationInfo) {
            return true;
        }
        DecodedJWT jwt = JWT.decode((String)token);
        String tag = this.getDoorOrSystem(authorizationInfo.isSystem());
        String source = jwt.getHeaderClaim("source").asString();
        String redis_key = "USERLOGIN-TOKEN-VERSION-1.0:" + tag + authorizationInfo.getSetting().getUTag() + "#" + MD5Util.MD5Encode((String)token, (String)"UTF-8") + "#" + source;
        if (!this.jedisClusterTemplate.init()) {
            if (this.jedisTemplate.exists(redis_key).booleanValue()) {
                this.jedisTemplate.del(redis_key);
            }
        } else if (this.jedisClusterTemplate.exists(redis_key).booleanValue()) {
            this.jedisClusterTemplate.del(redis_key);
        }
        return true;
    }

    protected String getDoorOrSystem(boolean flag) {
        return flag ? "system:" : "door:";
    }

    public static void main(String[] args) {
        String algorithmKey = "secret";
        String issuer = "auth.Mr-Wu";
        String claimKey = "data";
        String token = "eyJ0eXAiOiJKV1QiLCJzb3VyY2UiOiJQQyIsImFsZyI6IkhTMjU2In0.eyJkYXRhIjoie1wiYWRtaW5cIjpmYWxzZSxcInNldHRpbmdcIjp7XCJkb21haW5cIjpcIi5jcWpzZnouY25cIixcInBjQXV0b1Rva2VuXCI6dHJ1ZSxcInBjVGltZVwiOjg2NDAwLFwicGhvbmVBbmRQY1wiOnRydWUsXCJwaG9uZUF1dG9Ub2tlblwiOnRydWUsXCJwaG9uZVRpbWVcIjoyNTkyMDAwLFwicmVkaXNBdXRvXCI6dHJ1ZSxcInNxdWVlemVcIjpmYWxzZSxcInVUYWdcIjpcIjIxXCJ9LFwic3lzdGVtXCI6ZmFsc2UsXCJ1c2VyXCI6e1wiY29tcGFueVwiOlwiXCIsXCJjb21wYW55UGF0aFwiOlwiNTAwMTE3XCIsXCJpZFwiOjIxLFwibG9naW5Vc2VybmFtZVwiOlwiY3F4ZjUwMDExN1wiLFwibW9kaWZpZWRUaW1lXCI6XCIyMDE5LTA3LTExXCIsXCJtb2RpZmllcklkXCI6MjEsXCJuYW1lXCI6XCLlkIjlt53ljLrnrqHnkIblkZhcIixcInRlYWNoZXJJZFwiOlwiMjFcIixcInRlYWNoZXJSb2xlSWRcIjpcIjJcIixcInRlYWNoZXJfcGF0aFwiOlwiaHR0cDovL3RlYWNoZXIuY3Fqc2Z6LmNuXCIsXCJ1c2VybmFtZVwiOlwiY3F4ZjUwMDExN1wifX0iLCJpc3MiOiJhdXRoLk1yLVd1IiwiZXhwIjoxNTY0ODExNTIwLCJpYXQiOjE1NjQ3MjUxMzAsImp0aSI6IjQ1N2FkYTdkLWE4ZjAtNDg2Yy04M2YwLTBiOTQ3NjI3M2NjNSJ9.XhVjiyR2q1ljJe-sKSV2Qrj0M1UuyaMe11Sgs2VbZPc";
        Algorithm algorithm = Algorithm.HMAC256((String)algorithmKey);
        try {
            JWTVerifier verifier = JWT.require((Algorithm)algorithm).withIssuer(new String[]{issuer}).build();
            DecodedJWT jwt = verifier.verify(token);
            AuthorizationInfo authorizationInfo = (AuthorizationInfo)JSON.parseObject((String)jwt.getClaim(claimKey).asString(), AuthorizationInfo.class);
            System.err.println(authorizationInfo.getSetting().getUTag());
            System.err.println(MD5Util.MD5Encode((String)token, (String)"UTF-8"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

