/*
 * Decompiled with CFR 0.152.
 */
package com.luues.jwt.filter;

import com.alibaba.fastjson.JSONObject;
import com.luues.bean.core.BeanContextHolder;
import com.luues.exception.core.other.ExceptionTokenInvalid;
import com.luues.jwt.JwtTemplate;
import com.luues.jwt.entity.Authorization;
import com.luues.jwt.permission.Permission;
import com.luues.util.TypeConvert;
import com.luues.util.datawrap.ResultCode;
import com.luues.util.datawrap.ResultDataWrap;
import java.io.IOException;
import java.lang.reflect.Method;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.handler.HandlerInterceptorAdapter;

public class AuthInterceptor
extends HandlerInterceptorAdapter {
    public void afterCompletion(HttpServletRequest arg0, HttpServletResponse arg1, Object arg2, Exception arg3) throws Exception {
    }

    public void postHandle(HttpServletRequest arg0, HttpServletResponse arg1, Object arg2, ModelAndView arg3) throws Exception {
    }

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        if (handler instanceof HandlerMethod) {
            HandlerMethod hm = (HandlerMethod)handler;
            Class clazz = hm.getBeanType();
            Method m = hm.getMethod();
            if (clazz != null && m != null) {
                boolean isClzController = clazz.isAnnotationPresent(Controller.class);
                boolean isClaRestController = clazz.isAnnotationPresent(RestController.class);
                boolean isMethondController = m.isAnnotationPresent(ResponseBody.class);
                response.setHeader("Ask-Type", isMethondController ? "true" : (isMethondController ? "false" : (isClaRestController ? "true" : (isClzController ? "false" : "false"))));
                boolean isClzAnnotation = clazz.isAnnotationPresent(Permission.class);
                boolean isMethondAnnotation = m.isAnnotationPresent(Permission.class);
                Permission permission = null;
                if (isMethondAnnotation) {
                    permission = m.getAnnotation(Permission.class);
                } else if (isClzAnnotation) {
                    permission = clazz.getAnnotation(Permission.class);
                }
                if (null != permission) {
                    return this.roleVali(permission, request, response);
                }
            }
        }
        return true;
    }

    public boolean roleVali(Permission permission, HttpServletRequest request, HttpServletResponse response) throws ExceptionTokenInvalid, IOException, ServletException {
        JwtTemplate jwtTemplate = (JwtTemplate)BeanContextHolder.getApplicationContext().getBean(JwtTemplate.class);
        boolean login = permission.login();
        boolean orLogin = permission.orLogin();
        boolean system = permission.system();
        String[] roles = permission.roles();
        String[] permissions = permission.permissions();
        boolean permissionIsFunctionName = permission.permissionIsFunctionName();
        Authorization authorization = new Authorization();
        authorization.setLogin(login);
        authorization.setSystem(system);
        authorization.setOrLogin(orLogin);
        authorization.setRoles(roles);
        authorization.setPermissions(permissions);
        authorization.setPermissionIsFunctionName(permissionIsFunctionName);
        authorization.setToken(jwtTemplate.getToken());
        ResultDataWrap resultDataWrap = new ResultDataWrap();
        if (resultDataWrap.getResultCode() != ResultCode.c_200) {
            this.redirect(permission, request, response, false);
            return false;
        }
        JSONObject jsonObject = resultDataWrap.getJSONObject("userInfo");
        if (TypeConvert.isNull((Object[])new Object[]{jsonObject})) {
            this.redirect(permission, request, response, true);
            return true;
        }
        return true;
    }

    private void redirect(Permission permission, HttpServletRequest request, HttpServletResponse response, boolean falg) throws ExceptionTokenInvalid, IOException, ServletException {
        if (!TypeConvert.isNull((Object[])new Object[]{permission.redirect()})) {
            request.getRequestDispatcher(permission.redirect()).forward((ServletRequest)request, (ServletResponse)response);
            return;
        }
        if (!TypeConvert.isNull((Object[])new Object[]{permission.forward()})) {
            response.sendRedirect(permission.forward());
            return;
        }
        if (!falg) {
            throw new ExceptionTokenInvalid("\u767b\u5f55\u8d85\u65f6\u6216\u6ca1\u6709\u767b\u5f55");
        }
    }
}

