/*
 * Decompiled with CFR 0.152.
 */
package com.luues.jwt.filter;

import com.alibaba.fastjson.JSON;
import com.luues.bean.core.BeanContextHolder;
import com.luues.exception.core.other.ExceptionJWTInvalid;
import com.luues.exception.core.other.ExceptionRedisInvalid;
import com.luues.exception.core.other.ExceptionRediscacheInvalid;
import com.luues.exception.core.other.ExceptionRediscacheKeyInvalid;
import com.luues.exception.core.other.ExceptionTokenGroupInvalid;
import com.luues.exception.core.other.ExceptionTokenInvalid;
import com.luues.jwt.JwtTemplate;
import com.luues.jwt.entity.AuthorizationInfo;
import com.luues.jwt.permission.Permission;
import com.luues.util.TypeConvert;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URLEncoder;
import java.text.ParseException;
import java.util.Arrays;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.logging.log4j.util.Strings;
import org.springframework.core.LocalVariableTableParameterNameDiscoverer;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.StandardEvaluationContext;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.handler.HandlerInterceptorAdapter;

public class ValiInterceptor
extends HandlerInterceptorAdapter {
    public void afterCompletion(HttpServletRequest arg0, HttpServletResponse arg1, Object arg2, Exception arg3) throws Exception {
    }

    public void postHandle(HttpServletRequest arg0, HttpServletResponse arg1, Object arg2, ModelAndView arg3) throws Exception {
    }

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        if (handler instanceof HandlerMethod) {
            HandlerMethod hm = (HandlerMethod)handler;
            Class clazz = hm.getBeanType();
            Method m = hm.getMethod();
            if (clazz != null && m != null) {
                boolean isClzController = clazz.isAnnotationPresent(Controller.class);
                boolean isClaRestController = clazz.isAnnotationPresent(RestController.class);
                boolean isMethondController = m.isAnnotationPresent(ResponseBody.class);
                response.setHeader("Ask-Type", isMethondController ? "true" : (isMethondController ? "false" : (isClaRestController ? "true" : (isClzController ? "false" : "false"))));
                boolean isClzAnnotation = clazz.isAnnotationPresent(Permission.class);
                boolean isMethondAnnotation = m.isAnnotationPresent(Permission.class);
                Permission classPermission = null;
                Permission methondPermission = null;
                if (isMethondAnnotation) {
                    methondPermission = m.getAnnotation(Permission.class);
                }
                if (isClzAnnotation) {
                    classPermission = clazz.getAnnotation(Permission.class);
                }
                if (null != classPermission || null != methondPermission) {
                    ServletInputStream servletInputStream = request.getInputStream();
                    StringBuffer content = new StringBuffer();
                    byte[] b = new byte[1024];
                    int lens = -1;
                    while ((lens = servletInputStream.read(b)) > 0) {
                        content.append(new String(b, 0, lens));
                    }
                    if (TypeConvert.isNull((Object[])new Object[]{content})) {
                        return this.direct(null == classPermission ? methondPermission : classPermission, null == methondPermission ? classPermission : methondPermission, hm.getMethod().getName(), request, response);
                    }
                    return this.board(content, hm.getMethod().getName());
                }
                return true;
            }
        }
        return true;
    }

    public boolean direct(Permission classPermission, Permission methondPermission, String methodName, HttpServletRequest request, HttpServletResponse response) throws ExceptionTokenInvalid, ExceptionTokenGroupInvalid, ExceptionJWTInvalid, ExceptionRedisInvalid, ParseException {
        JwtTemplate jwtTemplate = (JwtTemplate)BeanContextHolder.getApplicationContext().getBean(JwtTemplate.class);
        AuthorizationInfo authorizationInfo = jwtTemplate.verifyJWT();
        if (methondPermission.orLogin()) {
            return true;
        }
        if (methondPermission.login()) {
            String forward;
            String redirect;
            String string = redirect = Strings.isBlank((String)methondPermission.redirect()) ? classPermission.redirect() : methondPermission.redirect();
            if (Strings.isNotBlank((String)redirect)) {
                try {
                    this.valiRole(authorizationInfo, classPermission, methondPermission, methodName);
                }
                catch (Exception e) {
                    try {
                        request.getRequestDispatcher(redirect.contains("?") ? redirect + "&msg=" + URLEncoder.encode(e.getMessage(), "UTF-8") : redirect + "?msg=" + URLEncoder.encode(e.getMessage(), "UTF-8")).forward((ServletRequest)request, (ServletResponse)response);
                    }
                    catch (ServletException servletException) {
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    return false;
                }
            }
            String string2 = forward = Strings.isBlank((String)methondPermission.forward()) ? classPermission.forward() : methondPermission.forward();
            if (!TypeConvert.isNull((Object[])new Object[]{forward})) {
                try {
                    this.valiRole(authorizationInfo, classPermission, methondPermission, methodName);
                }
                catch (Exception e) {
                    try {
                        response.sendRedirect(forward.contains("?") ? forward + "&msg=" + URLEncoder.encode(e.getMessage(), "UTF-8") : forward + "?msg=" + URLEncoder.encode(e.getMessage(), "UTF-8"));
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    return false;
                }
            }
            this.valiRole(authorizationInfo, classPermission, methondPermission, methodName);
        }
        return true;
    }

    public boolean board(StringBuffer content, String methodName) throws ExceptionTokenInvalid, ExceptionTokenGroupInvalid, ExceptionJWTInvalid, ExceptionRedisInvalid, ParseException {
        Permission permission = (Permission)JSON.parseObject((String)content.toString(), Permission.class);
        if (null == permission) {
            throw new ExceptionTokenInvalid("\u767b\u5f55\u8d85\u65f6\u6216\u6ca1\u6709\u767b\u5f55");
        }
        JwtTemplate jwtTemplate = (JwtTemplate)BeanContextHolder.getApplicationContext().getBean(JwtTemplate.class);
        AuthorizationInfo authorizationInfo = jwtTemplate.verifyJWT();
        if (permission.orLogin()) {
            return true;
        }
        if (permission.login()) {
            this.valiRole(authorizationInfo, permission, permission, methodName);
        }
        return true;
    }

    private void valiRole(AuthorizationInfo authorizationInfo, Permission classPermission, Permission methondPermission, String methodName) throws ExceptionTokenInvalid, ExceptionTokenGroupInvalid {
        String[] permissions = methondPermission.permissions().length == 0 ? classPermission.permissions() : methondPermission.permissions();
        String[] roles = methondPermission.roles().length == 0 ? classPermission.roles() : methondPermission.roles();
        boolean system = methondPermission.system();
        String[] custom = methondPermission.custom().length == 0 ? classPermission.custom() : methondPermission.custom();
        String[] hasRole = methondPermission.hasRole().length == 0 ? classPermission.hasRole() : methondPermission.hasRole();
        boolean permissionIsFunctionName = methondPermission.permissionIsFunctionName();
        if (null == authorizationInfo) {
            throw new ExceptionTokenInvalid("\u767b\u5f55\u8d85\u65f6\u6216\u6ca1\u6709\u767b\u5f55");
        }
        if (null == authorizationInfo.getUser()) {
            throw new ExceptionTokenInvalid("\u767b\u5f55\u8d85\u65f6\u6216\u6ca1\u6709\u767b\u5f55");
        }
        if (system && !authorizationInfo.isSystem()) {
            throw new ExceptionTokenGroupInvalid("\u6743\u9650\u4e0d\u8db3");
        }
        if (authorizationInfo.isAdmin()) {
            return;
        }
        String[] userPermissions = authorizationInfo.getPermissions();
        String[] userRoles = authorizationInfo.getRoles();
        int j = permissions.length + roles.length;
        int k = 0;
        Integer[] integers = this.do1(roles, userRoles, new Integer[]{j, k});
        if ((integers = this.do1(permissions, userPermissions, integers))[0] != integers[1]) {
            throw new ExceptionTokenGroupInvalid("\u6743\u9650\u4e0d\u8db3");
        }
        if (permissionIsFunctionName) {
            if (null == userPermissions) {
                throw new ExceptionTokenGroupInvalid("\u6743\u9650\u4e0d\u8db3");
            }
            for (String string : userPermissions) {
                if (!string.equals(methodName)) continue;
                return;
            }
            throw new ExceptionTokenGroupInvalid("\u6743\u9650\u4e0d\u8db3");
        }
        for (String role : hasRole) {
            if (Strings.isEmpty((CharSequence)role)) {
                return;
            }
            if (null == userRoles) {
                throw new ExceptionTokenGroupInvalid("\u6743\u9650\u4e0d\u8db3");
            }
            if (!Arrays.asList(userRoles).contains(role)) continue;
            return;
        }
        throw new ExceptionTokenGroupInvalid("\u6743\u9650\u4e0d\u8db3");
    }

    protected Integer[] do1(String[] ps, String[] users, Integer[] integers) throws ExceptionTokenGroupInvalid {
        List<String> ur = null;
        for (String role : ps) {
            Integer n;
            Integer n2;
            Integer[] integerArray;
            if (Strings.isEmpty((CharSequence)role)) {
                integerArray = integers;
                n2 = integerArray[0];
                n = integerArray[0] = Integer.valueOf(integerArray[0] - 1);
                return integers;
            }
            if (null == users) {
                throw new ExceptionTokenGroupInvalid("\u6743\u9650\u4e0d\u8db3");
            }
            if (null == ur) {
                ur = Arrays.asList(users);
            }
            if (!ur.contains(role)) continue;
            integerArray = integers;
            n2 = integerArray[1];
            n = integerArray[1] = Integer.valueOf(integerArray[1] + 1);
        }
        return integers;
    }

    private String parseKey(String key, Method objMethod, Object[] objects, String an) throws ExceptionRediscacheKeyInvalid {
        LocalVariableTableParameterNameDiscoverer u = new LocalVariableTableParameterNameDiscoverer();
        String[] paraNameArr = u.getParameterNames(objMethod);
        SpelExpressionParser parser = new SpelExpressionParser();
        StandardEvaluationContext context = new StandardEvaluationContext();
        for (int i = 0; i < paraNameArr.length; ++i) {
            context.setVariable(paraNameArr[i], objects[i]);
        }
        Object value = parser.parseExpression(key).getValue((EvaluationContext)context, Object.class);
        if (null == value) {
            throw new ExceptionRediscacheKeyInvalid((Object)(an + " key() #{" + key.split("#")[1] + "} not is null!"));
        }
        return value.toString();
    }

    private String valiCondition(String condition, String an) throws ExceptionRediscacheInvalid {
        SpelExpressionParser parser = new SpelExpressionParser();
        Expression expression = parser.parseExpression(condition);
        try {
            Object value = expression.getValue();
            if (null == value) {
                throw new ExceptionRediscacheKeyInvalid((Object)(an + " condition() #{" + condition.split("#")[1] + "} error!"));
            }
            return value.toString();
        }
        catch (Exception e) {
            throw new ExceptionRediscacheInvalid((Object)(an + " condition() '" + condition + "' is error!"));
        }
    }
}

