/*
 * Decompiled with CFR 0.152.
 */
package com.luues.weixin;

import com.luues.bean.core.BeanContextHolder;
import com.luues.exception.core.other.ExceptionRedisInvalid;
import com.luues.util.TypeConvert;
import com.luues.util.datawrap.ResultDataWrap;
import com.luues.util.logs.LogUtil;
import com.luues.weixin.configuration.WxInfo;
import com.luues.weixin.entity.WXAuthorizationUser;
import com.luues.weixin.entity.WXPayInfo;
import com.luues.weixin.message.WXPushContons;
import com.luues.weixin.message.WxClickPush;
import com.luues.weixin.message.interfaces.AccessToken;
import com.luues.weixin.message.interfaces.event.SCAN;
import com.luues.weixin.message.interfaces.event.SUBSCRIBE;
import com.luues.weixin.message.interfaces.event.TEMPLATESENDJOBFINISH;
import com.luues.weixin.message.interfaces.event.TEXT;
import com.luues.weixin.message.interfaces.event.UNSUBSCRIBE;
import com.luues.weixin.util.BindXML;
import com.luues.weixin.util.Pay;
import com.luues.weixin.util.WXAuthorization;
import com.luues.weixin.util.WXOrder;
import com.luues.weixin.util.WXOrderMustFillRequest;
import com.luues.weixin.util.WXOrderSelectiveFillRequest;
import com.luues.weixin.util.WXSign;
import com.luues.weixin.util.aes.AesException;
import com.luues.weixin.util.aes.WXBizMsgCrypt;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.annotation.PostConstruct;
import javax.servlet.ServletInputStream;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.logging.log4j.util.Strings;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class WxPay {
    @Autowired
    private WxInfo wxInfo;
    @Autowired
    private Pay pay;
    @Autowired
    private WXOrder wxOrder;
    @Autowired
    private WXSign wxSign;
    @Autowired
    private WXAuthorization wxAuthorization;
    private WXBizMsgCrypt wxBizMsgCrypt;

    @PostConstruct
    public void init() throws AesException {
        if (TypeConvert.isNull((Object[])new Object[]{this.wxInfo.getAppId(), this.wxInfo.getMchid(), this.wxInfo.getAppSecret(), this.wxInfo.getKey(), this.wxInfo.getDomain()})) {
            LogUtil.error((String)"{}", (Object[])new Object[]{"\n{\n                                     -- Failed to read the configuration file, because the file does not exist! -- \n                                           -- Please configure the file first,Configuration is as follows: -- \n   -- Explain(Please create a folder in the resources below for the payment file named pay.properties configuration file, that is, (weixinpay.properties)) -- \n                                                     -- spring.luues.wx.appid = Merchant appid (*) -- \n                                                     -- spring.luues.wx.mchid = Merchant mchid (*) -- \n                                                       -- spring.luues.wx.key = Merchant key (*) -- \n                                                    -- spring.luues.wx.domain = Merchant domain (*) -- \n                                                   -- spring.luues.wx.notity_url = Merchant notity_url -- \n                                            -- spring.luues.wx.certificate_key = Merchant Certificate password -- \n                                              -- spring.luues.wx.certificate_file = Merchant Certificate path -- \n}\n"});
        } else {
            this.wxBizMsgCrypt = new WXBizMsgCrypt(this.wxInfo.getToken(), this.wxInfo.getKey(), this.wxInfo.getAppId());
        }
    }

    public String getBasicsAccessToken() throws ExceptionRedisInvalid {
        return this.wxAuthorization.getBasicsAccessToken(this.wxInfo.getAppId(), this.wxInfo.getAppSecret());
    }

    public String getBasicsAccessToken(AccessToken accessToken) throws ExceptionRedisInvalid {
        if (null == accessToken) {
            return this.wxAuthorization.getBasicsAccessToken(this.wxInfo.getAppId(), this.wxInfo.getAppSecret());
        }
        return this.wxAuthorization.getBasicsAccessToken(this.wxInfo.getAppId(), this.wxInfo.getAppSecret(), accessToken);
    }

    public WXAuthorization getAccessToken(String code) {
        return this.wxAuthorization.getAccessToken(this.wxInfo.getAppId(), this.wxInfo.getAppSecret(), code);
    }

    public WXAuthorizationUser getUserInfo(String access_token, String openid) {
        return this.wxAuthorization.getUserInfo(access_token, openid);
    }

    public ResultDataWrap pay(Map<String, Object> paramsMap, String logoPath) {
        return this.pay.pay(paramsMap, logoPath);
    }

    public WXPayInfo createWxOrder(WXOrderMustFillRequest wxOrderMustFillRequest, WXOrderSelectiveFillRequest wxOrderSelectiveFillRequest) throws Exception {
        return this.wxOrder.createWxOrder(wxOrderMustFillRequest, wxOrderSelectiveFillRequest);
    }

    public ResultDataWrap pay(WXPayInfo wxPayInfo, String logoPath) {
        return this.pay.pay(wxPayInfo.toMap(), logoPath);
    }

    public ResultDataWrap queryWXOrderInfo(String transaction_id, String out_trade_no) {
        return this.wxOrder.queryWXOrderInfo(transaction_id, out_trade_no);
    }

    public ResultDataWrap closeOrder(String out_trade_no) {
        return this.wxOrder.closeOrder(out_trade_no);
    }

    public ResultDataWrap refund(String transaction_id, String out_trade_no, String out_refund_no, int total_fee, int refund_fee, String op_user_id) {
        return this.wxOrder.refund(transaction_id, out_trade_no, out_refund_no, total_fee, refund_fee, op_user_id);
    }

    public ResultDataWrap queryRefund(String transaction_id, String out_trade_no, String out_refund_no, String refund_id) {
        return this.wxOrder.queryRefund(transaction_id, out_trade_no, out_refund_no, refund_id);
    }

    public ResultDataWrap downloadBill(String bill_date, String bill_type, String tar_type) {
        return this.wxOrder.downloadBill(bill_date, bill_type, tar_type);
    }

    public ResultDataWrap transfers(Map<String, Object> paramsMap) {
        return this.pay.transfers(paramsMap);
    }

    public ResultDataWrap sendredpack(Map<String, Object> paramsMap) {
        return this.pay.sendredpack(paramsMap);
    }

    public Object returnSuccess() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(this.wxInfo.return_key, this.wxInfo.return_val);
        return BindXML.buildXML(map);
    }

    public Object returnFail() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(this.wxInfo.return_key, "FAIL");
        return BindXML.buildXML(map);
    }

    public Map<String, Object> valiPayLegitimate() {
        SortedMap<String, Object> map;
        String result = null;
        try {
            ServletInputStream inStream = BeanContextHolder.getRequest().getInputStream();
            ByteArrayOutputStream outSteam = new ByteArrayOutputStream();
            byte[] buffer = new byte[1024];
            int len = 0;
            while ((len = inStream.read(buffer)) != -1) {
                outSteam.write(buffer, 0, len);
            }
            outSteam.close();
            inStream.close();
            result = new String(outSteam.toByteArray(), "utf-8");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        LogUtil.debug((String)"\u652f\u4ed8\u6210\u529f,\u901a\u77e5\u8fd4\u56de\u6570\u636e:{}", (Object[])new Object[]{result});
        if (Strings.isBlank(result)) {
            map = new TreeMap<String, Object>();
            map.put(this.wxInfo.return_key, "FAIL");
            map.put(this.wxInfo.return_msg, "\u7b7e\u540d\u6709\u8bef");
            return map;
        }
        map = BindXML.analysisXML(result);
        String s = map.get("sign").toString();
        map.remove("sign");
        String sign = this.wxSign.createSign("UTF-8", map);
        if (!s.equals(sign)) {
            map = new TreeMap<String, Object>();
            map.put(this.wxInfo.return_key, "FAIL");
            map.put(this.wxInfo.return_msg, "\u7b7e\u540d\u6709\u8bef");
        } else {
            map.put(this.wxInfo.return_key, this.wxInfo.return_val);
        }
        return map;
    }

    public WXBizMsgCrypt getWxBizMsgCrypt() {
        return this.wxBizMsgCrypt;
    }

    public String message() {
        String timestamp = BeanContextHolder.getRequest().getParameter("timestamp");
        String nonce = BeanContextHolder.getRequest().getParameter("nonce");
        String signature = BeanContextHolder.getRequest().getParameter("signature");
        String echostr = BeanContextHolder.getRequest().getParameter("echostr");
        TreeSet<String> set = new TreeSet<String>();
        set.add(this.wxInfo.getToken());
        set.add(timestamp);
        set.add(nonce);
        StringBuilder sBuilder = new StringBuilder();
        for (String item : set) {
            sBuilder.append(item);
        }
        String sign = DigestUtils.sha1Hex((String)sBuilder.toString());
        if (signature.equalsIgnoreCase(sign)) {
            return echostr;
        }
        return "fail";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String onMessage(boolean decrypt, SCAN scan, SUBSCRIBE subscribe, UNSUBSCRIBE unsubscribe, TEMPLATESENDJOBFINISH templatesendjobfinish, TEXT text) throws IOException, AesException {
        WxClickPush wxClickPush;
        BeanContextHolder.getResponse().setCharacterEncoding("UTF-8");
        BeanContextHolder.getResponse().setCharacterEncoding("UTF-8");
        BeanContextHolder.getResponse().setContentType("text/html; charset=UTF-8");
        ServletInputStream ins = BeanContextHolder.getRequest().getInputStream();
        BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)ins, "UTF-8"));
        String buffer = null;
        StringBuffer sb = new StringBuffer();
        while ((buffer = br.readLine()) != null) {
            sb.append(buffer);
        }
        String strings = sb.toString();
        if (decrypt) {
            String msgSignature = BeanContextHolder.getRequest().getParameter("msg_signature");
            String timestamp = BeanContextHolder.getRequest().getParameter("timestamp");
            String nonce = BeanContextHolder.getRequest().getParameter("nonce");
            strings = this.wxBizMsgCrypt.decryptMsg(msgSignature, timestamp, nonce, strings);
            wxClickPush = (WxClickPush)BindXML.getObjectFromXML(strings, WxClickPush.class);
            wxClickPush.setTimestamp(timestamp);
            wxClickPush.setNonce(nonce);
            wxClickPush.setMsgSignature(msgSignature);
        } else {
            wxClickPush = (WxClickPush)BindXML.getObjectFromXML(strings, WxClickPush.class);
        }
        if (wxClickPush.getMsgType().equals(WXPushContons.MsgType.EVENT.getName())) {
            if (wxClickPush.getEvent().equals(WXPushContons.EventType.SCAN.name())) {
                if (null == scan) return "success";
                return scan.handle(wxClickPush);
            }
            if (wxClickPush.getEvent().equals(WXPushContons.EventType.SUBSCRIBE.getName())) {
                if (null == subscribe) return "success";
                return subscribe.handle(wxClickPush);
            }
            if (wxClickPush.getEvent().equals(WXPushContons.EventType.UNSUBSCRIBE.getName())) {
                if (null == unsubscribe) return "success";
                return unsubscribe.handle(wxClickPush);
            }
            if (!wxClickPush.getEvent().equals(WXPushContons.EventType.TEMPLATESENDJOBFINISH.name())) return "success";
            if (null == templatesendjobfinish) return "success";
            return templatesendjobfinish.handle(wxClickPush);
        }
        if (!wxClickPush.getMsgType().equals(WXPushContons.MsgType.TEXT.getName()) || null == text) return "success";
        return text.handle(wxClickPush);
    }
}

