/*
 * Decompiled with CFR 0.152.
 */
package com.luues.weixin.message;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.luues.exception.core.other.ExceptionRedisInvalid;
import com.luues.util.TypeConvert;
import com.luues.util.logs.LogUtil;
import com.luues.weixin.WxPay;
import com.luues.weixin.configuration.WxInfo;
import com.luues.weixin.entity.Msgmenu;
import com.luues.weixin.message.WXRequestAddress;
import com.luues.weixin.message.WxClickPush;
import com.luues.weixin.message.interfaces.MsgMenu;
import com.luues.weixin.message.interfaces.ReplyText;
import com.luues.weixin.message.interfaces.Template;
import com.luues.weixin.message.interfaces.Text;
import com.luues.weixin.util.BindXML;
import com.luues.weixin.util.WXRequest;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class TemplateMessage {
    @Autowired
    private WxInfo wxInfo;
    @Autowired
    private WxPay wxPay;
    @Autowired
    private WXRequestAddress wxRequestAddress;

    public String sendTemplateMessage(Template template) throws ExceptionRedisInvalid {
        String touser = template.getTouser();
        String template_id = template.getTemplateId();
        JSONObject data = template.getDate();
        if (TypeConvert.isNull((Object[])new Object[]{touser, template_id, data})) {
            return "touser\uff0ctemplate_id\uff0cdata \u4e0d\u80fd\u4e3a\u7a7a";
        }
        String url = template.getUrl();
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("touser", (Object)touser);
        jsonObject.put("template_id", (Object)template_id);
        jsonObject.put("url", (Object)url);
        jsonObject.put("data", (Object)data);
        return this.sendTemplateMessage(this.wxPay.getBasicsAccessToken(), jsonObject);
    }

    public String replyText(ReplyText replyText) {
        WxClickPush wxClickPush = replyText.getWxClickPush();
        String content = replyText.getContent();
        if (TypeConvert.isNull((Object[])new Object[]{wxClickPush, content})) {
            return "wxClickPush, content \u4e0d\u80fd\u4e3a\u7a7a";
        }
        HashMap<String, Object> player = new HashMap<String, Object>();
        player.put("ToUserName", wxClickPush.getFromUserName());
        player.put("FromUserName", wxClickPush.getToUserName());
        player.put("CreateTime", new Date().getTime() / 1000L);
        player.put("MsgType", "text");
        player.put("Content", content);
        return BindXML.buildXML(player);
    }

    public String sendText(Text text) throws ExceptionRedisInvalid {
        String openId = text.getOpenId();
        String content = text.getContent();
        if (TypeConvert.isNull((Object[])new Object[]{openId, content})) {
            return "openId, content \u4e0d\u80fd\u4e3a\u7a7a";
        }
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("touser", (Object)openId);
        jsonObject.put("msgtype", (Object)"text");
        JSONObject jsonObject1 = new JSONObject();
        jsonObject1.put("content", (Object)content);
        jsonObject.put("text", (Object)jsonObject1);
        String resultData = WXRequest.URLPost(this.wxRequestAddress.send_text + "?access_token=" + this.wxPay.getBasicsAccessToken(), jsonObject, false, null);
        return resultData;
    }

    public String sendMsgmenu(MsgMenu msgMenu) throws ExceptionRedisInvalid {
        String openId = msgMenu.getOpenId();
        String head_content = msgMenu.getHeadContent();
        String tail_content = msgMenu.getTailContent();
        List<Msgmenu> msgmenuList = msgMenu.getMsgmenuList();
        if (TypeConvert.isNull((Object[])new Object[]{openId, head_content, tail_content, msgmenuList})) {
            return "openId, head_content, tail_content, msgmenuList \u4e0d\u80fd\u4e3a\u7a7a";
        }
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("touser", (Object)openId);
        jsonObject.put("msgtype", (Object)"msgmenu");
        JSONObject jsonObject1 = new JSONObject();
        jsonObject1.put("head_content", (Object)head_content);
        jsonObject1.put("tail_content", (Object)tail_content);
        jsonObject1.put("list", (Object)JSONArray.parseArray((String)JSON.toJSONString(msgmenuList)));
        jsonObject.put("msgmenu", (Object)jsonObject1);
        String resultData = WXRequest.URLPost(this.wxRequestAddress.send_text + "?access_token=" + this.wxPay.getBasicsAccessToken(), jsonObject, false, null);
        return resultData;
    }

    protected String sendTemplateMessage(String access_token, JSONObject jsonObject) {
        String resultData = WXRequest.URLPost(this.wxRequestAddress.template_send + "?access_token=" + access_token, jsonObject, false, null);
        LogUtil.debug((String)"\u5fae\u4fe1\u53d1\u9001\u6a21\u7248\u6d88\u606f\u8fd4\u56de:{}", (Object[])new Object[]{resultData});
        return resultData;
    }
}

