/*
 * Decompiled with CFR 0.152.
 */
package com.luues.weixin.util;

import com.luues.util.logs.LogUtil;
import com.luues.weixin.configuration.WxInfo;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.SocketTimeoutException;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import javax.net.ssl.SSLContext;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.ConnectTimeoutException;
import org.apache.http.conn.ConnectionPoolTimeoutException;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLContexts;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CertificateHttpRequest {
    @Autowired
    private WxInfo wxInfo;
    private static int socketTimeout = 10000;
    private static int connectTimeout = 30000;
    private static RequestConfig requestConfig;
    private static CloseableHttpClient httpClient;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init() throws IOException, KeyStoreException, UnrecoverableKeyException, NoSuchAlgorithmException, KeyManagementException {
        KeyStore keyStore = KeyStore.getInstance("PKCS12");
        try (FileInputStream instream = new FileInputStream(new File(this.wxInfo.getCertificateFile()));){
            keyStore.load(instream, this.wxInfo.getCertificateKey().toCharArray());
        }
        SSLContext sslcontext = SSLContexts.custom().loadKeyMaterial(keyStore, this.wxInfo.getCertificateKey().toCharArray()).build();
        SSLConnectionSocketFactory sslsf = new SSLConnectionSocketFactory(sslcontext, new String[]{"TLSv1"}, null, SSLConnectionSocketFactory.BROWSER_COMPATIBLE_HOSTNAME_VERIFIER);
        httpClient = HttpClients.custom().setSSLSocketFactory((LayeredConnectionSocketFactory)sslsf).build();
        requestConfig = RequestConfig.custom().setSocketTimeout(socketTimeout).setConnectTimeout(connectTimeout).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String sendPost(String url, Object xmlObj) {
        try {
            this.init();
        }
        catch (UnrecoverableKeyException e) {
            e.printStackTrace();
        }
        catch (KeyManagementException e) {
            e.printStackTrace();
        }
        catch (KeyStoreException e) {
            e.printStackTrace();
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        String result = null;
        HttpPost httpPost = new HttpPost(url);
        LogUtil.debug((String)"\u5fae\u4fe1\u652f\u4ed8\u8bf7\u6c42\u5730\u5740:{}", (Object[])new Object[]{url});
        LogUtil.debug((String)"\u5fae\u4fe1\u652f\u4ed8\u8bf7\u6c42\u53c2\u6570:{}", (Object[])new Object[]{xmlObj});
        StringEntity postEntity = new StringEntity(xmlObj.toString(), "UTF-8");
        httpPost.addHeader("Content-Type", "text/xml");
        httpPost.setEntity((HttpEntity)postEntity);
        httpPost.setConfig(requestConfig);
        try {
            CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpPost);
            HttpEntity entity = response.getEntity();
            result = EntityUtils.toString((HttpEntity)entity, (String)"UTF-8");
            LogUtil.debug((String)"\u5fae\u4fe1\u652f\u4ed8\u8fd4\u56de\u7ed3\u679c:{}", (Object[])new Object[]{result});
        }
        catch (ConnectionPoolTimeoutException e) {
            LogUtil.info((String)"http get throw ConnectionPoolTimeoutException(wait time out)");
        }
        catch (ConnectTimeoutException e) {
            LogUtil.info((String)"http get throw ConnectTimeoutException");
        }
        catch (SocketTimeoutException e) {
            LogUtil.info((String)"http get throw SocketTimeoutException");
        }
        catch (Exception e) {
            LogUtil.info((String)"http get throw Exception");
        }
        finally {
            httpPost.abort();
        }
        return result;
    }
}

