/*
 * Decompiled with CFR 0.152.
 */
package com.luues.weixin.util;

import com.luues.util.TypeConvert;
import com.luues.util.datawrap.ResultCode;
import com.luues.util.datawrap.ResultDataWrap;
import com.luues.util.date.DateTime;
import com.luues.util.qrcode.QRCodeUtil;
import com.luues.util.uuid.JUUID;
import com.luues.weixin.configuration.WxInfo;
import com.luues.weixin.util.BindXML;
import com.luues.weixin.util.CertificateHttpRequest;
import com.luues.weixin.util.WXRequest;
import com.luues.weixin.util.WXSign;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URLEncoder;
import java.util.Date;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import javax.imageio.ImageIO;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import sun.misc.BASE64Encoder;

@Component(value="wx_pay")
public class Pay {
    @Autowired
    private WxInfo wxInfo;
    @Autowired
    private WXSign wxSign;
    @Autowired
    private CertificateHttpRequest certificateHttpRequest;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResultDataWrap pay(Map<String, Object> paramsMap, String logoPath) {
        String appid = this.wxInfo.getAppId();
        String mch_id = this.wxInfo.getMchid();
        SortedMap<String, Object> map = new TreeMap<String, Object>();
        String nonce_str = JUUID.getUUID();
        map.put("appid", appid);
        map.put("mch_id", mch_id);
        map.put("device_info", TypeConvert.speacToString((Object)paramsMap.get("device_info")));
        map.put("body", TypeConvert.speacToString((Object)paramsMap.get("body")));
        map.put("detail", TypeConvert.speacToString((Object)paramsMap.get("detail")));
        map.put("nonce_str", nonce_str);
        map.put("out_trade_no", TypeConvert.speacToString((Object)paramsMap.get("out_trade_no")));
        map.put("total_fee", TypeConvert.speacToString((Object)paramsMap.get("total_fee")));
        map.put("spbill_create_ip", TypeConvert.speacToString((Object)paramsMap.get("spbill_create_ip")));
        map.put("notify_url", TypeConvert.speacToString((Object)paramsMap.get("notify_url")));
        map.put("trade_type", TypeConvert.speacToString((Object)paramsMap.get("trade_type")));
        map.put("product_id", TypeConvert.speacToString((Object)paramsMap.get("product_id")));
        map.put("time_start", TypeConvert.speacToString((Object)paramsMap.get("time_start")));
        map.put("time_expire", TypeConvert.speacToString((Object)paramsMap.get("time_expire")));
        map.put("openid", TypeConvert.speacToString((Object)paramsMap.get("openid")));
        map.put("attach", TypeConvert.speacToString((Object)paramsMap.get("attach")));
        String sign = this.wxSign.createSign("UTF-8", map);
        map.put("sign", sign);
        TreeMap<String, Object> copyMap = new TreeMap<String, Object>();
        copyMap.putAll(map);
        String request_params = BindXML.buildXML(map);
        new WXRequest();
        String resultDate = WXRequest.URLPost(this.wxInfo.unifiedorder, request_params, false, null);
        map = BindXML.analysisXML(resultDate);
        if (map.get(this.wxInfo.return_key).equals(this.wxInfo.return_val) && map.get(this.wxInfo.result_code).equals(this.wxInfo.return_val)) {
            String trade_type = map.get(this.wxInfo.trade_type).toString();
            if (trade_type.equals(this.wxInfo.pay_native)) {
                String code_url = map.get("code_url").toString();
                BufferedImage bufferedImage = null;
                bufferedImage = !TypeConvert.isNull((Object[])new Object[]{logoPath}) ? QRCodeUtil.encodeImgLogo((String)code_url, (String)logoPath) : QRCodeUtil.encodeImg((String)code_url);
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                InputStream inputStream = null;
                try {
                    ImageIO.write((RenderedImage)bufferedImage, "PNG", byteArrayOutputStream);
                    inputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
                    byte[] data = new byte[inputStream.available()];
                    inputStream.read(data);
                    BASE64Encoder encoder = new BASE64Encoder();
                    ResultDataWrap resultDataWrap = new ResultDataWrap(ResultCode.c_200, "data:image/jpg;base64," + encoder.encode(data));
                    return resultDataWrap;
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                finally {
                    try {
                        byteArrayOutputStream.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    try {
                        inputStream.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                return new ResultDataWrap(ResultCode.c_100, "FAIL");
            }
            if (trade_type.equals(this.wxInfo.pay_app)) {
                TreeMap<String, Object> returnMap = new TreeMap<String, Object>();
                returnMap.put("appid", map.get("appid"));
                returnMap.put("partnerid", map.get("mch_id"));
                returnMap.put("prepayid", map.get("prepay_id"));
                returnMap.put("timestamp", String.valueOf(new Date().getTime() / 1000L));
                returnMap.put("noncestr", map.get("nonce_str"));
                returnMap.put("package", "Sign=WXPay");
                String signs = this.wxSign.createSign("utf-8", returnMap);
                returnMap.put("paySign", signs);
                ResultDataWrap resultDataWrap = new ResultDataWrap();
                resultDataWrap.put("data", returnMap);
                return resultDataWrap;
            }
            if (trade_type.equals(this.wxInfo.pay_jsapi)) {
                TreeMap<String, Object> returnMap = new TreeMap<String, Object>();
                returnMap.put("appId", copyMap.get("appid"));
                returnMap.put("timeStamp", String.valueOf(new Date().getTime() / 1000L));
                returnMap.put("nonceStr", copyMap.get("nonce_str"));
                returnMap.put("package", "prepay_id=" + map.get("prepay_id").toString() + "");
                returnMap.put("signType", "MD5");
                String signs = this.wxSign.createSign("utf-8", returnMap);
                returnMap.put("paySign", signs);
                ResultDataWrap resultDataWrap = new ResultDataWrap();
                resultDataWrap.put("data", returnMap);
                return resultDataWrap;
            }
            if (trade_type.equals(this.wxInfo.pay_web)) {
                return new ResultDataWrap(ResultCode.c_200, map.get("mweb_url").toString() + "&redirect_url=" + URLEncoder.encode(this.wxInfo.getReturnUrl()));
            }
            return new ResultDataWrap(ResultCode.c_505, "\u9519\u8bef,\u672a\u8bc6\u522b\u7684\u652f\u4ed8\u65b9\u5f0f");
        }
        return new ResultDataWrap(ResultCode.c_505, map.get(this.wxInfo.return_msg).toString().equals("OK") ? this.wxInfo.getErrorMsg(map.get(this.wxInfo.err_code).toString()) : map.get(this.wxInfo.return_msg).toString());
    }

    public ResultDataWrap transfers(Map<String, Object> paramsMap) {
        String appid = this.wxInfo.getAppId();
        String mch_id = this.wxInfo.getMchid();
        SortedMap<String, Object> map = new TreeMap<String, Object>();
        String nonce_str = JUUID.getUUID();
        map.put("mch_appid", appid);
        map.put("mchid", mch_id);
        map.put("device_info", TypeConvert.speacToString((Object)paramsMap.get("device_info")));
        map.put("nonce_str", nonce_str);
        map.put("partner_trade_no", TypeConvert.speacToString((Object)paramsMap.get("partner_trade_no")));
        map.put("openid", TypeConvert.speacToString((Object)paramsMap.get("openid")));
        String check_name = TypeConvert.speacToString((Object)paramsMap.get("check_name"));
        if (TypeConvert.isNull((Object[])new Object[]{check_name}) || check_name.equals("NO_CHECK")) {
            map.put("check_name", "NO_CHECK");
        } else {
            map.put("check_name", TypeConvert.speacToString((Object)paramsMap.get("check_name")));
            map.put("re_user_name", TypeConvert.speacToString((Object)paramsMap.get("re_user_name")));
        }
        map.put("amount", TypeConvert.speacToString((Object)paramsMap.get("amount")));
        map.put("desc", TypeConvert.speacToString((Object)paramsMap.get("desc")));
        map.put("spbill_create_ip", TypeConvert.speacToString((Object)paramsMap.get("spbill_create_ip")));
        String sign = this.wxSign.createSign("UTF-8", map);
        map.put("sign", sign);
        String request_params = BindXML.buildXML(map);
        String resultDate = this.certificateHttpRequest.sendPost(this.wxInfo.transfers, request_params);
        map = BindXML.analysisXML(resultDate);
        if (map.get(this.wxInfo.return_key).equals(this.wxInfo.return_val) && map.get(this.wxInfo.result_code).equals(this.wxInfo.return_val)) {
            return new ResultDataWrap();
        }
        return new ResultDataWrap(ResultCode.c_505, map.get(this.wxInfo.return_msg).toString().equals("OK") ? this.wxInfo.getErrorMsg(map.get(this.wxInfo.err_code).toString()) : map.get(this.wxInfo.return_msg).toString());
    }

    public ResultDataWrap sendredpack(Map<String, Object> paramsMap) {
        String appid = this.wxInfo.getAppId();
        String mch_id = this.wxInfo.getMchid();
        SortedMap<String, Object> map = new TreeMap<String, Object>();
        String nonce_str = JUUID.getUUID();
        map.put("wxappid", appid);
        map.put("mch_id", mch_id);
        map.put("mch_billno", mch_id + DateTime.format((String)"yyyyMMdd") + String.valueOf(DateTime.getTime()).substring(0, 10));
        map.put("nonce_str", nonce_str);
        map.put("send_name", TypeConvert.speacToString((Object)paramsMap.get("send_name")));
        map.put("re_openid", TypeConvert.speacToString((Object)paramsMap.get("re_openid")));
        map.put("total_amount", TypeConvert.speacToString((Object)paramsMap.get("total_amount")));
        map.put("total_num", 1);
        map.put("wishing", TypeConvert.speacToString((Object)paramsMap.get("wishing")));
        map.put("client_ip", TypeConvert.speacToString((Object)paramsMap.get("client_ip")));
        map.put("act_name", TypeConvert.speacToString((Object)paramsMap.get("act_name")));
        map.put("remark", TypeConvert.speacToString((Object)paramsMap.get("remark")));
        if (!TypeConvert.isNull((Object[])new Object[]{TypeConvert.speacToString((Object)paramsMap.get("total_amount"))}) && Integer.parseInt(paramsMap.get("total_amount").toString()) > 20000) {
            map.put("scene_id", TypeConvert.speacToString((Object)paramsMap.get("scene_id")));
        }
        String sign = this.wxSign.createSign("UTF-8", map);
        map.put("sign", sign);
        String request_params = BindXML.buildXML(map);
        String resultDate = this.certificateHttpRequest.sendPost(this.wxInfo.sendredpack, request_params);
        map = BindXML.analysisXML(resultDate);
        if (map.get(this.wxInfo.return_key).equals(this.wxInfo.return_val) && map.get(this.wxInfo.result_code).equals(this.wxInfo.return_val)) {
            return new ResultDataWrap();
        }
        return new ResultDataWrap(ResultCode.c_505, map.get(this.wxInfo.return_msg).toString().equals("OK") ? this.wxInfo.getErrorMsg(map.get(this.wxInfo.err_code).toString()) : map.get(this.wxInfo.return_msg).toString());
    }
}

