/*
 * Decompiled with CFR 0.152.
 */
package com.luues.weixin.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.luues.bean.core.BeanContextHolder;
import com.luues.exception.core.other.ExceptionRedisInvalid;
import com.luues.redis.cluster.service.JedisClusterTemplate;
import com.luues.redis.single.service.JedisTemplate;
import com.luues.util.TypeConvert;
import com.luues.util.logs.LogUtil;
import com.luues.weixin.entity.WXAuthorizationUser;
import com.luues.weixin.message.WXRequestAddress;
import com.luues.weixin.message.interfaces.AccessToken;
import com.luues.weixin.util.WXRequest;
import org.apache.logging.log4j.util.Strings;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class WXAuthorization {
    @Autowired
    private WXRequestAddress wxRequestAddress;
    @Value(value="${weixinpay.redis_basics_access_token_key:WX-VERSION-1.0:basics_access_token:}")
    private String redis_basics_access_token_key;
    @Value(value="${weixinpay.redis_access_token_key:WX-VERSION-1.0:access_token:}")
    private String redis_access_token_key;
    @Value(value="${weixinpay.redis_basics_access_token_key_:''}")
    private String redis_basics_access_token_key_;
    private static volatile WXAuthorization WXauthorization;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static WXAuthorization getInstance() {
        if (null != WXauthorization) return WXauthorization;
        Class<WXAuthorization> clazz = WXAuthorization.class;
        synchronized (WXAuthorization.class) {
            WXauthorization = new WXAuthorization();
            // ** MonitorExit[var0] (shouldn't be in output)
            return WXauthorization;
        }
    }

    public WXAuthorization getAccessToken(String appid, String appSecret, String code) {
        String resultData = WXRequest.URLPost(this.wxRequestAddress.access_token, "appid=" + appid + "&secret=" + appSecret + "&code=" + code + "&grant_type=authorization_code", false, null);
        LogUtil.debug((String)"\u5fae\u4fe1\u83b7\u53d6\u7f51\u9875\u6388\u6743access_token\u8fd4\u56de:{}", (Object[])new Object[]{resultData});
        WXAuthorization wxAuthorization = (WXAuthorization)JSON.parseObject((String)resultData, WXAuthorization.class);
        return wxAuthorization;
    }

    public WXAuthorizationUser getUserInfo(String access_token, String openid) {
        String resultData = WXRequest.URLPost(this.wxRequestAddress.user_info, "access_token=" + access_token + "&openid=" + openid + "&lang=zh_CN", false, null);
        LogUtil.debug((String)"\u5fae\u4fe1\u83b7\u53d6\u7f51\u9875\u6388\u6743access_token\u8fd4\u56de:{}", (Object[])new Object[]{resultData});
        return (WXAuthorizationUser)JSON.parseObject((String)resultData, WXAuthorizationUser.class);
    }

    public String getBasicsAccessToken(String appid, String appSecret) throws ExceptionRedisInvalid {
        JedisTemplate jedisTemplate = (JedisTemplate)BeanContextHolder.getApplicationContext().getBean(JedisTemplate.class);
        JedisClusterTemplate jedisClusterTemplate = (JedisClusterTemplate)BeanContextHolder.getApplicationContext().getBean(JedisClusterTemplate.class);
        if (!jedisTemplate.init() && !jedisClusterTemplate.init()) {
            throw new ExceptionRedisInvalid((Object)"\u9700\u8981\u4f7f\u7528redis,\u4f46redis\u672a\u914d\u7f6e,single-redis \u548c cluster-redis \u5fc5\u987b\u914d\u7f6e\u5176\u4e2d\u4e00\u4e2a\uff01");
        }
        if (!jedisClusterTemplate.init()) {
            if (jedisTemplate.exists(this.redis_basics_access_token_key + this.redis_basics_access_token_key_).booleanValue()) {
                LogUtil.debug((String)"access_token\u5b58\u5728");
                return jedisTemplate.get(this.redis_basics_access_token_key + this.redis_basics_access_token_key_);
            }
            String resultData = WXRequest.URLPost(this.wxRequestAddress.token, "grant_type=client_credential&appid=" + appid + "&secret=" + appSecret, false, null);
            LogUtil.debug((String)"\u5fae\u4fe1\u83b7\u53d6\u57fa\u7840access_token\u8fd4\u56de:{}", (Object[])new Object[]{resultData});
            JSONObject resultObj = JSON.parseObject((String)resultData);
            String access_token = resultObj.getString("access_token");
            if (TypeConvert.isNull((Object[])new Object[]{access_token})) {
                return null;
            }
            jedisTemplate.setex(this.redis_basics_access_token_key + this.redis_basics_access_token_key_, 7140, access_token);
            return access_token;
        }
        if (jedisClusterTemplate.exists(this.redis_basics_access_token_key + this.redis_basics_access_token_key_).booleanValue()) {
            LogUtil.debug((String)"access_token\u5b58\u5728");
            return jedisClusterTemplate.get(this.redis_basics_access_token_key + this.redis_basics_access_token_key_);
        }
        String resultData = WXRequest.URLPost(this.wxRequestAddress.token, "grant_type=client_credential&appid=" + appid + "&secret=" + appSecret, false, null);
        LogUtil.debug((String)"\u5fae\u4fe1\u83b7\u53d6\u57fa\u7840access_token\u8fd4\u56de:{}", (Object[])new Object[]{resultData});
        JSONObject resultObj = JSON.parseObject((String)resultData);
        String access_token = resultObj.getString("access_token");
        if (TypeConvert.isNull((Object[])new Object[]{access_token})) {
            return null;
        }
        jedisClusterTemplate.setex(this.redis_basics_access_token_key + this.redis_basics_access_token_key_, 7140, access_token);
        return access_token;
    }

    public String getBasicsAccessToken(String appid, String appSecret, AccessToken accessToken) {
        if (Strings.isBlank((String)accessToken.getAccessToken())) {
            String resultData = WXRequest.URLPost(this.wxRequestAddress.token, "grant_type=client_credential&appid=" + appid + "&secret=" + appSecret, false, null);
            LogUtil.debug((String)"\u5fae\u4fe1\u83b7\u53d6\u57fa\u7840access_token\u8fd4\u56de:{}", (Object[])new Object[]{resultData});
            JSONObject resultObj = JSON.parseObject((String)resultData);
            String access_token = resultObj.getString("access_token");
            if (TypeConvert.isNull((Object[])new Object[]{access_token})) {
                return null;
            }
            return access_token;
        }
        return accessToken.getAccessToken();
    }
}

