/*
 * Decompiled with CFR 0.152.
 */
package com.luues.weixin.util;

import com.luues.bean.core.BeanContextHolder;
import com.luues.util.TypeConvert;
import com.luues.util.datawrap.ResultCode;
import com.luues.util.datawrap.ResultDataWrap;
import com.luues.util.ip.IpUtil;
import com.luues.util.uuid.JUUID;
import com.luues.util.uuid.UniqueOrderGenerate;
import com.luues.weixin.configuration.WxInfo;
import com.luues.weixin.entity.BankType;
import com.luues.weixin.entity.WXPayInfo;
import com.luues.weixin.util.BindXML;
import com.luues.weixin.util.CertificateHttpRequest;
import com.luues.weixin.util.WXOrderMustFillRequest;
import com.luues.weixin.util.WXOrderSelectiveFillRequest;
import com.luues.weixin.util.WXRequest;
import com.luues.weixin.util.WXSign;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.SortedMap;
import java.util.TreeMap;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class WXOrder {
    private UniqueOrderGenerate uniqueOrderGenerate = new UniqueOrderGenerate(0L, 0L);
    @Autowired
    private WxInfo wxInfo;
    @Autowired
    private WXSign wxSign;
    @Autowired
    private CertificateHttpRequest certificateHttpRequest;

    public WXPayInfo createWxOrder(WXOrderMustFillRequest wxOrderMustFillRequest, WXOrderSelectiveFillRequest wxOrderSelectiveFillRequest) throws Exception {
        String body = wxOrderMustFillRequest.setBody();
        String outTradeNo = wxOrderMustFillRequest.setOutTradeNo();
        int totalFee = wxOrderMustFillRequest.setTotalFee();
        String spbillCreateIp = wxOrderMustFillRequest.setSpbillCreateIp();
        String notifyUrl = wxOrderMustFillRequest.setNotifyUrl();
        String tradeType = wxOrderMustFillRequest.setTradeType();
        if (TypeConvert.isNull((Object[])new Object[]{tradeType})) {
            tradeType = this.wxInfo.pay_app;
        }
        String productId = wxOrderSelectiveFillRequest.setProductId();
        if (tradeType.equals(this.wxInfo.pay_native) && TypeConvert.isNull((Object[])new Object[]{productId})) {
            throw new Exception("product_id \u5fc5\u987b\u8bbe\u7f6e");
        }
        String openId = wxOrderSelectiveFillRequest.setOpenId();
        if (tradeType.equals(this.wxInfo.pay_jsapi) && TypeConvert.isNull((Object[])new Object[]{openId})) {
            throw new Exception("openId \u5fc5\u987b\u8bbe\u7f6e");
        }
        if (TypeConvert.isNull((Object[])new Object[]{body})) {
            throw new Exception("body \u5fc5\u987b\u8bbe\u7f6e");
        }
        if (TypeConvert.isNull((Object[])new Object[]{outTradeNo})) {
            outTradeNo = LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyyMMdd")) + this.uniqueOrderGenerate.nextId();
        }
        if (TypeConvert.isNull((Object[])new Object[]{totalFee})) {
            throw new Exception("totalFee \u5fc5\u987b\u8bbe\u7f6e");
        }
        if (TypeConvert.isNull((Object[])new Object[]{spbillCreateIp}) && TypeConvert.isNull((Object[])new Object[]{spbillCreateIp = IpUtil.getIpAddress((HttpServletRequest)BeanContextHolder.getRequest())})) {
            throw new Exception("spbillCreateIp \u5fc5\u987b\u8bbe\u7f6e");
        }
        if (TypeConvert.isNull((Object[])new Object[]{notifyUrl})) {
            if (TypeConvert.isNull((Object[])new Object[]{this.wxInfo.getNotityUrl()})) {
                throw new Exception("notifyUrl \u5fc5\u987b\u8bbe\u7f6e");
            }
            notifyUrl = this.wxInfo.getNotityUrl();
        }
        WXPayInfo wxPayInfo = new WXPayInfo(TypeConvert.speacToString((Object)wxOrderSelectiveFillRequest.setDeviceInfo()), body, TypeConvert.speacToString((Object)wxOrderSelectiveFillRequest.setDetail()), TypeConvert.speacToString((Object)wxOrderSelectiveFillRequest.setAttach()), outTradeNo, totalFee, spbillCreateIp, notifyUrl, tradeType, TypeConvert.isNull((Object[])new Object[]{wxOrderSelectiveFillRequest.setTimeStart()}) ? LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyyMMddHHmmss")) : wxOrderSelectiveFillRequest.setTimeStart(), TypeConvert.isNull((Object[])new Object[]{wxOrderSelectiveFillRequest.setTimeExpire()}) ? LocalDateTime.now().plusHours(Long.valueOf("24")).format(DateTimeFormatter.ofPattern("yyyyMMddHHmmss")) : wxOrderSelectiveFillRequest.setTimeExpire(), TypeConvert.speacToString((Object)wxOrderSelectiveFillRequest.setGoodsTag()), productId, openId);
        return wxPayInfo;
    }

    public ResultDataWrap queryWXOrderInfo(String transaction_id, String out_trade_no) {
        SortedMap<String, Object> map = new TreeMap<String, Object>();
        map.put("appid", this.wxInfo.getAppId());
        map.put("mch_id", this.wxInfo.getMchid());
        map.put("transaction_id", TypeConvert.speacToString((Object)transaction_id));
        map.put("out_trade_no", TypeConvert.speacToString((Object)out_trade_no));
        map.put("nonce_str", JUUID.getUUID());
        String sign = this.wxSign.createSign("UTF-8", map);
        map.put("sign", sign);
        String xml = BindXML.buildXML(map);
        new WXRequest();
        String resultDate = WXRequest.URLPost(this.wxInfo.orderquery, xml, false, null);
        map = BindXML.analysisXML(resultDate);
        this.valiSign(map);
        if (map.get(this.wxInfo.return_key).equals(this.wxInfo.return_val) && map.get(this.wxInfo.result_code).equals(this.wxInfo.return_val)) {
            String trade_state = this.wxInfo.getPayTradeState(map.get(this.wxInfo.trade_state).toString());
            String bank_type = TypeConvert.isNull((Object[])new Object[]{map.get(this.wxInfo.bank_type)}) ? "" : BankType.getBankType(map.get(this.wxInfo.bank_type).toString());
            Double total_fee = TypeConvert.isNull((Object[])new Object[]{map.get("total_fee")}) ? 0.0 : (double)(Integer.valueOf(map.get("total_fee").toString()) / 100);
            Double cash_fee = TypeConvert.isNull((Object[])new Object[]{map.get("cash_fee")}) ? 0.0 : (double)(Integer.valueOf(map.get("cash_fee").toString()) / 100);
            String time_end = TypeConvert.isNull((Object[])new Object[]{map.get("time_end")}) ? "" : map.get("time_end").toString();
            time_end = time_end.equals("") ? "" : time_end.substring(0, 4) + "-" + time_end.substring(4, 6) + "-" + time_end.substring(6, 8) + " " + time_end.substring(8, 10) + ":" + time_end.substring(10, 12) + ":" + time_end.substring(12, 14);
            map.put("trade_state_ch", trade_state);
            map.put("bank_type_ch", bank_type);
            map.put("total_fee_ch", total_fee);
            map.put("cash_fee_ch", cash_fee);
            map.put("time_end_ch", time_end);
            ResultDataWrap resultDataWrap = new ResultDataWrap();
            resultDataWrap.putData(map);
            return resultDataWrap;
        }
        return new ResultDataWrap(ResultCode.c_505, this.returnMsg(map));
    }

    public ResultDataWrap closeOrder(String out_trade_no) {
        SortedMap<String, Object> map = new TreeMap<String, Object>();
        map.put("appid", this.wxInfo.getAppId());
        map.put("mch_id", this.wxInfo.getMchid());
        map.put("out_trade_no", TypeConvert.speacToString((Object)out_trade_no));
        map.put("nonce_str", JUUID.getUUID());
        String sign = this.wxSign.createSign("UTF-8", map);
        map.put("sign", sign);
        String xml = BindXML.buildXML(map);
        new WXRequest();
        String resultDate = WXRequest.URLPost(this.wxInfo.closeorder, xml, false, null);
        map = BindXML.analysisXML(resultDate);
        this.valiSign(map);
        if (map.get(this.wxInfo.return_key).equals(this.wxInfo.return_val) && map.get(this.wxInfo.result_code).equals(this.wxInfo.return_val)) {
            return new ResultDataWrap();
        }
        return new ResultDataWrap(ResultCode.c_505, this.returnMsg(map));
    }

    public ResultDataWrap refund(String transaction_id, String out_trade_no, String out_refund_no, int total_fee, int refund_fee, String op_user_id) {
        SortedMap<String, Object> map = new TreeMap<String, Object>();
        map.put("appid", this.wxInfo.getAppId());
        map.put("mch_id", this.wxInfo.getMchid());
        map.put("nonce_str", JUUID.getUUID());
        map.put("transaction_id", TypeConvert.speacToString((Object)transaction_id));
        map.put("out_trade_no", TypeConvert.speacToString((Object)out_trade_no));
        map.put("out_refund_no", TypeConvert.speacToString((Object)out_refund_no));
        map.put("total_fee", TypeConvert.speacToString((Object)total_fee));
        map.put("refund_fee", TypeConvert.speacToString((Object)refund_fee));
        map.put("op_user_id", TypeConvert.speacToString((Object)op_user_id));
        String sign = this.wxSign.createSign("UTF-8", map);
        map.put("sign", sign);
        String xml = BindXML.buildXML(map);
        String resultDate = this.certificateHttpRequest.sendPost(this.wxInfo.refund, xml);
        map = BindXML.analysisXML(resultDate);
        this.valiSign(map);
        if (map.get(this.wxInfo.return_key).equals(this.wxInfo.return_val)) {
            String refund_channel = map.get("refund_channel").toString();
            map.put("refund_channel_ch", this.wxInfo.getRefundType(refund_channel));
            ResultDataWrap resultDataWrap = new ResultDataWrap();
            resultDataWrap.putData(map);
            return resultDataWrap;
        }
        return new ResultDataWrap(ResultCode.c_505, this.returnMsg(map));
    }

    public ResultDataWrap queryRefund(String transaction_id, String out_trade_no, String out_refund_no, String refund_id) {
        SortedMap<String, Object> map = new TreeMap<String, Object>();
        map.put("appid", this.wxInfo.getAppId());
        map.put("mch_id", this.wxInfo.getMchid());
        map.put("transaction_id", TypeConvert.speacToString((Object)transaction_id));
        map.put("out_trade_no", TypeConvert.speacToString((Object)out_trade_no));
        map.put("out_refund_no", TypeConvert.speacToString((Object)out_refund_no));
        map.put("refund_id", TypeConvert.speacToString((Object)refund_id));
        map.put("nonce_str", JUUID.getUUID());
        String sign = this.wxSign.createSign("UTF-8", map);
        map.put("sign", sign);
        String xml = BindXML.buildXML(map);
        new WXRequest();
        String resultDate = WXRequest.URLPost(this.wxInfo.refundquery, xml, false, null);
        map = BindXML.analysisXML(resultDate);
        this.valiSign(map);
        if (map.get(this.wxInfo.return_key).equals(this.wxInfo.return_val)) {
            ResultDataWrap resultDataWrap = new ResultDataWrap();
            resultDataWrap.putData(map);
            return resultDataWrap;
        }
        return new ResultDataWrap(ResultCode.c_505, this.returnMsg(map));
    }

    public ResultDataWrap downloadBill(String bill_date, String bill_type, String tar_type) {
        if (TypeConvert.isNull((Object[])new Object[]{bill_type})) {
            bill_type = "SUCCESS";
        }
        if (TypeConvert.isNull((Object[])new Object[]{tar_type})) {
            tar_type = "GZIP";
        }
        SortedMap<String, Object> map = new TreeMap<String, Object>();
        map.put("appid", this.wxInfo.getAppId());
        map.put("mch_id", this.wxInfo.getMchid());
        map.put("bill_date", bill_date);
        map.put("bill_type", bill_type);
        map.put("tar_type", tar_type);
        map.put("nonce_str", JUUID.getUUID());
        String sign = this.wxSign.createSign("UTF-8", map);
        map.put("sign", sign);
        String xml = BindXML.buildXML(map);
        new WXRequest();
        String resultDate = WXRequest.URLPost(this.wxInfo.downloadbill, xml, true, ".gzip");
        if (resultDate.contains("<xml>")) {
            map = BindXML.analysisXML(resultDate);
            this.valiSign(map);
            if (map.get(this.wxInfo.return_key).equals(this.wxInfo.return_val)) {
                ResultDataWrap resultDataWrap = new ResultDataWrap();
                resultDataWrap.putData(map);
                return resultDataWrap;
            }
            return new ResultDataWrap(ResultCode.c_505, this.returnMsg(map));
        }
        ResultDataWrap resultDataWrap = new ResultDataWrap();
        resultDataWrap.putData((Object)resultDate);
        return resultDataWrap;
    }

    private Object valiSign(SortedMap<String, Object> map) {
        if (map.get(this.wxInfo.return_key).equals(this.wxInfo.return_val)) {
            String s = map.get("sign").toString();
            map.remove("sign");
            String sign = this.wxSign.createSign("UTF-8", map);
            if (!s.equals(sign)) {
                map = new TreeMap<String, Object>();
                map.put(this.wxInfo.return_key, "FAIL");
                map.put(this.wxInfo.return_msg, "\u7b7e\u540d\u6709\u8bef");
            }
        }
        return map;
    }

    protected String returnMsg(SortedMap<String, Object> map) {
        return map.get(this.wxInfo.return_msg).toString().equals("OK") ? this.wxInfo.getErrorMsg(map.get(this.wxInfo.err_code).toString()) : map.get(this.wxInfo.return_msg).toString();
    }
}

