/*
 * Decompiled with CFR 0.152.
 */
package cn.luues.tool.http;

import cn.luues.tool.core.collection.CollUtil;
import cn.luues.tool.core.convert.Convert;
import cn.luues.tool.core.io.IORuntimeException;
import cn.luues.tool.core.io.IoUtil;
import cn.luues.tool.core.io.resource.BytesResource;
import cn.luues.tool.core.io.resource.FileResource;
import cn.luues.tool.core.io.resource.MultiFileResource;
import cn.luues.tool.core.io.resource.Resource;
import cn.luues.tool.core.lang.Assert;
import cn.luues.tool.core.map.MapUtil;
import cn.luues.tool.core.net.url.UrlBuilder;
import cn.luues.tool.core.util.ArrayUtil;
import cn.luues.tool.core.util.CharsetUtil;
import cn.luues.tool.core.util.ObjectUtil;
import cn.luues.tool.core.util.StrUtil;
import cn.luues.tool.http.ContentType;
import cn.luues.tool.http.GlobalHeaders;
import cn.luues.tool.http.Header;
import cn.luues.tool.http.HttpBase;
import cn.luues.tool.http.HttpConnection;
import cn.luues.tool.http.HttpException;
import cn.luues.tool.http.HttpGlobalConfig;
import cn.luues.tool.http.HttpResponse;
import cn.luues.tool.http.HttpUtil;
import cn.luues.tool.http.Method;
import cn.luues.tool.http.body.MultipartBody;
import cn.luues.tool.http.cookie.GlobalCookieManager;
import cn.luues.tool.http.ssl.SSLSocketFactoryBuilder;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.net.CookieManager;
import java.net.HttpCookie;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.URLStreamHandler;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLSocketFactory;

public class HttpRequest
extends HttpBase<HttpRequest> {
    private static final String CONTENT_TYPE_MULTIPART_PREFIX = ContentType.MULTIPART.getValue() + "; boundary=";
    private static final String CONTENT_TYPE_FILE_TEMPLATE = "Content-Type: {}\r\n\r\n";
    private UrlBuilder url;
    private URLStreamHandler urlHandler;
    private Method method = Method.GET;
    private int connectionTimeout = HttpGlobalConfig.timeout;
    private int readTimeout = HttpGlobalConfig.timeout;
    private Map<String, Object> form;
    private boolean isMultiPart;
    private String cookie;
    private HttpConnection httpConnection;
    private boolean isDisableCache;
    private boolean isRest;
    private int redirectCount;
    private int maxRedirectCount;
    private int blockSize;
    private Proxy proxy;
    private HostnameVerifier hostnameVerifier;
    private SSLSocketFactory ssf;

    public static void setGlobalTimeout(int customTimeout) {
        HttpGlobalConfig.setTimeout(customTimeout);
    }

    public static CookieManager getCookieManager() {
        return GlobalCookieManager.getCookieManager();
    }

    public static void setCookieManager(CookieManager customCookieManager) {
        GlobalCookieManager.setCookieManager(customCookieManager);
    }

    public static void closeCookie() {
        GlobalCookieManager.setCookieManager(null);
    }

    public HttpRequest(String url) {
        this(UrlBuilder.ofHttp((String)url, (Charset)CharsetUtil.CHARSET_UTF_8));
    }

    public HttpRequest(UrlBuilder url) {
        this.url = url;
        this.header(GlobalHeaders.INSTANCE.headers);
    }

    public static HttpRequest post(String url) {
        return new HttpRequest(url).method(Method.POST);
    }

    public static HttpRequest get(String url) {
        return new HttpRequest(url).method(Method.GET);
    }

    public static HttpRequest head(String url) {
        return new HttpRequest(url).method(Method.HEAD);
    }

    public static HttpRequest options(String url) {
        return new HttpRequest(url).method(Method.OPTIONS);
    }

    public static HttpRequest put(String url) {
        return new HttpRequest(url).method(Method.PUT);
    }

    public static HttpRequest patch(String url) {
        return new HttpRequest(url).method(Method.PATCH);
    }

    public static HttpRequest delete(String url) {
        return new HttpRequest(url).method(Method.DELETE);
    }

    public static HttpRequest trace(String url) {
        return new HttpRequest(url).method(Method.TRACE);
    }

    public String getUrl() {
        return this.url.toString();
    }

    public HttpRequest setUrl(String url) {
        this.url = UrlBuilder.ofHttp((String)url, (Charset)this.charset);
        return this;
    }

    public HttpRequest setUrl(UrlBuilder urlBuilder) {
        this.url = urlBuilder;
        return this;
    }

    public HttpRequest setUrlHandler(URLStreamHandler urlHandler) {
        this.urlHandler = urlHandler;
        return this;
    }

    public Method getMethod() {
        return this.method;
    }

    public HttpRequest setMethod(Method method) {
        return this.method(method);
    }

    public HttpConnection getConnection() {
        return this.httpConnection;
    }

    public HttpRequest method(Method method) {
        this.method = method;
        return this;
    }

    public HttpRequest contentType(String contentType) {
        this.header(Header.CONTENT_TYPE, contentType);
        return this;
    }

    public HttpRequest keepAlive(boolean isKeepAlive) {
        this.header(Header.CONNECTION, isKeepAlive ? "Keep-Alive" : "Close");
        return this;
    }

    public boolean isKeepAlive() {
        String connection = this.header(Header.CONNECTION);
        if (connection == null) {
            return !this.httpVersion.equalsIgnoreCase("HTTP/1.0");
        }
        return false == "close".equalsIgnoreCase(connection);
    }

    public String contentLength() {
        return this.header(Header.CONTENT_LENGTH);
    }

    public HttpRequest contentLength(int value) {
        this.header(Header.CONTENT_LENGTH, String.valueOf(value));
        return this;
    }

    public HttpRequest cookie(Collection<HttpCookie> cookies) {
        return this.cookie(CollUtil.isEmpty(cookies) ? null : cookies.toArray(new HttpCookie[0]));
    }

    public HttpRequest cookie(HttpCookie ... cookies) {
        if (ArrayUtil.isEmpty((Object[])cookies)) {
            return this.disableCookie();
        }
        return this.cookie(ArrayUtil.join((Object[])cookies, (CharSequence)";"));
    }

    public HttpRequest cookie(String cookie) {
        this.cookie = cookie;
        return this;
    }

    public HttpRequest disableCookie() {
        return this.cookie("");
    }

    public HttpRequest enableDefaultCookie() {
        return this.cookie((String)null);
    }

    public HttpRequest form(String name, Object value) {
        String strValue;
        if (StrUtil.isBlank((CharSequence)name) || ObjectUtil.isNull((Object)value)) {
            return this;
        }
        this.bodyBytes = null;
        if (value instanceof File) {
            return this.form(name, (File)value);
        }
        if (value instanceof Resource) {
            return this.form(name, (Resource)value);
        }
        if (value instanceof List) {
            strValue = CollUtil.join((Iterable)((List)value), (CharSequence)",");
        } else if (ArrayUtil.isArray((Object)value)) {
            if (File.class == ArrayUtil.getComponentType((Object)value)) {
                return this.form(name, (File[])value);
            }
            strValue = ArrayUtil.join((Object[])((Object[])value), (CharSequence)",");
        } else {
            strValue = Convert.toStr((Object)value, null);
        }
        return this.putToForm(name, strValue);
    }

    public HttpRequest form(String name, Object value, Object ... parameters) {
        this.form(name, value);
        for (int i = 0; i < parameters.length; i += 2) {
            this.form(parameters[i].toString(), parameters[i + 1]);
        }
        return this;
    }

    public HttpRequest form(Map<String, Object> formMap) {
        if (MapUtil.isNotEmpty(formMap)) {
            formMap.forEach(this::form);
        }
        return this;
    }

    public HttpRequest form(String name, File ... files) {
        if (ArrayUtil.isEmpty((Object[])files)) {
            return this;
        }
        if (1 == files.length) {
            File file = files[0];
            return this.form(name, file, file.getName());
        }
        return this.form(name, (Resource)new MultiFileResource(files));
    }

    public HttpRequest form(String name, File file) {
        return this.form(name, file, file.getName());
    }

    public HttpRequest form(String name, File file, String fileName) {
        if (null != file) {
            this.form(name, (Resource)new FileResource(file, fileName));
        }
        return this;
    }

    public HttpRequest form(String name, byte[] fileBytes, String fileName) {
        if (null != fileBytes) {
            this.form(name, (Resource)new BytesResource(fileBytes, fileName));
        }
        return this;
    }

    public HttpRequest form(String name, Resource resource) {
        if (null != resource) {
            if (!this.isKeepAlive()) {
                this.keepAlive(true);
            }
            this.isMultiPart = true;
            return this.putToForm(name, resource);
        }
        return this;
    }

    public Map<String, Object> form() {
        return this.form;
    }

    public Map<String, Resource> fileForm() {
        HashMap result = MapUtil.newHashMap();
        this.form.forEach((key, value) -> {
            if (value instanceof Resource) {
                result.put(key, (Resource)value);
            }
        });
        return result;
    }

    public HttpRequest body(String body) {
        return this.body(body, null);
    }

    public HttpRequest body(String body, String contentType) {
        byte[] bytes = StrUtil.bytes((CharSequence)body, (Charset)this.charset);
        this.body(bytes);
        this.form = null;
        if (null != contentType) {
            this.contentType(contentType);
        } else {
            contentType = HttpUtil.getContentTypeByRequestBody(body);
            if (null != contentType && ContentType.isDefault(this.header(Header.CONTENT_TYPE))) {
                if (null != this.charset) {
                    contentType = ContentType.build(contentType, this.charset);
                }
                this.contentType(contentType);
            }
        }
        if (StrUtil.containsAnyIgnoreCase((CharSequence)contentType, (CharSequence[])new CharSequence[]{"json", "xml"})) {
            this.isRest = true;
            this.contentLength(bytes.length);
        }
        return this;
    }

    public HttpRequest body(byte[] bodyBytes) {
        if (null != bodyBytes) {
            this.bodyBytes = bodyBytes;
        }
        return this;
    }

    public HttpRequest timeout(int milliseconds) {
        this.setConnectionTimeout(milliseconds);
        this.setReadTimeout(milliseconds);
        return this;
    }

    public HttpRequest setConnectionTimeout(int milliseconds) {
        this.connectionTimeout = milliseconds;
        return this;
    }

    public HttpRequest setReadTimeout(int milliseconds) {
        this.readTimeout = milliseconds;
        return this;
    }

    public HttpRequest disableCache() {
        this.isDisableCache = true;
        return this;
    }

    @Deprecated
    public HttpRequest setEncodeUrlParams(boolean isEncodeUrlParams) {
        return this;
    }

    public HttpRequest setFollowRedirects(boolean isFollowRedirects) {
        return this.setMaxRedirectCount(isFollowRedirects ? 2 : 0);
    }

    public HttpRequest setMaxRedirectCount(int maxRedirectCount) {
        this.maxRedirectCount = Math.max(maxRedirectCount, 0);
        return this;
    }

    public HttpRequest setHostnameVerifier(HostnameVerifier hostnameVerifier) {
        this.hostnameVerifier = hostnameVerifier;
        return this;
    }

    public HttpRequest setHttpProxy(String host, int port) {
        Proxy proxy = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(host, port));
        return this.setProxy(proxy);
    }

    public HttpRequest setProxy(Proxy proxy) {
        this.proxy = proxy;
        return this;
    }

    public HttpRequest setSSLSocketFactory(SSLSocketFactory ssf) {
        this.ssf = ssf;
        return this;
    }

    public HttpRequest setSSLProtocol(String protocol) {
        Assert.notBlank((CharSequence)protocol, (String)"protocol must be not blank!", (Object[])new Object[0]);
        try {
            this.setSSLSocketFactory(SSLSocketFactoryBuilder.create().setProtocol(protocol).build());
        }
        catch (Exception e) {
            throw new HttpException(e);
        }
        return this;
    }

    public HttpRequest setRest(boolean isRest) {
        this.isRest = isRest;
        return this;
    }

    public HttpRequest setChunkedStreamingMode(int blockSize) {
        this.blockSize = blockSize;
        return this;
    }

    public HttpResponse execute() {
        return this.execute(false);
    }

    public HttpResponse executeAsync() {
        return this.execute(true);
    }

    public HttpResponse execute(boolean isAsync) {
        this.urlWithParamIfGet();
        this.initConnection();
        this.send();
        HttpResponse httpResponse = this.sendRedirectIfPossible();
        if (null == httpResponse) {
            httpResponse = new HttpResponse(this.httpConnection, this.charset, isAsync, this.isIgnoreResponseBody());
        }
        return httpResponse;
    }

    public HttpRequest basicAuth(String username, String password) {
        return this.auth(HttpUtil.buildBasicAuth(username, password, this.charset));
    }

    public HttpRequest basicProxyAuth(String username, String password) {
        return this.proxyAuth(HttpUtil.buildBasicAuth(username, password, this.charset));
    }

    public HttpRequest bearerAuth(String token) {
        return this.auth("Bearer " + token);
    }

    public HttpRequest auth(String content) {
        this.header(Header.AUTHORIZATION, content, true);
        return this;
    }

    public HttpRequest proxyAuth(String content) {
        this.header(Header.PROXY_AUTHORIZATION, content, true);
        return this;
    }

    @Override
    public String toString() {
        StringBuilder sb = StrUtil.builder();
        sb.append("Request Url: ").append(this.url).append("\r\n");
        sb.append(super.toString());
        return sb.toString();
    }

    private void initConnection() {
        if (null != this.httpConnection) {
            this.httpConnection.disconnectQuietly();
        }
        this.httpConnection = HttpConnection.create(this.url.toURL(this.urlHandler), this.proxy).setMethod(this.method).setHttpsInfo(this.hostnameVerifier, this.ssf).setConnectTimeout(this.connectionTimeout).setReadTimeout(this.readTimeout).setInstanceFollowRedirects(this.maxRedirectCount > 0).setChunkedStreamingMode(this.blockSize).header(this.headers, true);
        if (null != this.cookie) {
            this.httpConnection.setCookie(this.cookie);
        } else {
            GlobalCookieManager.add(this.httpConnection);
        }
        if (this.isDisableCache) {
            this.httpConnection.disableCache();
        }
    }

    private void urlWithParamIfGet() {
        if (Method.GET.equals((Object)this.method) && !this.isRest) {
            if (ArrayUtil.isNotEmpty((byte[])this.bodyBytes)) {
                this.url.getQuery().parse(StrUtil.str((byte[])this.bodyBytes, (Charset)this.charset), this.charset);
            } else {
                this.url.getQuery().addAll(this.form);
            }
        }
    }

    private HttpResponse sendRedirectIfPossible() {
        if (this.maxRedirectCount < 1) {
            return null;
        }
        if (this.httpConnection.getHttpURLConnection().getInstanceFollowRedirects()) {
            int responseCode;
            try {
                responseCode = this.httpConnection.responseCode();
            }
            catch (IOException e) {
                this.httpConnection.disconnectQuietly();
                throw new HttpException(e);
            }
            if (responseCode != 200 && (responseCode == 302 || responseCode == 301 || responseCode == 303)) {
                this.setUrl(this.httpConnection.header(Header.LOCATION));
                if (this.redirectCount < this.maxRedirectCount) {
                    ++this.redirectCount;
                    return this.execute();
                }
            }
        }
        return null;
    }

    private void send() throws IORuntimeException {
        try {
            if (Method.POST.equals((Object)this.method) || Method.PUT.equals((Object)this.method) || Method.DELETE.equals((Object)this.method) || this.isRest) {
                if (this.isMultipart()) {
                    this.sendMultipart();
                } else {
                    this.sendFormUrlEncoded();
                }
            } else {
                this.httpConnection.connect();
            }
        }
        catch (IOException e) {
            this.httpConnection.disconnectQuietly();
            throw new IORuntimeException((Throwable)e);
        }
    }

    private void sendFormUrlEncoded() throws IOException {
        if (StrUtil.isBlank((CharSequence)this.header(Header.CONTENT_TYPE))) {
            this.httpConnection.header(Header.CONTENT_TYPE, ContentType.FORM_URLENCODED.toString(this.charset), true);
        }
        byte[] content = ArrayUtil.isNotEmpty((byte[])this.bodyBytes) ? this.bodyBytes : StrUtil.bytes((CharSequence)this.getFormUrlEncoded(), (Charset)this.charset);
        IoUtil.write((OutputStream)this.httpConnection.getOutputStream(), (boolean)true, (byte[])content);
    }

    private String getFormUrlEncoded() {
        return HttpUtil.toParams(this.form, this.charset);
    }

    private void sendMultipart() throws IOException {
        this.setMultipart();
        try (OutputStream out = this.httpConnection.getOutputStream();){
            MultipartBody.create(this.form, this.charset).write(out);
        }
    }

    private void setMultipart() {
        this.httpConnection.header(Header.CONTENT_TYPE, MultipartBody.getContentType(), true);
    }

    private boolean isIgnoreResponseBody() {
        return Method.HEAD == this.method || Method.CONNECT == this.method || Method.OPTIONS == this.method || Method.TRACE == this.method;
    }

    private boolean isMultipart() {
        if (this.isMultiPart) {
            return true;
        }
        String contentType = this.header(Header.CONTENT_TYPE);
        return StrUtil.isNotEmpty((CharSequence)contentType) && contentType.startsWith(ContentType.MULTIPART.getValue());
    }

    private HttpRequest putToForm(String name, Object value) {
        if (null == name || null == value) {
            return this;
        }
        if (null == this.form) {
            this.form = new LinkedHashMap<String, Object>();
        }
        this.form.put(name, value);
        return this;
    }
}

