/*
 * Decompiled with CFR 0.152.
 */
package cn.luues.tool.http;

import cn.luues.tool.core.codec.Base64;
import cn.luues.tool.core.convert.Convert;
import cn.luues.tool.core.io.FastByteArrayOutputStream;
import cn.luues.tool.core.io.FileUtil;
import cn.luues.tool.core.io.IoUtil;
import cn.luues.tool.core.io.StreamProgress;
import cn.luues.tool.core.lang.Assert;
import cn.luues.tool.core.map.MapUtil;
import cn.luues.tool.core.net.url.UrlQuery;
import cn.luues.tool.core.text.StrBuilder;
import cn.luues.tool.core.util.CharsetUtil;
import cn.luues.tool.core.util.ObjectUtil;
import cn.luues.tool.core.util.ReUtil;
import cn.luues.tool.core.util.StrUtil;
import cn.luues.tool.core.util.URLUtil;
import cn.luues.tool.http.ContentType;
import cn.luues.tool.http.HttpException;
import cn.luues.tool.http.HttpGlobalConfig;
import cn.luues.tool.http.HttpRequest;
import cn.luues.tool.http.HttpResponse;
import cn.luues.tool.http.Method;
import cn.luues.tool.http.server.SimpleServer;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;

public class HttpUtil {
    public static final Pattern CHARSET_PATTERN = Pattern.compile("charset\\s*=\\s*([a-z0-9-]*)", 2);
    public static final Pattern META_CHARSET_PATTERN = Pattern.compile("<meta[^>]*?charset\\s*=\\s*['\"]?([a-z0-9-]*)", 2);

    public static boolean isHttps(String url) {
        return url.toLowerCase().startsWith("https:");
    }

    public static boolean isHttp(String url) {
        return url.toLowerCase().startsWith("http:");
    }

    public static HttpRequest createRequest(Method method, String url) {
        return new HttpRequest(url).method(method);
    }

    public static HttpRequest createGet(String url) {
        return HttpRequest.get(url);
    }

    public static HttpRequest createPost(String url) {
        return HttpRequest.post(url);
    }

    public static String get(String urlString, Charset customCharset) {
        return ((HttpRequest)HttpRequest.get(urlString).charset(customCharset)).execute().body();
    }

    public static String get(String urlString) {
        return HttpUtil.get(urlString, HttpGlobalConfig.timeout);
    }

    public static String get(String urlString, int timeout) {
        return HttpRequest.get(urlString).timeout(timeout).execute().body();
    }

    public static String get(String urlString, Map<String, Object> paramMap) {
        return HttpRequest.get(urlString).form(paramMap).execute().body();
    }

    public static String get(String urlString, Map<String, Object> paramMap, int timeout) {
        return HttpRequest.get(urlString).form(paramMap).timeout(timeout).execute().body();
    }

    public static String post(String urlString, Map<String, Object> paramMap) {
        return HttpUtil.post(urlString, paramMap, HttpGlobalConfig.timeout);
    }

    public static String post(String urlString, Map<String, Object> paramMap, int timeout) {
        return HttpRequest.post(urlString).form(paramMap).timeout(timeout).execute().body();
    }

    public static String post(String urlString, String body) {
        return HttpUtil.post(urlString, body, HttpGlobalConfig.timeout);
    }

    public static String post(String urlString, String body, int timeout) {
        return HttpRequest.post(urlString).timeout(timeout).body(body).execute().body();
    }

    public static String downloadString(String url, String customCharsetName) {
        return HttpUtil.downloadString(url, CharsetUtil.charset((String)customCharsetName), null);
    }

    public static String downloadString(String url, Charset customCharset) {
        return HttpUtil.downloadString(url, customCharset, null);
    }

    public static String downloadString(String url, Charset customCharset, StreamProgress streamPress) {
        if (StrUtil.isBlank((CharSequence)url)) {
            throw new NullPointerException("[url] is null!");
        }
        FastByteArrayOutputStream out = new FastByteArrayOutputStream();
        HttpUtil.download(url, (OutputStream)out, true, streamPress);
        return null == customCharset ? out.toString() : out.toString(customCharset);
    }

    public static long downloadFile(String url, String dest) {
        return HttpUtil.downloadFile(url, FileUtil.file((String)dest));
    }

    public static long downloadFile(String url, File destFile) {
        return HttpUtil.downloadFile(url, destFile, null);
    }

    public static long downloadFile(String url, File destFile, int timeout) {
        return HttpUtil.downloadFile(url, destFile, timeout, null);
    }

    public static long downloadFile(String url, File destFile, StreamProgress streamProgress) {
        return HttpUtil.downloadFile(url, destFile, -1, streamProgress);
    }

    public static long downloadFile(String url, File destFile, int timeout, StreamProgress streamProgress) {
        return HttpUtil.requestDownloadFile(url, destFile, timeout).writeBody(destFile, streamProgress);
    }

    public static File downloadFileFromUrl(String url, String dest) {
        return HttpUtil.downloadFileFromUrl(url, FileUtil.file((String)dest));
    }

    public static File downloadFileFromUrl(String url, File destFile) {
        return HttpUtil.downloadFileFromUrl(url, destFile, null);
    }

    public static File downloadFileFromUrl(String url, File destFile, int timeout) {
        return HttpUtil.downloadFileFromUrl(url, destFile, timeout, null);
    }

    public static File downloadFileFromUrl(String url, File destFile, StreamProgress streamProgress) {
        return HttpUtil.downloadFileFromUrl(url, destFile, -1, streamProgress);
    }

    public static File downloadFileFromUrl(String url, File destFile, int timeout, StreamProgress streamProgress) {
        HttpResponse response = HttpUtil.requestDownloadFile(url, destFile, timeout);
        File outFile = response.completeFileNameFromHeader(destFile);
        long writeBytes = response.writeBody(outFile, streamProgress);
        return outFile;
    }

    private static HttpResponse requestDownloadFile(String url, File destFile, int timeout) {
        Assert.notBlank((CharSequence)url, (String)"[url] is blank !", (Object[])new Object[0]);
        Assert.notNull((Object)destFile, (String)"[destFile] is null !", (Object[])new Object[0]);
        HttpResponse response = HttpRequest.get(url).timeout(timeout).executeAsync();
        if (response.isOk()) {
            return response;
        }
        throw new HttpException("Server response error with status code: [{}]", response.getStatus());
    }

    public static long download(String url, OutputStream out, boolean isCloseOut) {
        return HttpUtil.download(url, out, isCloseOut, null);
    }

    public static long download(String url, OutputStream out, boolean isCloseOut, StreamProgress streamProgress) {
        if (StrUtil.isBlank((CharSequence)url)) {
            throw new NullPointerException("[url] is null!");
        }
        if (null == out) {
            throw new NullPointerException("[out] is null!");
        }
        HttpResponse response = HttpRequest.get(url).executeAsync();
        if (!response.isOk()) {
            throw new HttpException("Server response error with status code: [{}]", response.getStatus());
        }
        return response.writeBody(out, isCloseOut, streamProgress);
    }

    public static byte[] downloadBytes(String url) {
        if (StrUtil.isBlank((CharSequence)url)) {
            throw new NullPointerException("[url] is null!");
        }
        HttpResponse response = HttpRequest.get(url).setFollowRedirects(true).executeAsync();
        if (!response.isOk()) {
            throw new HttpException("Server response error with status code: [{}]", response.getStatus());
        }
        return response.bodyBytes();
    }

    public static String toParams(Map<String, ?> paramMap) {
        return HttpUtil.toParams(paramMap, CharsetUtil.CHARSET_UTF_8);
    }

    public static String toParams(Map<String, Object> paramMap, String charsetName) {
        return HttpUtil.toParams(paramMap, CharsetUtil.charset((String)charsetName));
    }

    public static String toParams(Map<String, ?> paramMap, Charset charset) {
        return URLUtil.buildQuery(paramMap, (Charset)charset);
    }

    public static String encodeParams(String urlWithParams, Charset charset) {
        String paramPart;
        if (StrUtil.isBlank((CharSequence)urlWithParams)) {
            return "";
        }
        String urlPart = null;
        int pathEndPos = urlWithParams.indexOf(63);
        if (pathEndPos > -1) {
            urlPart = StrUtil.subPre((CharSequence)urlWithParams, (int)pathEndPos);
            paramPart = StrUtil.subSuf((CharSequence)urlWithParams, (int)(pathEndPos + 1));
            if (StrUtil.isBlank((CharSequence)paramPart)) {
                return urlPart;
            }
        } else {
            if (!StrUtil.contains((CharSequence)urlWithParams, (char)'=')) {
                return urlWithParams;
            }
            paramPart = urlWithParams;
        }
        paramPart = HttpUtil.normalizeParams(paramPart, charset);
        return StrUtil.isBlank((CharSequence)urlPart) ? paramPart : urlPart + "?" + paramPart;
    }

    public static String normalizeParams(String paramPart, Charset charset) {
        int lastIndex;
        int i;
        StrBuilder builder = StrBuilder.create((int)(paramPart.length() + 16));
        int len = paramPart.length();
        String name = null;
        int pos = 0;
        for (i = 0; i < len; ++i) {
            char c = paramPart.charAt(i);
            if (c == '=') {
                if (null != name) continue;
                name = pos == i ? "" : paramPart.substring(pos, i);
                pos = i + 1;
                continue;
            }
            if (c != '&') continue;
            if (pos != i) {
                if (null == name) {
                    name = paramPart.substring(pos, i);
                    builder.append((CharSequence)URLUtil.encodeQuery((String)name, (Charset)charset)).append('=');
                } else {
                    builder.append((CharSequence)URLUtil.encodeQuery((String)name, (Charset)charset)).append('=').append((CharSequence)URLUtil.encodeQuery((String)paramPart.substring(pos, i), (Charset)charset)).append('&');
                }
                name = null;
            }
            pos = i + 1;
        }
        if (null != name) {
            builder.append((CharSequence)URLUtil.encodeQuery(name, (Charset)charset)).append('=');
        }
        if (pos != i) {
            if (null == name && pos > 0) {
                builder.append('=');
            }
            builder.append((CharSequence)URLUtil.encodeQuery((String)paramPart.substring(pos, i), (Charset)charset));
        }
        if ('&' == builder.charAt(lastIndex = builder.length() - 1)) {
            builder.delTo(lastIndex);
        }
        return builder.toString();
    }

    @Deprecated
    public static Map<String, String> decodeParamMap(String paramsStr, String charset) {
        return HttpUtil.decodeParamMap(paramsStr, CharsetUtil.charset((String)charset));
    }

    public static Map<String, String> decodeParamMap(String paramsStr, Charset charset) {
        Map queryMap = UrlQuery.of((String)paramsStr, (Charset)charset).getQueryMap();
        if (MapUtil.isEmpty((Map)queryMap)) {
            return MapUtil.empty();
        }
        return Convert.toMap(String.class, String.class, (Object)queryMap);
    }

    public static Map<String, List<String>> decodeParams(String paramsStr, String charset) {
        return HttpUtil.decodeParams(paramsStr, CharsetUtil.charset((String)charset));
    }

    public static Map<String, List<String>> decodeParams(String paramsStr, Charset charset) {
        Map queryMap = UrlQuery.of((String)paramsStr, (Charset)charset).getQueryMap();
        if (MapUtil.isEmpty((Map)queryMap)) {
            return MapUtil.empty();
        }
        LinkedHashMap<String, List<String>> params = new LinkedHashMap<String, List<String>>();
        queryMap.forEach((key, value) -> {
            List values = params.computeIfAbsent(StrUtil.str((CharSequence)key), k -> new ArrayList(1));
            values.add(StrUtil.str((CharSequence)value));
        });
        return params;
    }

    public static String urlWithForm(String url, Map<String, Object> form, Charset charset, boolean isEncodeParams) {
        if (isEncodeParams && StrUtil.contains((CharSequence)url, (char)'?')) {
            url = HttpUtil.encodeParams(url, charset);
        }
        return HttpUtil.urlWithForm(url, HttpUtil.toParams(form, charset), charset, false);
    }

    public static String urlWithForm(String url, String queryString, Charset charset, boolean isEncode) {
        if (StrUtil.isBlank((CharSequence)queryString)) {
            if (StrUtil.contains((CharSequence)url, (char)'?')) {
                return isEncode ? HttpUtil.encodeParams(url, charset) : url;
            }
            return url;
        }
        StrBuilder urlBuilder = StrBuilder.create((int)(url.length() + queryString.length() + 16));
        int qmIndex = url.indexOf(63);
        if (qmIndex > 0) {
            urlBuilder.append((CharSequence)(isEncode ? HttpUtil.encodeParams(url, charset) : url));
            if (!StrUtil.endWith((CharSequence)url, (char)'&')) {
                urlBuilder.append('&');
            }
        } else {
            urlBuilder.append((CharSequence)url);
            if (qmIndex < 0) {
                urlBuilder.append('?');
            }
        }
        urlBuilder.append((CharSequence)(isEncode ? HttpUtil.encodeParams(queryString, charset) : queryString));
        return urlBuilder.toString();
    }

    public static String getCharset(HttpURLConnection conn) {
        if (conn == null) {
            return null;
        }
        return HttpUtil.getCharset(conn.getContentType());
    }

    public static String getCharset(String contentType) {
        if (StrUtil.isBlank((CharSequence)contentType)) {
            return null;
        }
        return ReUtil.get((Pattern)CHARSET_PATTERN, (CharSequence)contentType, (int)1);
    }

    public static String getString(InputStream in, Charset charset, boolean isGetCharsetFromContent) {
        byte[] contentBytes = IoUtil.readBytes((InputStream)in);
        return HttpUtil.getString(contentBytes, charset, isGetCharsetFromContent);
    }

    public static String getString(byte[] contentBytes, Charset charset, boolean isGetCharsetFromContent) {
        String charsetInContentStr;
        if (null == contentBytes) {
            return null;
        }
        if (null == charset) {
            charset = CharsetUtil.CHARSET_UTF_8;
        }
        String content = new String(contentBytes, charset);
        if (isGetCharsetFromContent && StrUtil.isNotBlank((CharSequence)(charsetInContentStr = ReUtil.get((Pattern)META_CHARSET_PATTERN, (CharSequence)content, (int)1)))) {
            Charset charsetInContent;
            block7: {
                charsetInContent = null;
                try {
                    charsetInContent = Charset.forName(charsetInContentStr);
                }
                catch (Exception e) {
                    if (StrUtil.containsIgnoreCase((CharSequence)charsetInContentStr, (CharSequence)"utf-8") || StrUtil.containsIgnoreCase((CharSequence)charsetInContentStr, (CharSequence)"utf8")) {
                        charsetInContent = CharsetUtil.CHARSET_UTF_8;
                    }
                    if (!StrUtil.containsIgnoreCase((CharSequence)charsetInContentStr, (CharSequence)"gbk")) break block7;
                    charsetInContent = CharsetUtil.CHARSET_GBK;
                }
            }
            if (null != charsetInContent && !charset.equals(charsetInContent)) {
                content = new String(contentBytes, charsetInContent);
            }
        }
        return content;
    }

    public static String getMimeType(String filePath, String defaultValue) {
        return (String)ObjectUtil.defaultIfNull((Object)HttpUtil.getMimeType(filePath), (Object)defaultValue);
    }

    public static String getMimeType(String filePath) {
        return FileUtil.getMimeType((String)filePath);
    }

    public static String getContentTypeByRequestBody(String body) {
        ContentType contentType = ContentType.get(body);
        return null == contentType ? null : contentType.toString();
    }

    public static SimpleServer createServer(int port) {
        return new SimpleServer(port);
    }

    public static String buildBasicAuth(String username, String password, Charset charset) {
        String data = username.concat(":").concat(password);
        return "Basic " + Base64.encode((CharSequence)data, (Charset)charset);
    }
}

