/*
 * Decompiled with CFR 0.152.
 */
package cn.luues.tool.http.cookie;

import java.net.CookieManager;
import java.net.CookieStore;
import java.net.HttpCookie;
import java.net.URI;
import java.util.List;

public class ThreadLocalCookieStore
implements CookieStore {
    private static final ThreadLocal<CookieStore> STORES = new ThreadLocal<CookieStore>(){

        @Override
        protected synchronized CookieStore initialValue() {
            return new CookieManager().getCookieStore();
        }
    };

    public CookieStore getCookieStore() {
        return STORES.get();
    }

    public ThreadLocalCookieStore removeCurrent() {
        STORES.remove();
        return this;
    }

    @Override
    public void add(URI uri, HttpCookie cookie) {
        this.getCookieStore().add(uri, cookie);
    }

    @Override
    public List<HttpCookie> get(URI uri) {
        return this.getCookieStore().get(uri);
    }

    @Override
    public List<HttpCookie> getCookies() {
        return this.getCookieStore().getCookies();
    }

    @Override
    public List<URI> getURIs() {
        return this.getCookieStore().getURIs();
    }

    @Override
    public boolean remove(URI uri, HttpCookie cookie) {
        return this.getCookieStore().remove(uri, cookie);
    }

    @Override
    public boolean removeAll() {
        return this.getCookieStore().removeAll();
    }
}

