/*
 * Decompiled with CFR 0.152.
 */
package com.github.manikmagar.maven.versioner.core.git;

import com.github.manikmagar.maven.versioner.core.git.JGit;
import com.github.manikmagar.maven.versioner.core.params.VersionConfig;
import com.github.manikmagar.maven.versioner.core.version.VersionComponentType;
import com.github.manikmagar.maven.versioner.core.version.VersionPatternStrategy;
import com.github.manikmagar.maven.versioner.core.version.VersionStrategy;
import com.github.manikmagar.maven.versioner.core.version.Versioner;
import java.io.File;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.revwalk.RevCommit;

public class JGitVersioner
implements Versioner {
    File basePath;
    VersionConfig versionConfig;

    public JGitVersioner(File basePath, VersionConfig versionConfig) {
        this.versionConfig = versionConfig;
        this.basePath = basePath;
    }

    @Override
    public VersionStrategy version() {
        return JGit.executeOperation(this.basePath, git -> {
            String branch = git.getRepository().getBranch();
            Ref head = git.getRepository().findRef("HEAD");
            String hash = "";
            if (head != null && head.getObjectId() != null) {
                hash = head.getObjectId().getName();
            }
            VersionPatternStrategy versionStrategy = new VersionPatternStrategy(this.versionConfig.getInitial().getMajor(), this.versionConfig.getInitial().getMinor(), this.versionConfig.getInitial().getPatch(), branch, hash, this.versionConfig.getVersionPattern().getPattern());
            Iterable commits = git.log().call();
            List revCommits = StreamSupport.stream(commits.spliterator(), false).collect(Collectors.toList());
            Collections.reverse(revCommits);
            for (RevCommit commit : revCommits) {
                if (this.hasValue(commit.getFullMessage(), this.versionConfig.getKeywords().getMajorKey())) {
                    versionStrategy.increment(VersionComponentType.MAJOR, hash);
                    continue;
                }
                if (this.hasValue(commit.getFullMessage(), this.versionConfig.getKeywords().getMinorKey())) {
                    versionStrategy.increment(VersionComponentType.MINOR, hash);
                    continue;
                }
                if (this.hasValue(commit.getFullMessage(), this.versionConfig.getKeywords().getPatchKey())) {
                    versionStrategy.increment(VersionComponentType.PATCH, hash);
                    continue;
                }
                versionStrategy.increment(VersionComponentType.COMMIT, hash);
            }
            return versionStrategy;
        });
    }

    boolean hasValue(String commitMessage, String keyword) {
        if (this.versionConfig.getKeywords().isUseRegex()) {
            return commitMessage.matches(keyword);
        }
        return commitMessage.contains(keyword);
    }
}

