/*
 * Decompiled with CFR 0.152.
 */
package com.github.manikmagar.maven.versioner.core.params;

import com.github.manikmagar.maven.versioner.core.Util;
import java.util.Objects;

public final class InitialVersion {
    public static final String GV_INITIAL_VERSION_MAJOR = "gv.initialVersion.major";
    public static final String GV_INITIAL_VERSION_MINOR = "gv.initialVersion.minor";
    public static final String GV_INITIAL_VERSION_PATCH = "gv.initialVersion.patch";
    private int major = 0;
    private int minor = 0;
    private int patch = 0;

    public InitialVersion(int major, int minor, int patch) {
        this.setMajor(major);
        this.setMinor(minor);
        this.setPatch(patch);
    }

    public InitialVersion() {
        this(0, 0, 0);
    }

    public int getMajor() {
        return this.major;
    }

    public void setMajor(int major) {
        Util.mustBePositive(major, "InitialVersion.major");
        this.major = major;
    }

    public int getMinor() {
        return this.minor;
    }

    public void setMinor(int minor) {
        Util.mustBePositive(minor, "InitialVersion.minor");
        this.minor = minor;
    }

    public int getPatch() {
        return this.patch;
    }

    public void setPatch(int patch) {
        Util.mustBePositive(patch, "InitialVersion.patch");
        this.patch = patch;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof InitialVersion)) {
            return false;
        }
        InitialVersion that = (InitialVersion)o;
        return this.major == that.major && this.minor == that.minor && this.patch == that.patch;
    }

    public int hashCode() {
        return Objects.hash(this.major, this.minor, this.patch);
    }
}

