/*
 * Decompiled with CFR 0.152.
 */
package com.github.manikmagar.maven.versioner.core.version;

import com.github.manikmagar.maven.versioner.core.version.AbstractVersionStrategy;
import com.github.manikmagar.maven.versioner.core.version.Version;
import com.github.manikmagar.maven.versioner.core.version.VersionComponentType;
import com.github.manikmagar.semver4j.SemVer;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;

public class SemVerStrategy
extends AbstractVersionStrategy {
    private final SemVer semVer;
    private final AtomicInteger commitCount = new AtomicInteger(0);

    public SemVerStrategy(int major, int minor, int patch, String branchName, String hashRef) {
        super(branchName, hashRef);
        this.semVer = SemVer.of((int)major, (int)minor, (int)patch);
    }

    public SemVerStrategy(String branchName, String hashRef) {
        super(branchName, hashRef);
        this.semVer = SemVer.zero();
    }

    @Override
    public String strategyName() {
        return "SemVer";
    }

    @Override
    public String toVersionString() {
        if (this.commitCount.get() > 0) {
            this.semVer.withNew(SemVer.build((String)this.getHashShort()));
        }
        return this.semVer.toString();
    }

    @Override
    public Version getVersion() {
        return new Version(this.getBranchName(), this.getHash(), this.semVer.getMajor(), this.semVer.getMinor(), this.semVer.getPatch(), this.commitCount.get());
    }

    @Override
    public void increment(VersionComponentType type, String hashRef) {
        Objects.requireNonNull(type, "Version component type must not be null");
        Objects.requireNonNull(hashRef, "Hash Reference must not be null");
        this.setHash(hashRef);
        switch (type) {
            case MAJOR: {
                this.onMajorIncrement();
                break;
            }
            case MINOR: {
                this.onMinorIncrement();
                break;
            }
            case PATCH: {
                this.onPatchIncrement();
                break;
            }
            case COMMIT: {
                this.onCommitIncrement();
            }
        }
    }

    private void onMajorIncrement() {
        this.semVer.incrementMajor();
        this.commitCount.set(0);
    }

    private void onMinorIncrement() {
        this.semVer.incrementMinor();
        this.commitCount.set(0);
    }

    private void onPatchIncrement() {
        this.semVer.incrementPatch();
        this.commitCount.set(0);
    }

    private void onCommitIncrement() {
        this.commitCount.incrementAndGet();
    }
}

