/*
 * Decompiled with CFR 0.152.
 */
package com.github.manikmagar.maven.versioner.core.version;

import com.github.manikmagar.maven.versioner.core.version.SemVerStrategy;
import java.util.regex.Pattern;

public class VersionPatternStrategy
extends SemVerStrategy {
    public static final String DEFAULT_VERSION_PATTERN = "%M.%m.%p(-%c)";
    private final String versionPattern;

    public VersionPatternStrategy(int major, int minor, int patch, String branchName, String hashRef, String versionPattern) {
        super(major, minor, patch, branchName, hashRef);
        this.versionPattern = versionPattern == null || versionPattern.trim().isEmpty() ? DEFAULT_VERSION_PATTERN : versionPattern;
    }

    public VersionPatternStrategy(String branchName, String hashRef, String versionPattern) {
        super(branchName, hashRef);
        this.versionPattern = versionPattern;
    }

    public VersionPatternStrategy(int major, int minor, int patch, String branchName, String hashRef) {
        this(major, minor, patch, branchName, hashRef, DEFAULT_VERSION_PATTERN);
    }

    public VersionPatternStrategy(String branchName, String hashRef) {
        this(branchName, hashRef, DEFAULT_VERSION_PATTERN);
    }

    public String getVersionPattern() {
        return this.versionPattern;
    }

    @Override
    public String toVersionString() {
        return new TokenReplacer(this.getVersionPattern()).replace(PatternToken.MAJOR, this.getVersion().getMajor()).replace(PatternToken.MINOR, this.getVersion().getMinor()).replace(PatternToken.PATCH, this.getVersion().getPatch()).replace(PatternToken.COMMIT, this.getVersion().getCommit()).replace(PatternToken.BRANCH, this.getVersion().getBranch()).replace(PatternToken.HASH_SHORT, this.getVersion().getHashShort()).replace(PatternToken.HASH, this.getVersion().getHash()).toString();
    }

    public static enum PatternToken {
        MAJOR("%M"),
        MINOR("%m"),
        PATCH("%p"),
        COMMIT("%c"),
        BRANCH("%b"),
        HASH_SHORT("%h"),
        HASH("%H");

        private final String token;
        private final String tokenGroupRegex;

        private PatternToken(String token) {
            this.token = token;
            this.tokenGroupRegex = String.format("(\\([^(]*%s[^)]*\\))", token);
        }

        public String getToken() {
            return this.token;
        }

        public String getTokenGroupRegex() {
            return this.tokenGroupRegex;
        }

        public String toString() {
            return this.getToken();
        }
    }

    public static class TokenReplacer {
        private String text;

        public TokenReplacer(String text) {
            this.text = text;
        }

        public TokenReplacer replace(PatternToken token, int value) {
            return this.replace(token, String.valueOf(value));
        }

        public TokenReplacer replace(PatternToken token, String value) {
            if (!this.text.contains(token.getToken())) {
                return this;
            }
            if (!PatternToken.COMMIT.equals((Object)token)) {
                if (this.text.contains(token.getToken())) {
                    this.text = this.text.replace(token.getToken(), value);
                }
            } else {
                String fullRegex = ".*" + token.getTokenGroupRegex() + ".*";
                if (Pattern.matches(fullRegex, this.text)) {
                    this.text = value != null && !value.trim().isEmpty() && !value.equals("0") ? this.text.replace(token.getToken(), value) : this.text.replaceAll(token.getTokenGroupRegex(), "");
                } else if (this.text.contains(token.getToken())) {
                    this.text = this.text.replace(token.getToken(), value);
                }
            }
            return this;
        }

        private String deTokenized() {
            return this.text.replace("(", "").replace(")", "");
        }

        public String toString() {
            return this.deTokenized();
        }
    }
}

