/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.client;

import com.github.tomakehurst.wiremock.client.CountMatchingStrategy;
import com.github.tomakehurst.wiremock.common.Json;
import com.github.tomakehurst.wiremock.matching.RequestPattern;
import com.github.tomakehurst.wiremock.verification.Diff;
import com.github.tomakehurst.wiremock.verification.LoggedRequest;
import com.github.tomakehurst.wiremock.verification.NearMiss;
import com.google.common.base.Functions;
import com.google.common.base.Joiner;
import com.google.common.collect.FluentIterable;
import java.util.List;

public class VerificationException
extends AssertionError {
    private static final long serialVersionUID = 5116216532516117538L;

    public VerificationException(String message) {
        super((Object)message);
    }

    public static VerificationException forUnmatchedRequestPattern(Diff diff) {
        return new VerificationException("No requests exactly matched. Most similar request was:", diff);
    }

    public static VerificationException forSingleUnmatchedRequest(Diff diff) {
        return new VerificationException("A request was unmatched by any stub mapping. Closest stub mapping was:", diff);
    }

    public static VerificationException forUnmatchedRequests(List<NearMiss> nearMisses) {
        if (nearMisses.size() == 1) {
            return VerificationException.forSingleUnmatchedRequest(nearMisses.get(0).getDiff());
        }
        return new VerificationException(nearMisses.size() + " requests were unmatched by any stub mapping. Shown with closest stub mappings:\n" + VerificationException.renderNearMisses(nearMisses));
    }

    private static String renderNearMisses(List<NearMiss> nearMisses) {
        return Joiner.on("\n\n").join(FluentIterable.from(nearMisses).transform(Functions.toStringFunction()));
    }

    public VerificationException(String messageStart, Diff diff) {
        super((Object)(messageStart + " " + diff.toString()));
    }

    public VerificationException(RequestPattern expected, List<LoggedRequest> requests) {
        super((Object)String.format("Expected at least one request matching: %s\nRequests received: %s", expected.toString(), Json.write(requests)));
    }

    public VerificationException(RequestPattern expected, int expectedCount, int actualCount) {
        super((Object)String.format("Expected exactly %d requests matching the following pattern but received only %d:\n%s", expectedCount, actualCount, expected.toString()));
    }

    public VerificationException(RequestPattern expected, CountMatchingStrategy expectedCount, int actualCount) {
        super((Object)String.format("Expected %s requests matching the following pattern but received %d:\n%s", expectedCount.toString().toLowerCase(), actualCount, expected.toString()));
    }
}

