/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.http;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.tomakehurst.wiremock.common.Encoding;
import com.github.tomakehurst.wiremock.common.Strings;
import com.github.tomakehurst.wiremock.http.Fault;
import com.github.tomakehurst.wiremock.http.HttpHeaders;
import com.github.tomakehurst.wiremock.http.Response;
import com.google.common.net.MediaType;
import java.nio.charset.Charset;

public class LoggedResponse {
    private final int status;
    private final HttpHeaders headers;
    private final byte[] body;
    private final Fault fault;

    public LoggedResponse(@JsonProperty(value="status") int status, @JsonProperty(value="headers") HttpHeaders headers, @JsonProperty(value="bodyAsBase64") String bodyAsBase64, @JsonProperty(value="fault") Fault fault, @JsonProperty(value="body") String ignoredBodyOnlyUsedForBinding) {
        this.status = status;
        this.headers = headers;
        this.body = Encoding.decodeBase64(bodyAsBase64);
        this.fault = fault;
    }

    public static LoggedResponse from(Response response) {
        return new LoggedResponse(response.getStatus(), response.getHeaders() == null || response.getHeaders().all().isEmpty() ? null : response.getHeaders(), Encoding.encodeBase64(response.getBody()), response.getFault(), null);
    }

    public int getStatus() {
        return this.status;
    }

    public HttpHeaders getHeaders() {
        return this.headers;
    }

    @JsonProperty(value="body")
    public String getBodyAsString() {
        if (this.body == null) {
            return "";
        }
        return Strings.stringFromBytes(this.body, this.getCharset());
    }

    @JsonIgnore
    public String getMimeType() {
        return this.headers == null || this.headers.getContentTypeHeader() == null ? MediaType.OCTET_STREAM.toString() : this.headers.getContentTypeHeader().mimeTypePart();
    }

    @JsonIgnore
    public Charset getCharset() {
        return this.headers == null ? Strings.DEFAULT_CHARSET : this.headers.getContentTypeHeader().charset();
    }

    @JsonIgnore
    public byte[] getBody() {
        return this.body;
    }

    @JsonProperty(value="bodyAsBase64")
    public String getBodyAsBase64() {
        return Encoding.encodeBase64(this.body);
    }

    public Fault getFault() {
        return this.fault;
    }
}

