/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.http;

import com.github.tomakehurst.wiremock.matching.StringValuePattern;
import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.Iterables;
import java.util.List;

public class MultiValue {
    protected final String key;
    protected final List<String> values;

    public MultiValue(String key, List<String> values) {
        this.key = key;
        this.values = values;
    }

    public boolean isPresent() {
        return this.values.size() > 0;
    }

    public String key() {
        return this.key;
    }

    public String firstValue() {
        this.checkPresent();
        return this.values.get(0);
    }

    public List<String> values() {
        this.checkPresent();
        return this.values;
    }

    private void checkPresent() {
        Preconditions.checkState(this.isPresent(), "No value for " + this.key);
    }

    public boolean isSingleValued() {
        return this.values.size() == 1;
    }

    public boolean containsValue(String expectedValue) {
        return this.values.contains(expectedValue);
    }

    public boolean hasValueMatching(StringValuePattern valuePattern) {
        return valuePattern.nullSafeIsAbsent() != false && !this.isPresent() || this.anyValueMatches(valuePattern);
    }

    private boolean anyValueMatches(final StringValuePattern valuePattern) {
        return Iterables.any(this.values, new Predicate<String>(){

            @Override
            public boolean apply(String headerValue) {
                return valuePattern.match(headerValue).isExactMatch();
            }
        });
    }

    public String toString() {
        return Joiner.on("\n").join(FluentIterable.from(this.values).transform(new Function<String, String>(){

            @Override
            public String apply(String value) {
                return MultiValue.this.key + ": " + value;
            }
        }));
    }
}

