/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.jetty9;

import com.github.tomakehurst.wiremock.common.Exceptions;
import com.github.tomakehurst.wiremock.core.FaultInjector;
import com.github.tomakehurst.wiremock.jetty9.JettyUtils;
import com.google.common.base.Charsets;
import java.io.IOException;
import java.net.Socket;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.io.SelectChannelEndPoint;
import org.eclipse.jetty.io.ssl.SslConnection;
import org.eclipse.jetty.server.HttpChannel;
import org.eclipse.jetty.server.Response;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.Callback;

public class JettyHttpsFaultInjector
implements FaultInjector {
    private static final byte[] GARBAGE = "lskdu018973t09sylgasjkfg1][]'./.sdlv".getBytes(Charsets.UTF_8);
    private final Response response;
    private final Socket socket;

    public JettyHttpsFaultInjector(HttpServletResponse response) {
        this.response = JettyUtils.unwrapResponse(response);
        HttpChannel<?> httpChannel = this.response.getHttpOutput().getHttpChannel();
        SslConnection.DecryptedEndPoint sslEndpoint = (SslConnection.DecryptedEndPoint)httpChannel.getEndPoint();
        SelectChannelEndPoint selectChannelEndPoint = (SelectChannelEndPoint)sslEndpoint.getSslConnection().getEndPoint();
        this.socket = selectChannelEndPoint.getSocket();
    }

    @Override
    public void emptyResponseAndCloseConnection() {
        try {
            this.socket.close();
        }
        catch (IOException e) {
            Exceptions.throwUnchecked(e);
        }
    }

    @Override
    public void malformedResponseChunk() {
        try {
            this.response.setStatus(200);
            this.response.flushBuffer();
            this.writeGarbageThenCloseSocket();
        }
        catch (IOException e) {
            Exceptions.throwUnchecked(e);
        }
    }

    @Override
    public void randomDataAndCloseConnection() {
        this.writeGarbageThenCloseSocket();
    }

    private void writeGarbageThenCloseSocket() {
        this.response.getHttpOutput().getHttpChannel().getEndPoint().write(new Callback(){

            @Override
            public void succeeded() {
                try {
                    JettyHttpsFaultInjector.this.socket.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }

            @Override
            public void failed(Throwable x) {
                try {
                    JettyHttpsFaultInjector.this.socket.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }, BufferUtil.toBuffer(GARBAGE));
    }
}

