/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.recording;

import com.github.tomakehurst.wiremock.client.WireMock;
import com.github.tomakehurst.wiremock.common.Errors;
import com.github.tomakehurst.wiremock.common.FileSource;
import com.github.tomakehurst.wiremock.common.InvalidRequestException;
import com.github.tomakehurst.wiremock.common.Json;
import com.github.tomakehurst.wiremock.common.LocalNotifier;
import com.github.tomakehurst.wiremock.core.Admin;
import com.github.tomakehurst.wiremock.core.Options;
import com.github.tomakehurst.wiremock.extension.StubMappingTransformer;
import com.github.tomakehurst.wiremock.recording.NotRecordingException;
import com.github.tomakehurst.wiremock.recording.ProxiedServeEventFilters;
import com.github.tomakehurst.wiremock.recording.RecordSpec;
import com.github.tomakehurst.wiremock.recording.RecordingStatus;
import com.github.tomakehurst.wiremock.recording.SnapshotRecordResult;
import com.github.tomakehurst.wiremock.recording.SnapshotStubMappingBodyExtractor;
import com.github.tomakehurst.wiremock.recording.SnapshotStubMappingGenerator;
import com.github.tomakehurst.wiremock.recording.SnapshotStubMappingPostProcessor;
import com.github.tomakehurst.wiremock.recording.SnapshotStubMappingTransformerRunner;
import com.github.tomakehurst.wiremock.stubbing.ServeEvent;
import com.github.tomakehurst.wiremock.stubbing.StubMapping;
import com.google.common.base.Predicate;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.UUID;

public class Recorder {
    private final Admin admin;
    private State state;

    public Recorder(Admin admin) {
        this.admin = admin;
        this.state = State.initial();
    }

    public synchronized void startRecording(RecordSpec spec) {
        if (this.state.getStatus() == RecordingStatus.Recording) {
            return;
        }
        if (spec.getTargetBaseUrl() == null || spec.getTargetBaseUrl().isEmpty()) {
            throw new InvalidRequestException(Errors.validation("/targetBaseUrl", "targetBaseUrl is required"));
        }
        StubMapping proxyMapping = WireMock.proxyAllTo(spec.getTargetBaseUrl()).build();
        this.admin.addStubMapping(proxyMapping);
        List<ServeEvent> serveEvents = this.admin.getServeEvents().getServeEvents();
        UUID initialId = serveEvents.isEmpty() ? null : serveEvents.get(0).getId();
        this.state = this.state.start(initialId, proxyMapping, spec);
        LocalNotifier.notifier().info("Started recording with record spec:\n" + Json.write(spec));
    }

    public synchronized SnapshotRecordResult stopRecording() {
        if (this.state.getStatus() != RecordingStatus.Recording) {
            throw new NotRecordingException();
        }
        List<ServeEvent> serveEvents = this.admin.getServeEvents().getServeEvents();
        UUID lastId = serveEvents.isEmpty() ? null : serveEvents.get(0).getId();
        this.state = this.state.stop(lastId);
        this.admin.removeStubMapping(this.state.getProxyMapping());
        if (serveEvents.isEmpty()) {
            return SnapshotRecordResult.empty();
        }
        int startIndex = this.state.getStartingServeEventId() == null ? serveEvents.size() : Iterables.indexOf(serveEvents, Recorder.withId(this.state.getStartingServeEventId()));
        int endIndex = Iterables.indexOf(serveEvents, Recorder.withId(this.state.getFinishingServeEventId()));
        List<ServeEvent> eventsToSnapshot = serveEvents.subList(endIndex, startIndex);
        SnapshotRecordResult result = this.takeSnapshot(eventsToSnapshot, this.state.getSpec());
        LocalNotifier.notifier().info("Stopped recording. Stubs captured:\n" + Json.write(result.getStubMappings()));
        return result;
    }

    private static Predicate<ServeEvent> withId(final UUID id) {
        return new Predicate<ServeEvent>(){

            @Override
            public boolean apply(ServeEvent input) {
                return input.getId().equals(id);
            }
        };
    }

    public SnapshotRecordResult takeSnapshot(List<ServeEvent> serveEvents, RecordSpec recordSpec) {
        List<StubMapping> stubMappings = this.serveEventsToStubMappings(Lists.reverse(serveEvents), recordSpec.getFilters(), new SnapshotStubMappingGenerator(recordSpec.getCaptureHeaders(), recordSpec.getRequestBodyPatternFactory()), this.getStubMappingPostProcessor(this.admin.getOptions(), recordSpec));
        for (StubMapping stubMapping : stubMappings) {
            if (recordSpec.shouldPersist()) {
                stubMapping.setPersistent(true);
            }
            this.admin.addStubMapping(stubMapping);
        }
        return recordSpec.getOutputFormat().format(stubMappings);
    }

    public List<StubMapping> serveEventsToStubMappings(List<ServeEvent> serveEventsResult, ProxiedServeEventFilters serveEventFilters, SnapshotStubMappingGenerator stubMappingGenerator, SnapshotStubMappingPostProcessor stubMappingPostProcessor) {
        FluentIterable<StubMapping> stubMappings = FluentIterable.from(serveEventsResult).filter(serveEventFilters).transform(stubMappingGenerator);
        return stubMappingPostProcessor.process(stubMappings);
    }

    public SnapshotStubMappingPostProcessor getStubMappingPostProcessor(Options options, RecordSpec recordSpec) {
        FileSource filesRoot = options.filesRoot().child("__files");
        SnapshotStubMappingTransformerRunner transformerRunner = new SnapshotStubMappingTransformerRunner(options.extensionsOfType(StubMappingTransformer.class).values(), recordSpec.getTransformers(), recordSpec.getTransformerParameters(), filesRoot);
        return new SnapshotStubMappingPostProcessor(recordSpec.shouldRecordRepeatsAsScenarios(), transformerRunner, recordSpec.getExtractBodyCriteria(), new SnapshotStubMappingBodyExtractor(filesRoot));
    }

    public RecordingStatus getStatus() {
        return this.state.getStatus();
    }

    private static class State {
        private final RecordingStatus status;
        private final StubMapping proxyMapping;
        private final RecordSpec spec;
        private final UUID startingServeEventId;
        private final UUID finishingServeEventId;

        public State(RecordingStatus status, StubMapping proxyMapping, RecordSpec spec, UUID startingServeEventId, UUID finishingServeEventId) {
            this.status = status;
            this.proxyMapping = proxyMapping;
            this.spec = spec;
            this.startingServeEventId = startingServeEventId;
            this.finishingServeEventId = finishingServeEventId;
        }

        public static State initial() {
            return new State(RecordingStatus.NeverStarted, null, null, null, null);
        }

        public State start(UUID startingServeEventId, StubMapping proxyMapping, RecordSpec spec) {
            return new State(RecordingStatus.Recording, proxyMapping, spec, startingServeEventId, null);
        }

        public State stop(UUID finishingServeEventId) {
            return new State(RecordingStatus.Stopped, this.proxyMapping, this.spec, this.startingServeEventId, finishingServeEventId);
        }

        public RecordingStatus getStatus() {
            return this.status;
        }

        public StubMapping getProxyMapping() {
            return this.proxyMapping;
        }

        public RecordSpec getSpec() {
            return this.spec;
        }

        public UUID getStartingServeEventId() {
            return this.startingServeEventId;
        }

        public UUID getFinishingServeEventId() {
            return this.finishingServeEventId;
        }
    }
}

