/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.servlet;

import com.github.tomakehurst.wiremock.common.Encoding;
import com.github.tomakehurst.wiremock.common.Gzip;
import com.github.tomakehurst.wiremock.common.Strings;
import com.github.tomakehurst.wiremock.common.Urls;
import com.github.tomakehurst.wiremock.http.ContentTypeHeader;
import com.github.tomakehurst.wiremock.http.Cookie;
import com.github.tomakehurst.wiremock.http.HttpHeader;
import com.github.tomakehurst.wiremock.http.HttpHeaders;
import com.github.tomakehurst.wiremock.http.QueryParameter;
import com.github.tomakehurst.wiremock.http.RequestMethod;
import com.github.tomakehurst.wiremock.jetty9.JettyUtils;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.io.ByteStreams;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.eclipse.jetty.server.Request;

public class WireMockHttpServletRequestAdapter
implements com.github.tomakehurst.wiremock.http.Request {
    private final HttpServletRequest request;
    private byte[] cachedBody;
    private String urlPrefixToRemove;

    public WireMockHttpServletRequestAdapter(HttpServletRequest request) {
        this.request = request;
    }

    public WireMockHttpServletRequestAdapter(HttpServletRequest request, String urlPrefixToRemove) {
        this.request = request;
        this.urlPrefixToRemove = urlPrefixToRemove;
    }

    @Override
    public String getUrl() {
        String url = this.request.getRequestURI();
        String contextPath = this.request.getContextPath();
        if (!com.google.common.base.Strings.isNullOrEmpty(contextPath) && url.startsWith(contextPath)) {
            url = url.substring(contextPath.length());
        }
        if (!com.google.common.base.Strings.isNullOrEmpty(this.urlPrefixToRemove) && url.startsWith(this.urlPrefixToRemove)) {
            url = url.substring(this.urlPrefixToRemove.length());
        }
        return this.withQueryStringIfPresent(url);
    }

    @Override
    public String getAbsoluteUrl() {
        return this.withQueryStringIfPresent(this.request.getRequestURL().toString());
    }

    private String withQueryStringIfPresent(String url) {
        return url + (com.google.common.base.Strings.isNullOrEmpty(this.request.getQueryString()) ? "" : "?" + this.request.getQueryString());
    }

    @Override
    public RequestMethod getMethod() {
        return RequestMethod.fromString(this.request.getMethod().toUpperCase());
    }

    @Override
    public String getClientIp() {
        String forwardedForHeader = this.getHeader("X-Forwarded-For");
        if (forwardedForHeader != null && forwardedForHeader.length() > 0) {
            return forwardedForHeader;
        }
        return this.request.getRemoteAddr();
    }

    @Override
    public byte[] getBody() {
        if (this.cachedBody == null) {
            try {
                byte[] body = ByteStreams.toByteArray(this.request.getInputStream());
                boolean isGzipped = this.hasGzipEncoding() || Gzip.isGzipped(body);
                this.cachedBody = isGzipped ? Gzip.unGzip(body) : body;
            }
            catch (IOException ioe) {
                throw new RuntimeException(ioe);
            }
        }
        return this.cachedBody;
    }

    private boolean hasGzipEncoding() {
        String encodingHeader = this.request.getHeader("Content-Encoding");
        return encodingHeader != null && encodingHeader.contains("gzip");
    }

    @Override
    public String getBodyAsString() {
        return Strings.stringFromBytes(this.getBody());
    }

    @Override
    public String getBodyAsBase64() {
        return Encoding.encodeBase64(this.getBody());
    }

    @Override
    public String getHeader(String key) {
        ArrayList<String> headerNames = Collections.list(this.request.getHeaderNames());
        for (String currentKey : headerNames) {
            if (!currentKey.toLowerCase().equals(key.toLowerCase())) continue;
            return this.request.getHeader(currentKey);
        }
        return null;
    }

    @Override
    public HttpHeader header(String key) {
        ArrayList<String> headerNames = Collections.list(this.request.getHeaderNames());
        for (String currentKey : headerNames) {
            if (!currentKey.toLowerCase().equals(key.toLowerCase())) continue;
            ArrayList<String> valueList = Collections.list(this.request.getHeaders(currentKey));
            if (valueList.isEmpty()) {
                return HttpHeader.empty(key);
            }
            return new HttpHeader(key, (Collection<String>)valueList);
        }
        return HttpHeader.absent(key);
    }

    @Override
    public ContentTypeHeader contentTypeHeader() {
        return this.getHeaders().getContentTypeHeader();
    }

    @Override
    public boolean containsHeader(String key) {
        return this.header(key).isPresent();
    }

    @Override
    public HttpHeaders getHeaders() {
        ArrayList<HttpHeader> headerList = Lists.newArrayList();
        for (String key : this.getAllHeaderKeys()) {
            headerList.add(this.header(key));
        }
        return new HttpHeaders(headerList);
    }

    @Override
    public Set<String> getAllHeaderKeys() {
        LinkedHashSet<String> headerKeys = new LinkedHashSet<String>();
        Enumeration<String> headerNames = this.request.getHeaderNames();
        while (headerNames.hasMoreElements()) {
            headerKeys.add(headerNames.nextElement());
        }
        return headerKeys;
    }

    @Override
    public Map<String, Cookie> getCookies() {
        ImmutableMap.Builder<String, Cookie> builder = ImmutableMap.builder();
        for (javax.servlet.http.Cookie cookie : MoreObjects.firstNonNull(this.request.getCookies(), new javax.servlet.http.Cookie[0])) {
            builder.put(cookie.getName(), WireMockHttpServletRequestAdapter.convertCookie(cookie));
        }
        return builder.build();
    }

    private static Cookie convertCookie(javax.servlet.http.Cookie servletCookie) {
        return new Cookie(servletCookie.getValue());
    }

    @Override
    public QueryParameter queryParameter(String key) {
        return MoreObjects.firstNonNull(Urls.splitQuery(this.request.getQueryString()).get(key), QueryParameter.absent(key));
    }

    @Override
    public boolean isBrowserProxyRequest() {
        if (!this.isJetty()) {
            return false;
        }
        if (this.request instanceof Request) {
            Request jettyRequest = (Request)this.request;
            return JettyUtils.getUri(jettyRequest).isAbsolute();
        }
        return false;
    }

    private boolean isJetty() {
        try {
            this.getClass("org.eclipse.jetty.server.Request");
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    private void getClass(String type) throws ClassNotFoundException {
        ClassLoader contextCL = Thread.currentThread().getContextClassLoader();
        ClassLoader loader = contextCL == null ? WireMockHttpServletRequestAdapter.class.getClassLoader() : contextCL;
        Class.forName(type, false, loader);
    }

    public String toString() {
        return this.request.toString() + this.getBodyAsString();
    }
}

