/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.verification;

import com.github.tomakehurst.wiremock.common.Json;
import com.github.tomakehurst.wiremock.common.Xml;
import com.github.tomakehurst.wiremock.http.Cookie;
import com.github.tomakehurst.wiremock.http.HttpHeader;
import com.github.tomakehurst.wiremock.http.Request;
import com.github.tomakehurst.wiremock.http.RequestMethod;
import com.github.tomakehurst.wiremock.matching.BinaryEqualToPattern;
import com.github.tomakehurst.wiremock.matching.ContentPattern;
import com.github.tomakehurst.wiremock.matching.EqualToJsonPattern;
import com.github.tomakehurst.wiremock.matching.EqualToPattern;
import com.github.tomakehurst.wiremock.matching.EqualToXmlPattern;
import com.github.tomakehurst.wiremock.matching.MultiValuePattern;
import com.github.tomakehurst.wiremock.matching.NamedValueMatcher;
import com.github.tomakehurst.wiremock.matching.RequestPattern;
import com.github.tomakehurst.wiremock.matching.StringValuePattern;
import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.MoreObjects;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.io.BaseEncoding;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class Diff {
    private final RequestPattern requestPattern;
    private final Request request;
    final Section<String> SPACER = new Section<String>(new EqualToPattern(""), "", "");
    private static Function<Section<?>, Object> EXPECTED = new Function<Section<?>, Object>(){

        @Override
        public Object apply(Section<?> input) {
            return input.getExpected();
        }
    };
    private static Function<Section<?>, Object> ACTUAL = new Function<Section<?>, Object>(){

        @Override
        public Object apply(Section<?> input) {
            return input.getActual();
        }
    };

    public Diff(RequestPattern expected, Request actual) {
        this.requestPattern = expected;
        this.request = actual;
    }

    public String toString() {
        List<ContentPattern<?>> bodyPatterns;
        if (this.requestPattern.hasCustomMatcher()) {
            return "(Request pattern had a custom matcher so no diff can be shown)";
        }
        ImmutableList.Builder builder = ImmutableList.builder();
        Section<RequestMethod> methodSection = new Section<RequestMethod>(this.requestPattern.getMethod(), this.request.getMethod(), this.requestPattern.getMethod().getName());
        builder.add(methodSection);
        Section<String> urlSection = new Section<String>(this.requestPattern.getUrlMatcher(), this.request.getUrl(), this.requestPattern.getUrlMatcher().getExpected());
        builder.add(urlSection);
        if (((Section)methodSection).shouldBeIncluded() || ((Section)urlSection).shouldBeIncluded()) {
            builder.add(this.SPACER);
        }
        boolean anyHeaderSections = false;
        Map<String, MultiValuePattern> headerPatterns = this.requestPattern.combineBasicAuthAndOtherHeaders();
        if (headerPatterns != null && !headerPatterns.isEmpty()) {
            for (String key : headerPatterns.keySet()) {
                String printedPatternValue;
                HttpHeader header = this.request.header(key);
                MultiValuePattern multiValuePattern = headerPatterns.get(header.key());
                Section<HttpHeader> section = new Section<HttpHeader>(multiValuePattern, header, printedPatternValue = header.key() + ": " + multiValuePattern.getExpected());
                if (((Section)section).shouldBeIncluded()) {
                    anyHeaderSections = true;
                }
                builder.add(section);
            }
        }
        if (anyHeaderSections) {
            builder.add(this.SPACER);
        }
        boolean anyCookieSections = false;
        if (this.requestPattern.getCookies() != null) {
            Map cookies = MoreObjects.firstNonNull(this.request.getCookies(), Collections.emptyMap());
            for (Map.Entry entry : this.requestPattern.getCookies().entrySet()) {
                String key = (String)entry.getKey();
                StringValuePattern pattern = (StringValuePattern)entry.getValue();
                Cookie cookie = MoreObjects.firstNonNull(cookies.get(key), Cookie.absent());
                Section<String> section = new Section<String>(pattern, cookie.isPresent() ? "Cookie: " + key + "=" + cookie.getValue() : "", "Cookie: " + key + "=" + (String)pattern.getValue());
                builder.add(section);
                anyCookieSections = true;
            }
        }
        if (anyCookieSections) {
            builder.add(this.SPACER);
        }
        if ((bodyPatterns = this.requestPattern.getBodyPatterns()) != null && !bodyPatterns.isEmpty()) {
            for (ContentPattern contentPattern : bodyPatterns) {
                String body = this.formatIfJsonOrXml(contentPattern);
                if (StringValuePattern.class.isAssignableFrom(contentPattern.getClass())) {
                    StringValuePattern stringValuePattern = (StringValuePattern)contentPattern;
                    builder.add(new Section<String>(stringValuePattern, body, contentPattern.getExpected()));
                    continue;
                }
                BinaryEqualToPattern nonStringPattern = (BinaryEqualToPattern)contentPattern;
                builder.add(new Section<byte[]>(nonStringPattern, body.getBytes(), contentPattern.getExpected()));
            }
        }
        ImmutableCollection sections = builder.build();
        String string = Joiner.on("\n").join(FluentIterable.from(sections).transform(EXPECTED));
        String actual = Joiner.on("\n").join(FluentIterable.from(sections).transform(ACTUAL));
        return sections.isEmpty() ? "" : Diff.junitStyleDiffMessage(string, actual);
    }

    private String formatIfJsonOrXml(ContentPattern<?> pattern) {
        try {
            return pattern.getClass().equals(EqualToJsonPattern.class) ? Json.prettyPrint(this.request.getBodyAsString()) : (pattern.getClass().equals(EqualToXmlPattern.class) ? Xml.prettyPrint(this.request.getBodyAsString()) : (pattern.getClass().equals(BinaryEqualToPattern.class) ? BaseEncoding.base64().encode(this.request.getBody()) : this.request.getBodyAsString()));
        }
        catch (Exception e) {
            return this.request.getBodyAsString();
        }
    }

    public static String junitStyleDiffMessage(Object expected, Object actual) {
        return String.format(" expected:<\n%s> but was:<\n%s>", expected, actual);
    }

    private class Section<V> {
        private final NamedValueMatcher<V> pattern;
        private final V value;
        private final String printedPatternValue;

        public Section(NamedValueMatcher<V> pattern, V value, String printedPatternValue) {
            this.pattern = pattern;
            this.value = value;
            this.printedPatternValue = printedPatternValue;
        }

        public Object getExpected() {
            return this.shouldBeIncluded() ? this.printedPatternValue : this.value;
        }

        public Object getActual() {
            return this.value;
        }

        private boolean shouldBeIncluded() {
            return !this.pattern.match(this.value).isExactMatch();
        }
    }
}

