/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.verification;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.tomakehurst.wiremock.common.Dates;
import com.github.tomakehurst.wiremock.common.Encoding;
import com.github.tomakehurst.wiremock.common.Json;
import com.github.tomakehurst.wiremock.common.Strings;
import com.github.tomakehurst.wiremock.common.Urls;
import com.github.tomakehurst.wiremock.http.ContentTypeHeader;
import com.github.tomakehurst.wiremock.http.Cookie;
import com.github.tomakehurst.wiremock.http.HttpHeader;
import com.github.tomakehurst.wiremock.http.HttpHeaders;
import com.github.tomakehurst.wiremock.http.QueryParameter;
import com.github.tomakehurst.wiremock.http.Request;
import com.github.tomakehurst.wiremock.http.RequestMethod;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import java.net.URI;
import java.util.Date;
import java.util.Map;
import java.util.Set;

@JsonIgnoreProperties(ignoreUnknown=true)
public class LoggedRequest
implements Request {
    private final String url;
    private final String absoluteUrl;
    private final String clientIp;
    private final RequestMethod method;
    private final HttpHeaders headers;
    private final Map<String, Cookie> cookies;
    private final Map<String, QueryParameter> queryParams;
    private final byte[] body;
    private final boolean isBrowserProxyRequest;
    private final Date loggedDate;

    public static LoggedRequest createFrom(Request request) {
        return new LoggedRequest(request.getUrl(), request.getAbsoluteUrl(), request.getMethod(), request.getClientIp(), HttpHeaders.copyOf(request.getHeaders()), ImmutableMap.copyOf(request.getCookies()), request.isBrowserProxyRequest(), new Date(), request.getBodyAsBase64(), null);
    }

    @JsonCreator
    public LoggedRequest(@JsonProperty(value="url") String url, @JsonProperty(value="absoluteUrl") String absoluteUrl, @JsonProperty(value="method") RequestMethod method, @JsonProperty(value="clientIp") String clientIp, @JsonProperty(value="headers") HttpHeaders headers, @JsonProperty(value="cookies") Map<String, Cookie> cookies, @JsonProperty(value="browserProxyRequest") boolean isBrowserProxyRequest, @JsonProperty(value="loggedDate") Date loggedDate, @JsonProperty(value="bodyAsBase64") String bodyAsBase64, @JsonProperty(value="body") String ignoredBodyOnlyUsedForBinding) {
        this.url = url;
        this.absoluteUrl = absoluteUrl;
        this.clientIp = clientIp;
        this.method = method;
        this.body = Encoding.decodeBase64(bodyAsBase64);
        this.headers = headers;
        this.cookies = cookies;
        this.queryParams = Urls.splitQuery(URI.create(url));
        this.isBrowserProxyRequest = isBrowserProxyRequest;
        this.loggedDate = loggedDate;
    }

    @Override
    public String getUrl() {
        return this.url;
    }

    @Override
    public String getAbsoluteUrl() {
        return this.absoluteUrl;
    }

    @Override
    public RequestMethod getMethod() {
        return this.method;
    }

    @Override
    public String getClientIp() {
        return this.clientIp;
    }

    @Override
    @JsonIgnore
    public String getHeader(String key) {
        HttpHeader header = this.header(key);
        if (header.isPresent()) {
            return header.firstValue();
        }
        return null;
    }

    @Override
    public HttpHeader header(String key) {
        return this.headers.getHeader(key);
    }

    @Override
    public ContentTypeHeader contentTypeHeader() {
        return this.headers.getContentTypeHeader();
    }

    @Override
    public boolean containsHeader(String key) {
        return this.getHeader(key) != null;
    }

    @Override
    public Map<String, Cookie> getCookies() {
        return this.cookies;
    }

    @Override
    public byte[] getBody() {
        return this.body;
    }

    @Override
    @JsonProperty(value="body")
    public String getBodyAsString() {
        return Strings.stringFromBytes(this.body);
    }

    @Override
    @JsonProperty(value="bodyAsBase64")
    public String getBodyAsBase64() {
        return Encoding.encodeBase64(this.body);
    }

    @Override
    @JsonIgnore
    public Set<String> getAllHeaderKeys() {
        return this.headers.keys();
    }

    @Override
    public QueryParameter queryParameter(String key) {
        return MoreObjects.firstNonNull(this.queryParams.get(key), QueryParameter.absent(key));
    }

    @JsonProperty(value="queryParams")
    public Map<String, QueryParameter> getQueryParams() {
        return this.queryParams;
    }

    @Override
    public HttpHeaders getHeaders() {
        return this.headers;
    }

    @Override
    public boolean isBrowserProxyRequest() {
        return this.isBrowserProxyRequest;
    }

    public Date getLoggedDate() {
        return this.loggedDate;
    }

    public String getLoggedDateString() {
        return Dates.format(this.loggedDate);
    }

    public String toString() {
        return Json.write(this);
    }
}

