/*
 * Decompiled with CFR 0.152.
 */
package com.github.masonm;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.masonm.Jwt;
import com.github.tomakehurst.wiremock.extension.Parameters;
import com.github.tomakehurst.wiremock.http.Request;
import com.github.tomakehurst.wiremock.matching.MatchResult;
import com.github.tomakehurst.wiremock.matching.RequestMatcherExtension;
import com.github.tomakehurst.wiremock.matching.RequestPattern;
import java.util.Map;
import java.util.Objects;

public class JwtMatcherExtension
extends RequestMatcherExtension {
    public static final String NAME = "jwt-matcher";
    public static final String PARAM_NAME_PAYLOAD = "payload";
    public static final String PARAM_NAME_HEADER = "header";
    public static final String PARAM_NAME_REQUEST = "request";

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public MatchResult match(Request request, Parameters parameters) {
        Parameters requestParameters;
        RequestPattern requestPattern;
        if (!parameters.containsKey(PARAM_NAME_PAYLOAD) && !parameters.containsKey(PARAM_NAME_HEADER)) {
            return MatchResult.noMatch();
        }
        if (parameters.containsKey(PARAM_NAME_REQUEST) && !(requestPattern = (requestParameters = Parameters.of(parameters.get(PARAM_NAME_REQUEST))).as(RequestPattern.class)).match(request).isExactMatch()) {
            return MatchResult.noMatch();
        }
        String authString = request.getHeader("Authorization");
        if (authString == null || authString.isEmpty()) {
            return MatchResult.noMatch();
        }
        Jwt token = Jwt.fromAuthHeader(authString);
        if (parameters.containsKey(PARAM_NAME_HEADER) && !this.matchParams(token.getHeader(), parameters.get(PARAM_NAME_HEADER))) {
            return MatchResult.noMatch();
        }
        if (parameters.containsKey(PARAM_NAME_PAYLOAD) && !this.matchParams(token.getPayload(), parameters.get(PARAM_NAME_PAYLOAD))) {
            return MatchResult.noMatch();
        }
        return MatchResult.exactMatch();
    }

    private boolean matchParams(JsonNode tokenValues, Object parameters) {
        Map parameterMap = (Map)new ObjectMapper().convertValue(parameters, new TypeReference<Map<String, Object>>(){});
        for (Map.Entry entry : parameterMap.entrySet()) {
            String tokenValue = tokenValues.path((String)entry.getKey()).asText();
            if (Objects.equals(tokenValue, entry.getValue())) continue;
            return false;
        }
        return true;
    }
}

