/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.admin;

import com.github.tomakehurst.wiremock.admin.AdminUriTemplate;
import com.github.tomakehurst.wiremock.admin.model.PathParams;
import com.github.tomakehurst.wiremock.http.RequestMethod;
import com.google.common.base.Preconditions;

public class RequestSpec {
    private final RequestMethod method;
    private final AdminUriTemplate uriTemplate;

    public RequestSpec(RequestMethod method, String uriTemplate) {
        Preconditions.checkNotNull(method);
        Preconditions.checkNotNull(uriTemplate);
        this.method = method;
        this.uriTemplate = new AdminUriTemplate(uriTemplate);
    }

    public static RequestSpec requestSpec(RequestMethod method, String path) {
        return new RequestSpec(method, path);
    }

    public RequestMethod method() {
        return this.method;
    }

    public AdminUriTemplate getUriTemplate() {
        return this.uriTemplate;
    }

    public String path() {
        return this.path(PathParams.empty());
    }

    public String path(PathParams pathParams) {
        return this.uriTemplate.render(pathParams);
    }

    public boolean matches(RequestMethod method, String path) {
        return (this.method.equals(RequestMethod.ANY) || this.method.equals(method)) && this.uriTemplate.matches(path);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RequestSpec that = (RequestSpec)o;
        if (!this.method.equals(that.method)) {
            return false;
        }
        return this.uriTemplate.equals(that.uriTemplate);
    }

    public int hashCode() {
        int result = this.method.hashCode();
        result = 31 * result + this.uriTemplate.hashCode();
        return result;
    }
}

