/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.common;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Collections;
import java.util.List;

public class Errors {
    private final List<Error> errors;

    public Errors(@JsonProperty(value="errors") List<Error> errors) {
        this.errors = errors;
    }

    public static Errors single(Integer code, String sourcePointer, String title) {
        return new Errors(Collections.singletonList(new Error(code, new Error.Source(sourcePointer), title)));
    }

    public static Errors single(Integer code, String sourcePointer, String title, String detail) {
        return new Errors(Collections.singletonList(new Error(code, new Error.Source(sourcePointer), title, detail)));
    }

    public static Errors single(Integer code, String title) {
        return new Errors(Collections.singletonList(new Error(code, title)));
    }

    public static Errors notRecording() {
        return Errors.single(30, "Not currently recording.");
    }

    public static Errors validation(String pointer, String message) {
        return Errors.single(10, pointer, message);
    }

    public Error first() {
        if (this.errors.isEmpty()) {
            throw new IllegalStateException("No errors are present");
        }
        return this.errors.get(0);
    }

    public List<Error> getErrors() {
        return this.errors;
    }

    public static class Error {
        private final Integer code;
        private final Source source;
        private final String title;
        private final String detail;

        public Error(@JsonProperty(value="code") Integer code, @JsonProperty(value="source") Source source, @JsonProperty(value="title") String title, @JsonProperty(value="detail") String detail) {
            this.code = code;
            this.source = source;
            this.title = title;
            this.detail = detail;
        }

        public Error(int code, Source source, String title) {
            this(code, source, title, null);
        }

        public Error(int code, String title) {
            this(code, null, title, null);
        }

        public Integer getCode() {
            return this.code;
        }

        public Source getSource() {
            return this.source;
        }

        public String getTitle() {
            return this.title;
        }

        public String getDetail() {
            return this.detail;
        }

        public static class Source {
            private final String pointer;

            public Source(@JsonProperty(value="pointer") String pointer) {
                this.pointer = pointer;
            }

            public String getPointer() {
                return this.pointer;
            }
        }
    }
}

