/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.matching;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.tomakehurst.wiremock.http.Body;
import com.github.tomakehurst.wiremock.http.Request;
import com.github.tomakehurst.wiremock.matching.BinaryEqualToPattern;
import com.github.tomakehurst.wiremock.matching.ContentPattern;
import com.github.tomakehurst.wiremock.matching.MatchResult;
import com.github.tomakehurst.wiremock.matching.MultiValuePattern;
import com.github.tomakehurst.wiremock.matching.StringValuePattern;
import com.github.tomakehurst.wiremock.matching.ValueMatcher;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.FluentIterable;
import java.util.List;
import java.util.Map;

public class MultipartValuePattern
implements ValueMatcher<Request.Part> {
    private final String name;
    private final Map<String, MultiValuePattern> headers;
    private final List<ContentPattern<?>> bodyPatterns;
    private final MatchingType matchingType;

    @JsonCreator
    public MultipartValuePattern(@JsonProperty(value="name") String name, @JsonProperty(value="matchingType") MatchingType type, @JsonProperty(value="headers") Map<String, MultiValuePattern> headers, @JsonProperty(value="bodyPatterns") List<ContentPattern<?>> body) {
        this.name = name;
        this.matchingType = type;
        this.headers = headers;
        this.bodyPatterns = body;
    }

    @JsonIgnore
    public boolean isMatchAny() {
        return this.matchingType == MatchingType.ANY;
    }

    @JsonIgnore
    public boolean isMatchAll() {
        return this.matchingType == MatchingType.ALL;
    }

    @Override
    public MatchResult match(Request.Part value) {
        if (this.headers != null || this.bodyPatterns != null) {
            return MatchResult.aggregate(this.headers != null ? this.matchHeaderPatterns(value) : MatchResult.exactMatch(), this.bodyPatterns != null ? this.matchBodyPatterns(value) : MatchResult.exactMatch());
        }
        return MatchResult.exactMatch();
    }

    @Override
    public MatchResult match(Request request) {
        return this.isMatchAll() ? this.matchAllMultiparts(request) : this.matchAnyMultipart(request);
    }

    private MatchResult matchAllMultiparts(Request request) {
        return FluentIterable.from(request.getParts()).allMatch(new Predicate<Request.Part>(){

            @Override
            public boolean apply(Request.Part input) {
                return MultipartValuePattern.this.match(input).isExactMatch();
            }
        }) ? MatchResult.exactMatch() : MatchResult.noMatch();
    }

    private MatchResult matchAnyMultipart(Request request) {
        return FluentIterable.from(request.getParts()).anyMatch(new Predicate<Request.Part>(){

            @Override
            public boolean apply(Request.Part input) {
                return MultipartValuePattern.this.match(input).isExactMatch();
            }
        }) ? MatchResult.exactMatch() : MatchResult.noMatch();
    }

    public String getName() {
        return this.name;
    }

    public Map<String, MultiValuePattern> getHeaders() {
        return this.headers;
    }

    public MatchingType getMatchingType() {
        return this.matchingType;
    }

    public List<ContentPattern<?>> getBodyPatterns() {
        return this.bodyPatterns;
    }

    private MatchResult matchHeaderPatterns(final Request.Part part) {
        if (this.headers != null && !this.headers.isEmpty()) {
            return MatchResult.aggregate(FluentIterable.from(this.headers.entrySet()).transform(new Function<Map.Entry<String, MultiValuePattern>, MatchResult>(){

                @Override
                public MatchResult apply(Map.Entry<String, MultiValuePattern> headerPattern) {
                    return headerPattern.getValue().match(part.getHeader(headerPattern.getKey()));
                }
            }).toList());
        }
        return MatchResult.exactMatch();
    }

    private MatchResult matchBodyPatterns(final Request.Part value) {
        return MatchResult.aggregate(FluentIterable.from(this.bodyPatterns).transform(new Function<ContentPattern, MatchResult>(){

            @Override
            public MatchResult apply(ContentPattern bodyPattern) {
                return MultipartValuePattern.matchBody(value, bodyPattern);
            }
        }).toList());
    }

    private static MatchResult matchBody(Request.Part part, ContentPattern<?> bodyPattern) {
        Body body = part.getBody();
        if (body == null) {
            return MatchResult.noMatch();
        }
        if (BinaryEqualToPattern.class.isAssignableFrom(bodyPattern.getClass())) {
            return ((BinaryEqualToPattern)bodyPattern).match(body.asBytes());
        }
        return ((StringValuePattern)bodyPattern).match(body.asString());
    }

    public static enum MatchingType {
        ALL,
        ANY;

    }
}

