/*
 * Decompiled with CFR 0.152.
 */
package org.custommonkey.xmlunit.examples;

import java.io.IOException;
import java.io.Reader;
import junit.framework.Assert;
import org.custommonkey.xmlunit.XMLUnit;
import org.custommonkey.xmlunit.XpathEngine;
import org.custommonkey.xmlunit.exceptions.XpathException;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XPathRegexAssert {
    private static final String EXPECTED_VALUE_TO_MATCH = "expected value to match ";

    private XPathRegexAssert() {
    }

    public static void assertXPathMatches(String message, String regex, String xpath, Document doc) throws XpathException {
        XpathEngine engine = XMLUnit.newXpathEngine();
        String value = engine.evaluate(xpath, doc);
        Assert.assertTrue(message, value.matches(regex));
    }

    public static void assertXPathMatches(String message, String regex, String xpath, String xml) throws XpathException, SAXException, IOException {
        Document doc = XMLUnit.buildControlDocument(xml);
        XPathRegexAssert.assertXPathMatches(message, regex, xpath, doc);
    }

    public static void assertXPathMatches(String message, String regex, String xpath, Reader reader) throws XpathException, SAXException, IOException {
        Document doc = XMLUnit.buildControlDocument(new InputSource(reader));
        XPathRegexAssert.assertXPathMatches(message, regex, xpath, doc);
    }

    public static void assertXPathMatches(String regex, String xpath, Document doc) throws XpathException {
        XPathRegexAssert.assertXPathMatches(EXPECTED_VALUE_TO_MATCH + regex, regex, xpath, doc);
    }

    public static void assertXPathMatches(String regex, String xpath, String xml) throws XpathException, SAXException, IOException {
        XPathRegexAssert.assertXPathMatches(EXPECTED_VALUE_TO_MATCH + regex, regex, xpath, xml);
    }

    public static void assertXPathMatches(String regex, String xpath, Reader reader) throws XpathException, SAXException, IOException {
        XPathRegexAssert.assertXPathMatches(EXPECTED_VALUE_TO_MATCH + regex, regex, xpath, reader);
    }
}

