/*
 * Decompiled with CFR 0.152.
 */
package com.github.jknack.handlebars.helper;

import com.github.jknack.handlebars.Handlebars;
import com.github.jknack.handlebars.Helper;
import com.github.jknack.handlebars.Options;
import com.github.jknack.handlebars.internal.JSEngine;
import com.github.jknack.handlebars.io.TemplateSource;
import java.io.IOException;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;

public final class PrecompileHelper
implements Helper<String> {
    public static final String NAME = "precompile";
    public static final Helper<String> INSTANCE = new PrecompileHelper();

    private PrecompileHelper() {
    }

    @Override
    public Object apply(String path, Options options) throws IOException {
        Validate.notEmpty(path, "found: '%s', expected 'template path'", path);
        String wrapperName = (String)options.hash("wrapper", "anonymous");
        JsWrapper wrapper = JsWrapper.wrapper(wrapperName);
        Validate.notNull(wrapper, "found '%s', expected: '%s'", wrapperName, StringUtils.join((Object[])JsWrapper.values(), ", ").toLowerCase());
        Handlebars handlebars = options.handlebars;
        String name = path;
        if (name.startsWith("/")) {
            name = name.substring(1);
        }
        if (wrapper == JsWrapper.AMD) {
            name = name + handlebars.getLoader().getSuffix();
        }
        TemplateSource source = handlebars.getLoader().sourceAt(path);
        String precompiled = JSEngine.RHINO.toJavaScript(handlebars.handlebarsJsFile(), source.filename(), source.content(handlebars.getCharset()));
        return new Handlebars.SafeString(wrapper.wrap(name, precompiled));
    }

    private static enum JsWrapper {
        ANONYMOUS{

            @Override
            public void header(String name, StringBuilder buffer) {
                buffer.append("(function() {");
            }

            @Override
            public void tail(StringBuilder buffer) {
                buffer.append("})();");
            }
        }
        ,
        AMD{

            @Override
            public void header(String name, StringBuilder buffer) {
                buffer.append("define('").append(name).append("', ['handlebars'], function(Handlebars) {");
            }

            @Override
            public void tail(StringBuilder buffer) {
                buffer.append("  return template;\n");
                buffer.append("});");
            }

            @Override
            public void registerTemplate(StringBuilder buffer, String name, String function) {
                String templateName = name.substring(0, name.lastIndexOf(46));
                super.registerTemplate(buffer, templateName, function);
            }
        }
        ,
        NONE{

            @Override
            public void header(String name, StringBuilder buffer) {
            }

            @Override
            public void tail(StringBuilder buffer) {
            }
        };


        public abstract void header(String var1, StringBuilder var2);

        public abstract void tail(StringBuilder var1);

        public void registerTemplate(StringBuilder buffer, String name, String function) {
            buffer.append("\n  var template = Handlebars.template(").append(function).append(");\n");
            String[] namespaces = new String[]{"templates", "partials"};
            String separator = ";\n";
            for (String namespace : namespaces) {
                buffer.append("  var ").append(namespace).append(" = Handlebars.").append(namespace).append(" = Handlebars.").append(namespace).append(" || {};\n");
                buffer.append("  ").append(namespace).append("['").append(name).append("'] = template").append(separator);
            }
        }

        public CharSequence wrap(String name, String function) {
            StringBuilder buffer = new StringBuilder();
            this.header(name, buffer);
            this.registerTemplate(buffer, name, function);
            this.tail(buffer);
            return buffer;
        }

        public static JsWrapper wrapper(String name) {
            for (JsWrapper wrapper : JsWrapper.values()) {
                if (!name.equalsIgnoreCase(wrapper.name())) continue;
                return wrapper;
            }
            return null;
        }
    }
}

