/*
 * Decompiled with CFR 0.152.
 */
package com.quatrix.api;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.quatrix.api.FileTransferApi;
import com.quatrix.api.QuatrixApiException;
import com.quatrix.api.model.UploadResult;
import com.squareup.okhttp.MediaType;
import com.squareup.okhttp.OkHttpClient;
import com.squareup.okhttp.Request;
import com.squareup.okhttp.RequestBody;
import com.squareup.okhttp.Response;
import io.swagger.client.ApiClient;
import io.swagger.client.ApiException;
import io.swagger.client.Pair;
import io.swagger.client.api.FileApi;
import io.swagger.client.api.UploadApi;
import io.swagger.client.model.IdsReq;
import io.swagger.client.model.UploadFinalizeResp;
import io.swagger.client.model.UploadLinkReq;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.UUID;

final class FileTransferApiImpl
implements FileTransferApi {
    private static final String X_AUTH_TOKEN_HEADER = "X-Auth-Token";
    private static final int MAX_UPLOAD_BUFFER_LEN = 0x400000;
    private final ApiClient client;
    private final UploadApi uploadApi;
    private final FileApi fileApi;

    FileTransferApiImpl(ApiClient client) {
        this.client = client;
        this.uploadApi = new UploadApi(client);
        this.fileApi = new FileApi(client);
    }

    @Override
    public UploadResult uploadFile(UUID dirId, File file, String name, boolean resolveConflict) throws QuatrixApiException {
        UUID uploadKey = this.retrieveUploadKey(dirId, file, name, resolveConflict);
        this.uploadFile(file, uploadKey);
        return UploadResult.from(this.finalizeUpload(uploadKey));
    }

    @Override
    public File downloadFile(UUID fileId) throws QuatrixApiException {
        return this.download(this.retrieveDownloadLink(fileId));
    }

    private UploadFinalizeResp finalizeUpload(UUID uploadKey) throws QuatrixApiException {
        try {
            return this.uploadApi.uploadFinalizeIdGet(uploadKey, null);
        }
        catch (ApiException e) {
            throw new QuatrixApiException(e);
        }
    }

    private void uploadFile(File file, UUID uploadKey) throws QuatrixApiException {
        try (FileInputStream fileStream = new FileInputStream(file);){
            this.uploadToServer(fileStream, (MediaType)this.resolveMediaType(file).orNull(), uploadKey);
        }
        catch (IOException e) {
            throw new QuatrixApiException(e.getMessage(), e);
        }
    }

    private Optional<MediaType> resolveMediaType(File file) throws IOException {
        return Optional.fromNullable((Object)Files.probeContentType(file.toPath())).transform((Function)new Function<String, MediaType>(){

            public MediaType apply(String s) {
                return MediaType.parse((String)s);
            }
        });
    }

    private void uploadToServer(InputStream content, MediaType mediaType, UUID uploadKey) throws QuatrixApiException, IOException {
        String url = String.format("%s/upload/chunked/%s", this.client.getBasePath().replace("/api/1.0", ""), uploadKey);
        long contentLength = content.available();
        long readBytes = 0L;
        long totalReadBytes = 0L;
        while (readBytes >= 0L) {
            int buffSize = Math.min(0x400000, (int)(contentLength - totalReadBytes));
            byte[] buffer = new byte[Math.max(buffSize, 1)];
            readBytes = content.read(buffer);
            if (readBytes <= 0L) continue;
            String contentRange = String.format("bytes %d-%d/%d", totalReadBytes, totalReadBytes + readBytes - 1L, contentLength);
            Response response = this.client.getHttpClient().newCall(new Request.Builder().url(url).header(X_AUTH_TOKEN_HEADER, this.getAuthToken()).header("Content-Range", contentRange).post(RequestBody.create((MediaType)mediaType, (byte[])buffer)).build()).execute();
            this.assertResponseSuccessful(response, "Unable to upload file");
            totalReadBytes += readBytes;
        }
    }

    private void assertResponseSuccessful(Response response, String errorMsg) throws QuatrixApiException {
        if (!response.isSuccessful()) {
            throw new QuatrixApiException(errorMsg, response.code());
        }
    }

    private UUID retrieveUploadKey(UUID dirId, File file, String name, boolean resolveConflict) throws QuatrixApiException {
        UploadLinkReq req = new UploadLinkReq().parentId(dirId).name(name).fileSize(BigDecimal.valueOf(file.length())).resolve(resolveConflict);
        try {
            return this.uploadApi.uploadLinkPost(req).getUploadKey();
        }
        catch (ApiException e) {
            throw new QuatrixApiException(e);
        }
    }

    private UUID retrieveDownloadLink(UUID fileId) throws QuatrixApiException {
        try {
            IdsReq ids = new IdsReq().ids(Collections.singletonList(fileId));
            return this.fileApi.fileDownloadLinkPost(ids).getId();
        }
        catch (ApiException e) {
            throw new QuatrixApiException(e);
        }
    }

    private File download(UUID downloadLink) throws QuatrixApiException {
        String url = String.format("%s/file/download/%s", this.client.getBasePath(), downloadLink);
        OkHttpClient httpClient = this.client.getHttpClient();
        try {
            Response response = httpClient.newCall(new Request.Builder().url(url).header(X_AUTH_TOKEN_HEADER, this.getAuthToken()).header("Accept", "application/octet-stream").get().build()).execute();
            this.assertResponseSuccessful(response, "Unable to download file");
            return this.client.downloadFileFromResponse(response);
        }
        catch (IOException e) {
            throw new QuatrixApiException(e.getMessage(), e);
        }
        catch (ApiException e) {
            throw new QuatrixApiException(e);
        }
    }

    private String getAuthToken() {
        HashMap<String, String> headers = new HashMap<String, String>();
        this.client.getAuthentication("api_key").applyToParams(new ArrayList<Pair>(), headers);
        return (String)headers.get(X_AUTH_TOKEN_HEADER);
    }
}

